__author__ = "Suyash Soni"
__email__ = "suyash.soni248@gmail.com"

class ErrorCode(object):
    NON_STANDARD_ERROR = 'NON_STANDARD_ERROR'
    INVALID_FIELD = "INVALID_FIELD"
    REQUIRED_FIELD = "REQUIRED_FIELD"
    INVALID_DATA_TYPE = "INVALID_DATA_TYPE"
    UNSUPPORTED_FIELDS = "UNSUPPORTED_FIELDS"
    INVALID_IMAGE_FORMAT = 'INVALID_IMAGE_FORMAT'
    INVALID_IMAGE_SIZE = 'INVALID_IMAGE_SIZE'
    NOT_ENOUGH_PARAMETERS = 'NOT_ENOUGH_PARAMETERS'
    INVALID_OPERATOR = 'INVALID_OPERATOR'
    INVALID_FILE_FORMAT = 'INVALID_FILE_FORMAT'
    INVALID_DATA = 'INVALID_DATA'
    EXTERNAL_APP_ERROR = 'EXTERNAL_APP_ERROR'
    INVALID_SOURCE = 'INVALID_SOURCE'

class DBErrorCode(ErrorCode):
    DB_CREATE_EXISTS = 'CREATE_EXISTS'
    SYNTAX_ERROR = 'SYNTAX_ERROR'
    PARSE_ERROR = 'PARSE_ERROR'
    NO_SUCH_TABLE = 'NO_SUCH_TABLE'
    WRONG_DB_NAME = 'WRONG_DB_NAME'
    WRONG_TABLE_NAME = 'WRONG_TABLE_NAME'
    FIELD_SPECIFIED_TWICE = 'FIELD_SPECIFIED_TWICE'
    INVALID_GROUP_FUNC_USE = 'INVALID_GROUP_FUNC_USE'
    UNSUPPORTED_EXTENSION = 'UNSUPPORTED_EXTENSION'
    TABLE_MUST_HAVE_COLUMNS = 'TABLE_MUST_HAVE_COLUMNS'
    CANT_DO_THIS_DURING_AN_TRANSACTION = 'CANT_DO_THIS_DURING_AN_TRANSACTION'
    WARN_DATA_TRUNCATED = 'WARN_DATA_TRUNCATED'
    WARN_NULL_TO_NOTNULL = 'WARN_NULL_TO_NOTNULL'
    WARN_DATA_OUT_OF_RANGE = 'WARN_DATA_OUT_OF_RANGE'
    NO_DEFAULT = 'NO_DEFAULT'
    PRIMARY_CANT_HAVE_NULL = 'PRIMARY_CANT_HAVE_NULL'
    DATA_TOO_LONG = 'DATA_TOO_LONG'
    DATETIME_FUNCTION_OVERFLOW = 'DATETIME_FUNCTION_OVERFLOW'
    DUP_ENTRY = 'DUP_ENTRY'
    NO_REFERENCED_ROW = 'NO_REFERENCED_ROW'
    NO_REFERENCED_ROW_2 = 'NO_REFERENCED_ROW_2'
    ROW_IS_REFERENCED = 'ROW_IS_REFERENCED'
    ROW_IS_REFERENCED_2 = 'ROW_IS_REFERENCED_2'
    CANNOT_ADD_FOREIGN = 'CANNOT_ADD_FOREIGN'
    BAD_NULL_ERROR = 'BAD_NULL_ERROR'
    WARNING_NOT_COMPLETE_ROLLBACK = 'WARNING_NOT_COMPLETE_ROLLBACK'
    NOT_SUPPORTED_YET = 'NOT_SUPPORTED_YET'
    FEATURE_DISABLED = 'FEATURE_DISABLED'
    UNKNOWN_STORAGE_ENGINE = 'UNKNOWN_STORAGE_ENGINE'
    DBACCESS_DENIED_ERROR = 'DBACCESS_DENIED_ERROR'
    ACCESS_DENIED_ERROR = 'ACCESS_DENIED_ERROR'
    CON_COUNT_ERROR = 'CON_COUNT_ERROR'
    TABLEACCESS_DENIED_ERROR = 'TABLEACCESS_DENIED_ERROR'
    COLUMNACCESS_DENIED_ERROR = 'COLUMNACCESS_DENIED_ERROR'
    CONSTRAINT_FAILED = 'CONSTRAINT_FAILED'
    TRUNCATED_WRONG_VALUE_FOR_FIELD = 'TRUNCATED_WRONG_VALUE_FOR_FIELD'
    BAD_DB_ERROR = "DATABASE_NOT_FOUND"

    # Custom error constants starts from here...
    INVALID_FORMAT = 'INVALID_FORMAT'

