# SQLAlchemy-ORM
ORM framework for Python. Designed for simplicity, based on [SQLAlchemy](https://www.sqlalchemy.org/).

[![coverage report](https://gitlab.com/parob/sqlalchemy-orm/badges/master/coverage.svg)](https://gitlab.com/parob/sqlalchemy-orm/commits/master)

[![pipeline status](https://gitlab.com/parob/sqlalchemy-orm/badges/master/pipeline.svg)](https://gitlab.com/parob/sqlalchemy-orm/commits/master)


Check out the tests directory for more examples.

## Basic Example
``` python
from sqlalachemy_orm import Model, Database

Base = Model()

class Animal(Base):
    name: str
    age: int

db = Database("sqlite:///:memory:") # use an in-memory SQLite database
db.create(Animal)  # Create the `Animal` table in the database

bea = Animal(name="bea", age=5)

session = db.session()
session.create(bea) # Create a row in the `Animal` table

print(session.query(Animal).filter(Animal.name == "bea").one())

session.commit() # commit the session to the database
```

``` text
$ python example.py
>>> Animal(name='bea', age=5)
```