from typing import Any, Optional, Union, TypeVar, Generic, Type, Callable, ClassVar, Tuple, Mapping, overload, Text as typing_Text
from .. import util
from .visitors import Visitable as Visitable, VisitableType as VisitableType
from .base import SchemaEventTarget as SchemaEventTarget
from . import operators
from .sqltypes import NullType, Integer, Boolean, String, MatchType, Indexable
from ..engine.interfaces import Dialect
from .elements import ColumnElement, BindParameter

_T = TypeVar('_T')
_T_co = TypeVar('_T_co', covariant=True)
_U = TypeVar('_U')

# TODO: simplify import cycle with sqltypes
BOOLEANTYPE: Boolean = ...
INTEGERTYPE: Integer = ...
NULLTYPE: NullType = ...
STRINGTYPE: String = ...
MATCHTYPE: MatchType = ...
INDEXABLE: Indexable = ...

_TE = TypeVar('_TE', bound=TypeEngine)

# It is not 100% clear that TypeEngine is covariant at this stage since
# many types are still missing. Anyway, this looks plausible and practical.
class TypeEngine(Visitable, Generic[_T_co]):
    class Comparator(operators.ColumnOperators):
        default_comparator: Any = ...
        expr: Any = ...
        type: Any = ...
        def __init__(self, expr) -> None: ...
        def operate(self, op, *other, **kwargs): ...
        def reverse_operate(self, op, other, **kwargs): ...
        def __reduce__(self): ...
    hashable: bool = ...
    comparator_factory: Type[Any] = ...
    should_evaluate_none: bool = ...
    def evaluates_none(self: _TE) -> _TE: ...
    def copy(self: _TE, **kw: Any) -> _TE: ...
    def compare_against_backend(self, dialect: Dialect, conn_type: Any) -> Any: ...
    def copy_value(self, value: _T) -> _T: ...
    def literal_processor(self, dialect: Dialect) -> Optional[Callable[..., Any]]: ...
    def bind_processor(self, dialect: Dialect) -> Optional[Callable[..., Any]]: ...
    def result_processor(self, dialect: Dialect, coltype: Any) -> Optional[Callable[..., Any]]: ...
    def column_expression(self, colexpr: Union[str, ColumnElement[Any]]) -> Optional[ColumnElement[Any]]: ...
    def bind_expression(self, bindvalue: BindParameter[Any]) -> Optional[Any]: ...
    def compare_values(self, x: Any, y: Any) -> bool: ...
    def get_dbapi_type(self, dbapi: Any) -> Any: ...
    @property
    def python_type(self) -> Type[_T_co]: ...
    def with_variant(self, type_: TypeEngine[_U], dialect_name: str) -> Variant[_U]: ...
    def dialect_impl(self, dialect: Dialect): ...
    def adapt(self, cls: Type[_U], **kw: Any) -> _U: ...
    def coerce_compared_value(self, op: Any, value: Any) -> TypeEngine[Any]: ...
    def compile(self, dialect: Optional[Dialect] = ...): ...

class VisitableCheckKWArg(util.EnsureKWArgType, VisitableType): ...

_UDT = TypeVar('_UDT', bound=UserDefinedType)

class UserDefinedType(TypeEngine[_T], metaclass=VisitableCheckKWArg):
    __visit_name__: str = ...
    ensure_kwarg: str = ...
    class Comparator(TypeEngine.Comparator): ...
    comparator_factory: Type[Any] = ...
    def coerce_compared_value(self: _UDT, op: Any, value: Any) -> _UDT: ...

class Emulated(object):
    def adapt_to_emulated(self, impltype: Type[Any], **kw: Any) -> Any: ...
    def adapt(self, cls: Type[Any], **kw: Any) -> Any: ...

_NFE = TypeVar('_NFE', bound=NativeForEmulated)

class NativeForEmulated(object):
    @classmethod
    def adapt_emulated_to_native(cls: Type[_NFE], impl: Any, **kw: Any) -> _NFE: ...

_TD = TypeVar('_TD', bound=TypeDecorator)

class TypeDecorator(SchemaEventTarget, TypeEngine[_T]):
    __visit_name__: str = ...
    impl: Any = ...  # impl is Type[TypeEngine[Any]] on the class, but TypeEngine[Any] on instances
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    coerce_to_is_types: Tuple[Type[Any], ...] = ...
    class Comparator(TypeEngine.Comparator):
        def operate(self, op, *other, **kwargs): ...
        def reverse_operate(self, op, other, **kwargs): ...
    # Signature of comparator factory incompatible with supertype TypeEngine
    @property
    def comparator_factory(self) -> Type[Any]: ...  # type: ignore
    def type_engine(self, dialect: Dialect) -> TypeEngine[Any]: ...
    def load_dialect_impl(self, dialect: Dialect) -> TypeEngine[Any]: ...
    def __getattr__(self, key: str) -> Any: ...
    def process_literal_param(self, value: Optional[_T], dialect: Dialect) -> Optional[str]: ...
    def process_bind_param(self, value: Optional[_T], dialect: Dialect) -> Optional[typing_Text]: ...
    def process_result_value(self, value: Optional[Any], dialect: Dialect) -> Optional[_T]: ...
    def literal_processor(self, dialect: Dialect) -> Callable[[Optional[_T]], Optional[str]]: ...
    def bind_processor(self, dialect: Dialect) -> Callable[[Optional[_T]], Optional[str]]: ...
    def result_processor(self, dialect: Dialect, coltype) -> Callable[[Optional[Any]], Optional[_T]]: ...
    def coerce_compared_value(self: _TD, op: Any, value: Any) -> Union[_TD, TypeEngine[Any]]: ...
    def copy(self: _TD, **kw: Any) -> _TD: ...
    def get_dbapi_type(self, dbapi: Any) -> Any: ...
    def compare_values(self, x: Any, y: Any) -> bool: ...

_VT = TypeVar('_VT', bound=Variant)

class Variant(TypeDecorator[_T]):
    mapping: Any = ...
    def __init__(self, base: TypeEngine[_T], mapping: Mapping[str, TypeEngine[Any]]) -> None: ...
    def coerce_compared_value(self: _VT, operator: Any, value: Any) -> Union[_VT, TypeEngine[_T]]: ...
    def load_dialect_impl(self, dialect: Dialect) -> TypeEngine[Any]: ...
    def with_variant(self, type_: TypeEngine[_U], dialect_name: str) -> Variant[_U]: ...
    # Signature of comparator factory incompatible with supertype TypeEngine
    @property
    def comparator_factory(self) -> Type[Any]: ...  # type: ignore

@overload
def to_instance(typeobj: Type[TypeEngine[_T]], *arg: Any, **kw: Any) -> TypeEngine[_T]: ...
@overload
def to_instance(typeobj: TypeEngine[_T], *arg: Any, **kw: Any) -> TypeEngine[_T]: ...
def adapt_type(typeobj: Any, colspecs: Mapping[Any, Any]) -> Any: ...
