"""Implement an enum containing every rule used (or declared) in the grammar."""

from enum import Enum


class RulesTypes(Enum):
    """Their value is a string containing the name of each rule exactly the way it appear in the grammar.

    Their name is just an upcased version with the exact same letters.
    """

    STATEMENTS_LIST = "statements_list"
    EXPLAIN = "explain"
    STATEMENT = "statement"
    OPTIONAL_EXPLAINABLE_STATEMENT = "optional_explainable_statement"

    TRANSACTION_CONTROL_STATEMENT = "transaction_control_statement"
    SELECT_STATEMENT = "select_statement"
    INSERT_STATEMENT = "insert_statement"
    DELETE_STATEMENT = "delete_statement"
    UPDATE_STATEMENT = "update_statement"
    CREATE_TABLE_STATEMENT = "create_table_statement"
    DROP_TABLE_STATEMENT = "drop_table_statement"
    ALTER_TABLE_STATEMENT = "alter_table_statement"
    CREATE_VIEW_STATEMENT = "create_view_statement"
    DROP_VIEW_STATEMENT = "drop_view_statement"
    CREATE_INDEX_STATEMENT = "create_index_statement"
    DROP_INDEX_STATEMENT = "drop_index_statement"
    VACUUM_STATEMENT = "vacuum_statement"
    PRAGMA_STATEMENT = "pragma_statement"
    CREATE_TRIGGER_STATEMENT = "create_trigger_statement"
    DROP_TRIGGER_STATEMENT = "drop_trigger_statement"
    ATTACH_DATABASE_STATEMENT = "attach_database_statement"
    DETACH_DATABASE_STATEMENT = "detach_database_statement"
    ANALYZE_STATEMENT = "analyze_statement"
    CREATE_VIRTUAL_TABLE_STATEMENT = "create_virtual_table_statement"
    BEGIN_STATEMENT = "begin_statement"
    COMMIT_STATEMENT = "commit_statement"
    ROLLBACK_STATEMENT = "rollback_statement"
    SAVEPOINT_STATEMENT = "savepoint_statement"
    RELEASE_STATEMENT = "release_statement"
    EXPRESSION = "expression"
    TERM = "term"
    LIKE_OP = "like_op"
    BETWEEN_OP = "between_op"
    IN_OP = "in_op"
    CASE_WHEN_LIST = "case_when_list"
    WITH_COMMON_TABLE_EXPRESSIONS = "with_common_table_expressions"
    COMMON_TABLE_EXPRESSION = "common_table_expression"
    WINDOWS_DEFINITIONS = "windows_definitions"
    WINDOW_DEFINITION = "window_definition"
    WINDOW = "window"
    BETWEEN_FRAME_BOUND = "between_frame_bound"
    RANGE_OR_ROWS = "range_or_rows"
    FRAME_BOUND_START = "frame_bound_start"
    FRAME_BOUND_END = "frame_bound_end"
    FRAME_BOUND = "frame_bound"
    FRAME_EXCLUDE_TARGET = "frame_exclude_target"
    COMPOUND_SELECT = "compound_select"
    MULTISELECT_OPERATOR = "multiselect_operator"
    SELECT_CORE = "select_core"
    VALUES_CLAUSE = "values_clause"
    ONE_OR_MULTIPLE_VALUES = "one_or_multiple_values"
    CREATE_TABLE_ARGS = "create_table_args"
    TABLE_OPTION_SET = "table_option_set"
    TABLE_CONSTRAINTS = "table_constraints"
    TABLE_OPTION = "table_option"
    COLUMNS_DECLARATIONS = "columns_declarations"
    TABLE_CONSTRAINT = "table_constraint"
    TRIGGER_ACTIONS = "trigger_actions"
    TRIGGER_ACTION = "trigger_action"
    TRIGGER_TIME = "trigger_time"
    TRIGGER_EVENT = "trigger_event"
    FROM_CLAUSE = "from_clause"
    JOIN_CLAUSE = "join_clause"
    TABLE_OR_SUBQUERY_JOIN_CONSTRAINT = "table_or_subquery_join_constraint"
    TABLE_OR_SUBQUERY = "table_or_subquery"
    JOIN_OPERATOR = "join_operator"
    EXPLICIT_JOIN_OPERATOR = "explicit_join_operator"
    COMMA_JOIN_OPERATOR = "comma_join_operator"
    COLUMN_DECLARATION = "column_declaration"
    COLUMN_CONSTRAINTS = "column_constraints"
    COLUMN_CONSTRAINT = "column_constraint"
    UPSERT_RETURNING = "upsert_returning"
    UPSERT_CLAUSE = "upsert_clause"
    TARGETED_ON_CONFLICTS = "targeted_on_conflicts"
    TARGETED_ON_CONFLICT = "targeted_on_conflict"
    CONFLICT_TARGET = "conflict_target"
    UPSERT_ON_CONFLICT_ACTION = "upsert_on_conflict_action"
    RETURNING = "returning"
    DEFER_SUBCLAUSE = "defer_subclause"
    REFERENCE_ARGUMENTS = "reference_arguments"
    REFERENCE_ARGUMENT = "reference_argument"
    REFERENCE_ACTION = "reference_action"
    CONSTRAINT_CONFLICT_CLAUSE = "constraint_conflict_clause"
    ALTER_TABLE_SUBCOMMAND = "alter_table_subcommand"
    IF_NOT_EXISTS = "if_not_exists"
    TWO_PARTS_NAME = "two_parts_name"
    ALIASABLE_NAME = "aliasable_name"
    OR_CONFLICT = "or_conflict"
    RESOLVE_TYPE = "resolve_type"
    IF_EXISTS = "if_exists"
    DISTINCT = "distinct"
    SELECT_COLUMN = "select_column"
    SELECT_COLUMNS = "select_columns"
    ON_CLAUSE = "on_clause"
    USING_CLAUSE = "using_clause"
    INDEXED_BY = "indexed_by"
    SORT_LIST = "sort_list"
    SORTED_NULLS_PLACED_EXPRESSION = "sorted_nulls_placed_expression"
    SORT_ORDER = "sort_order"
    NULLS_POSITION = "nulls_position"
    WHERE_CLAUSE = "where_clause"
    SET_LIST = "set_list"
    SET = "set"
    INSERT_CMD = "insert_cmd"
    COMMA_SEPARATED_NAME_LIST = "comma_separated_name_list"
    FILTER_OVER = "filter_over"
    OVER_CLAUSE = "over_clause"
    COMMA_SEPARATED_EXPRESSIONS = "comma_separated_expressions"
    PARENTHESIZED_LEGACY_ID_LIST = "parenthesized_legacy_id_list"
    LEGACY_ID_LIST = "legacy_id_list"
    LEGACY_ID = "legacy_id"
    FORBIDDEN_INDEX_BY = "forbidden_index_by"
    RAISE_TYPE = "raise_type"
    PRAGMA_VALUE = "pragma_value"
    TYPE = "type"
    TYPE_NAME = "type_name"
    ALIAS = "alias"
    NAME = "name"
    SIGNED_NUMBER = "signed_number"
    POSITIVE_NUMBER = "positive_number"
    NEGATIVE_NUMBER = "negative_number"
    VIRTUAL_TABLE_ARGUMENTS = "virtual_table_arguments"
    VIRTUAL_TABLE_ARGUMENT_COMPONENT = "virtual_table_argument_component"
    ANYS = "anys"
    IDENTIFIER = "identifier"
    FALLBACK = "fallback"
    ANY = "any"


__all__ = [
    "RulesTypes",
]
