"""Define every token used by SQLite."""

from enum import Enum


class TokenType(Enum):
    """Names follow those defined by sqlite."""

    TK_SEMI = "SEMI"
    TK_EXPLAIN = "EXPLAIN"
    TK_QUERY = "QUERY"
    TK_PLAN = "PLAN"
    TK_BEGIN = "BEGIN"
    TK_TRANSACTION = "TRANSACTION"
    TK_DEFERRED = "DEFERRED"
    TK_IMMEDIATE = "IMMEDIATE"
    TK_EXCLUSIVE = "EXCLUSIVE"
    TK_COMMIT = "COMMIT"
    TK_END = "END"
    TK_ROLLBACK = "ROLLBACK"
    TK_SAVEPOINT = "SAVEPOINT"
    TK_RELEASE = "RELEASE"
    TK_TO = "TO"
    TK_TABLE = "TABLE"
    TK_CREATE = "CREATE"
    TK_IF = "IF"
    TK_NOT = "NOT"
    TK_EXISTS = "EXISTS"
    TK_TEMP = "TEMP"
    TK_LP = "LP"
    TK_RP = "RP"
    TK_AS = "AS"
    TK_COMMA = "COMMA"
    TK_WITHOUT = "WITHOUT"
    TK_ABORT = "ABORT"
    TK_ACTION = "ACTION"
    TK_AFTER = "AFTER"
    TK_ANALYZE = "ANALYZE"
    TK_ASC = "ASC"
    TK_ATTACH = "ATTACH"
    TK_BEFORE = "BEFORE"
    TK_BY = "BY"
    TK_CASCADE = "CASCADE"
    TK_CAST = "CAST"
    TK_CONFLICT = "CONFLICT"
    TK_DATABASE = "DATABASE"
    TK_DESC = "DESC"
    TK_DETACH = "DETACH"
    TK_EACH = "EACH"
    TK_FAIL = "FAIL"
    TK_OR = "OR"
    TK_AND = "AND"
    TK_IS = "IS"
    TK_MATCH = "MATCH"
    TK_LIKE_KW = "LIKE_KW"
    TK_BETWEEN = "BETWEEN"
    TK_IN = "IN"
    TK_ISNULL = "ISNULL"
    TK_NOTNULL = "NOTNULL"
    TK_NE = "NE"
    TK_EQ = "EQ"
    TK_GT = "GT"
    TK_LE = "LE"
    TK_LT = "LT"
    TK_GE = "GE"
    TK_ESCAPE = "ESCAPE"
    TK_ID = "ID"
    TK_COLUMNKW = "COLUMNKW"
    TK_DO = "DO"
    TK_FOR = "FOR"
    TK_IGNORE = "IGNORE"
    TK_INITIALLY = "INITIALLY"
    TK_INSTEAD = "INSTEAD"
    TK_NO = "NO"
    TK_KEY = "KEY"
    TK_OF = "OF"
    TK_OFFSET = "OFFSET"
    TK_PRAGMA = "PRAGMA"
    TK_RAISE = "RAISE"
    TK_RECURSIVE = "RECURSIVE"
    TK_REPLACE = "REPLACE"
    TK_RESTRICT = "RESTRICT"
    TK_ROW = "ROW"
    TK_ROWS = "ROWS"
    TK_TRIGGER = "TRIGGER"
    TK_VACUUM = "VACUUM"
    TK_VIEW = "VIEW"
    TK_VIRTUAL = "VIRTUAL"
    TK_WITH = "WITH"
    TK_NULLS = "NULLS"
    TK_FIRST = "FIRST"
    TK_LAST = "LAST"
    TK_CURRENT = "CURRENT"
    TK_FOLLOWING = "FOLLOWING"
    TK_PARTITION = "PARTITION"
    TK_PRECEDING = "PRECEDING"
    TK_RANGE = "RANGE"
    TK_UNBOUNDED = "UNBOUNDED"
    TK_EXCLUDE = "EXCLUDE"
    TK_GROUPS = "GROUPS"
    TK_OTHERS = "OTHERS"
    TK_TIES = "TIES"
    TK_GENERATED = "GENERATED"
    TK_ALWAYS = "ALWAYS"
    TK_MATERIALIZED = "MATERIALIZED"
    TK_REINDEX = "REINDEX"
    TK_RENAME = "RENAME"
    TK_CTIME_KW = "CTIME_KW"
    TK_ANY = "ANY"
    TK_BITAND = "BITAND"
    TK_BITOR = "BITOR"
    TK_LSHIFT = "LSHIFT"
    TK_RSHIFT = "RSHIFT"
    TK_PLUS = "PLUS"
    TK_MINUS = "MINUS"
    TK_STAR = "STAR"
    TK_SLASH = "SLASH"
    TK_REM = "REM"
    TK_CONCAT = "CONCAT"
    TK_PTR = "PTR"
    TK_COLLATE = "COLLATE"
    TK_BITNOT = "BITNOT"
    TK_ON = "ON"
    TK_INDEXED = "INDEXED"
    TK_STRING = "STRING"
    TK_JOIN_KW = "JOIN_KW"
    TK_CONSTRAINT = "CONSTRAINT"
    TK_DEFAULT = "DEFAULT"
    TK_NULL = "NULL"
    TK_PRIMARY = "PRIMARY"
    TK_UNIQUE = "UNIQUE"
    TK_CHECK = "CHECK"
    TK_REFERENCES = "REFERENCES"
    TK_AUTOINCR = "AUTOINCR"
    TK_INSERT = "INSERT"
    TK_DELETE = "DELETE"
    TK_UPDATE = "UPDATE"
    TK_SET = "SET"
    TK_DEFERRABLE = "DEFERRABLE"
    TK_FOREIGN = "FOREIGN"
    TK_DROP = "DROP"
    TK_UNION = "UNION"
    TK_ALL = "ALL"
    TK_EXCEPT = "EXCEPT"
    TK_INTERSECT = "INTERSECT"
    TK_SELECT = "SELECT"
    TK_VALUES = "VALUES"
    TK_DISTINCT = "DISTINCT"
    TK_DOT = "DOT"
    TK_FROM = "FROM"
    TK_JOIN = "JOIN"
    TK_USING = "USING"
    TK_ORDER = "ORDER"
    TK_GROUP = "GROUP"
    TK_HAVING = "HAVING"
    TK_LIMIT = "LIMIT"
    TK_WHERE = "WHERE"
    TK_RETURNING = "RETURNING"
    TK_INTO = "INTO"
    TK_NOTHING = "NOTHING"
    TK_FLOAT = "FLOAT"
    TK_BLOB = "BLOB"
    TK_INTEGER = "INTEGER"
    TK_VARIABLE = "VARIABLE"
    TK_CASE = "CASE"
    TK_WHEN = "WHEN"
    TK_THEN = "THEN"
    TK_ELSE = "ELSE"
    TK_INDEX = "INDEX"
    TK_ALTER = "ALTER"
    TK_ADD = "ADD"
    TK_WINDOW = "WINDOW"
    TK_OVER = "OVER"
    TK_FILTER = "FILTER"
    TK_COLUMN = "COLUMN"
    TK_AGG_FUNCTION = "AGG_FUNCTION"
    TK_AGG_COLUMN = "AGG_COLUMN"
    TK_TRUEFALSE = "TRUEFALSE"
    TK_ISNOT = "ISNOT"
    TK_FUNCTION = "FUNCTION"
    TK_UPLUS = "UPLUS"
    TK_UMINUS = "UMINUS"
    TK_TRUTH = "TRUTH"
    TK_REGISTER = "REGISTER"
    TK_VECTOR = "VECTOR"
    TK_SELECT_COLUMN = "SELECT_COLUMN"
    TK_IF_NULL_ROW = "IF_NULL_ROW"
    TK_ASTERISK = "ASTERISK"
    TK_SPAN = "SPAN"
    TK_ERROR = "ERROR"
    TK_QNUMBER = "QNUMBER"
    TK_SPACE = "SPACE"
    TK_ILLEGAL = "ILLEGAL"


token_conversion_table = list(TokenType)


class ETokenType(Enum):
    """Give extra informations on a token. Uses execution path of the tokenizer or any other information."""

    NO_INFO = "NO_INFO"
    DOUBLE_DASH_COMMENT = "DOUBLE_DASH_COMMENT"


e_token_conversion_table = list(ETokenType)


ignored_tokens = frozenset({TokenType.TK_SPACE})
