import { Menu } from '@headlessui/react'
import { CheckIcon } from '@heroicons/react/24/outline'
import { CogIcon } from '@/components/graph/CogIcon'
import clsx from 'clsx'

interface SettingsControlProps {
  showColumns: boolean
  onWithColumnsChange: (value: boolean) => void
}

export function SettingsControl({
  showColumns,
  onWithColumnsChange,
}: SettingsControlProps): JSX.Element {
  return (
    <Menu
      as="div"
      className="relative"
    >
      <Menu.Button
        className="react-flow__controls-button"
        title="Settings"
      >
        <CogIcon
          className="h-3 w-3"
          aria-hidden="true"
        />
      </Menu.Button>
      <Menu.Items className="absolute bottom-0 left-full ml-2 w-56 origin-bottom-left divide-y bg-theme shadow-lg focus:outline-none z-50">
        <Menu.Item>
          {({ active }) => (
            <button
              className={clsx(
                'group flex w-full items-center px-2 py-1 text-sm',
                'text-[var(--vscode-button-foreground)]',
                active
                  ? 'bg-[var(--vscode-button-background)]'
                  : 'bg-[var(--vscode-button-hoverBackground)]',
              )}
              onClick={() => onWithColumnsChange(!showColumns)}
            >
              <span className="flex-1 text-left">Show Columns</span>
              {showColumns && (
                <CheckIcon
                  className="h-4 w-4 text-primary-500"
                  aria-hidden="true"
                />
              )}
            </button>
          )}
        </Menu.Item>
      </Menu.Items>
    </Menu>
  )
}
