# SQLObjects AI Assistant Rules

Best practices and usage patterns for SQLObjects, optimized for AI coding assistants.

## Quick Navigation

- **[01. Database & Session Guide](01-database-session-guide.md)** - Connection management and transactions
- **[02. Model Definition Guide](02-model-definition-guide.md)** - Model creation and field configuration
- **[03. Query Operations Guide](03-query-operations-guide.md)** - Filtering, sorting, and data retrieval
- **[04. CRUD Operations Guide](04-crud-operations-guide.md)** - Create, read, update, delete operations
- **[05. Relationships Guide](05-relationships-guide.md)** - Model relationships and loading strategies
- **[06. Validation & Signals Guide](06-validation-signals-guide.md)** - Data validation and lifecycle hooks
- **[07. Performance Guide](07-performance-guide.md)** - Optimization techniques and best practices

## Purpose

These rules provide concise, actionable guidance for using SQLObjects effectively. Each guide includes:

- **Core Concepts** - Essential understanding
- **Common Usage** - Most frequent patterns with code examples
- **Best Practices** - Do's and don'ts
- **Performance Tips** - Optimization considerations
- **Troubleshooting** - Common issues and solutions

## For AI Assistants

When helping users with SQLObjects:

1. **Reference the appropriate guide** based on the user's question
2. **Use the code examples** as templates
3. **Follow the best practices** outlined in each guide
4. **Consider performance implications** mentioned in the guides
5. **Check troubleshooting sections** for common issues

## For Developers

These rules complement the full documentation:

- **Detailed Documentation**: See `docs/features/` for comprehensive guides
- **Design Documentation**: See `docs/design/` for implementation details
- **API Reference**: See inline code documentation

## Installation

These rules are automatically installed when you use:

```bash
pip install sqlobjects[amazonq]  # For Amazon Q
pip install sqlobjects[cursor]   # For Cursor
pip install sqlobjects[claude]   # For Claude
pip install sqlobjects[kiro]     # For Kiro
```

## Version

These rules are for SQLObjects 1.0+
