"""SQLSpec: Type-safe SQL query mapper for Python."""

from sqlspec import adapters, base, builder, core, driver, exceptions, extensions, loader, migrations, typing, utils
from sqlspec.__metadata__ import __version__
from sqlspec._sql import SQLFactory, sql
from sqlspec.base import SQLSpec
from sqlspec.builder import (
    Column,
    ColumnExpression,
    CreateTable,
    Delete,
    DropTable,
    FunctionColumn,
    Insert,
    Merge,
    QueryBuilder,
    Select,
    Update,
)
from sqlspec.config import AsyncDatabaseConfig, SyncDatabaseConfig
from sqlspec.core import (
    SQL,
    ArrowResult,
    CacheConfig,
    CacheStats,
    ParameterConverter,
    ParameterProcessor,
    ParameterStyle,
    ParameterStyleConfig,
    SQLResult,
    Statement,
    StatementConfig,
)
from sqlspec.core import filters as filters
from sqlspec.driver import AsyncDriverAdapterBase, ExecutionResult, SyncDriverAdapterBase
from sqlspec.loader import SQLFile, SQLFileLoader
from sqlspec.typing import (
    ConnectionT,
    DictRow,
    ModelDTOT,
    ModelT,
    PoolT,
    RowT,
    StatementParameters,
    SupportedSchemaModel,
)

__all__ = (
    "SQL",
    "ArrowResult",
    "AsyncDatabaseConfig",
    "AsyncDriverAdapterBase",
    "CacheConfig",
    "CacheStats",
    "Column",
    "ColumnExpression",
    "ConnectionT",
    "CreateTable",
    "Delete",
    "DictRow",
    "DropTable",
    "ExecutionResult",
    "FunctionColumn",
    "Insert",
    "Merge",
    "ModelDTOT",
    "ModelT",
    "ParameterConverter",
    "ParameterProcessor",
    "ParameterStyle",
    "ParameterStyleConfig",
    "PoolT",
    "QueryBuilder",
    "RowT",
    "SQLFactory",
    "SQLFile",
    "SQLFileLoader",
    "SQLResult",
    "SQLSpec",
    "Select",
    "Statement",
    "StatementConfig",
    "StatementParameters",
    "SupportedSchemaModel",
    "SyncDatabaseConfig",
    "SyncDriverAdapterBase",
    "Update",
    "__version__",
    "adapters",
    "base",
    "builder",
    "core",
    "driver",
    "exceptions",
    "extensions",
    "filters",
    "loader",
    "migrations",
    "sql",
    "typing",
    "utils",
)
