"""Psqlpy pgvector type handlers for vector data type support.

Provides automatic conversion between NumPy arrays and PostgreSQL vector types
via pgvector-python library when integrated with psqlpy connection pool.

Note:
    Full pgvector support for psqlpy is planned for a future release.
    The driver_features infrastructure (enable_pgvector) has been implemented
    to enable this feature when the underlying psqlpy library adds support for
    custom type handlers on pool initialization.
"""

import logging
from typing import TYPE_CHECKING

from sqlspec.typing import PGVECTOR_INSTALLED

if TYPE_CHECKING:
    from psqlpy import Connection

__all__ = ("register_pgvector",)


logger = logging.getLogger(__name__)


def register_pgvector(connection: "Connection") -> None:
    """Register pgvector type handlers on psqlpy connection.

    Currently a placeholder for future implementation. The psqlpy library
    does not yet expose a type handler registration API compatible with
    pgvector's automatic conversion system.

    Args:
        connection: Psqlpy connection instance.

    Note:
        When psqlpy adds type handler support, this function will:
        - Register pgvector extension on the connection
        - Enable automatic NumPy array <-> PostgreSQL vector conversion
        - Support vector similarity search operations
    """
    if not PGVECTOR_INSTALLED:
        return
