from datetime import datetime, date

class Loader:

    def __init__(self, data, description):
        self.data = data
        self.description = description

    def csv(self, file_name: str, delimiter=',', header=True, encoding='utf-8'):
        """
        Save as csv
        :param file_name
        :param delimiter
        :param header bool, include header or not
        :param encoding default utf-8
        """
        import csv
        with open(file_name, 'w', newline='', encoding=encoding) as f:
            writer = csv.writer(f, delimiter=delimiter)
            if header and self.description:
                description = [x[0] for x in self.description]
                writer.writerow(description)

            writer.writerows(self.data)

    def df(self):
        """
        transform to DataFrame of pandas.
        :return DataFrame of pandas
        """
        import pandas as pd
        if self.description:
            description = [x[0] for x in self.description]
            return pd.DataFrame(data=self.data, columns=description)

        return pd.DataFrame(data=self.data)

    def json(self, file_name: str, encoding='utf-8'):
        """
        Save as json
        :param file_name
        :param encoding default utf-8
        """
        import json
        from .support import Dict

        if self.data and self.description:
            names = [x[0] for x in self.description]
            data = list(map(lambda x: Dict(names, x), self.data))

            with open(file_name, 'w', encoding=encoding) as f:
                json.dump(data, f, default=_datetime_handler)


def _datetime_handler(obj):
    if isinstance(obj, datetime) or isinstance(obj, date):
        return obj.__str__()
