use crate::syntax_kind::SyntaxKind;
use crate::token_set::TokenSet;

pub(crate) const COLUMN_OR_TABLE_KEYWORDS: TokenSet = TokenSet::new(&[
    SyntaxKind::ABORT_KW,
    SyntaxKind::ABSENT_KW,
    SyntaxKind::ABSOLUTE_KW,
    SyntaxKind::ACCESS_KW,
    SyntaxKind::ACTION_KW,
    SyntaxKind::ADD_KW,
    SyntaxKind::ADMIN_KW,
    SyntaxKind::AFTER_KW,
    SyntaxKind::AGGREGATE_KW,
    SyntaxKind::ALSO_KW,
    SyntaxKind::ALTER_KW,
    SyntaxKind::ALWAYS_KW,
    SyntaxKind::ASENSITIVE_KW,
    SyntaxKind::ASSERTION_KW,
    SyntaxKind::ASSIGNMENT_KW,
    SyntaxKind::AT_KW,
    SyntaxKind::ATOMIC_KW,
    SyntaxKind::ATTACH_KW,
    SyntaxKind::ATTRIBUTE_KW,
    SyntaxKind::BACKWARD_KW,
    SyntaxKind::BEFORE_KW,
    SyntaxKind::BEGIN_KW,
    SyntaxKind::BETWEEN_KW,
    SyntaxKind::BIGINT_KW,
    SyntaxKind::BIT_KW,
    SyntaxKind::BOOLEAN_KW,
    SyntaxKind::BREADTH_KW,
    SyntaxKind::BY_KW,
    SyntaxKind::CACHE_KW,
    SyntaxKind::CALL_KW,
    SyntaxKind::CALLED_KW,
    SyntaxKind::CASCADE_KW,
    SyntaxKind::CASCADED_KW,
    SyntaxKind::CATALOG_KW,
    SyntaxKind::CHAIN_KW,
    SyntaxKind::CHAR_KW,
    SyntaxKind::CHARACTER_KW,
    SyntaxKind::CHARACTERISTICS_KW,
    SyntaxKind::CHECKPOINT_KW,
    SyntaxKind::CLASS_KW,
    SyntaxKind::CLOSE_KW,
    SyntaxKind::CLUSTER_KW,
    SyntaxKind::COALESCE_KW,
    SyntaxKind::COLUMNS_KW,
    SyntaxKind::COMMENT_KW,
    SyntaxKind::COMMENTS_KW,
    SyntaxKind::COMMIT_KW,
    SyntaxKind::COMMITTED_KW,
    SyntaxKind::COMPRESSION_KW,
    SyntaxKind::CONDITIONAL_KW,
    SyntaxKind::CONFIGURATION_KW,
    SyntaxKind::CONFLICT_KW,
    SyntaxKind::CONNECTION_KW,
    SyntaxKind::CONSTRAINTS_KW,
    SyntaxKind::CONTENT_KW,
    SyntaxKind::CONTINUE_KW,
    SyntaxKind::CONVERSION_KW,
    SyntaxKind::COPY_KW,
    SyntaxKind::COST_KW,
    SyntaxKind::CSV_KW,
    SyntaxKind::CUBE_KW,
    SyntaxKind::CURRENT_KW,
    SyntaxKind::CURSOR_KW,
    SyntaxKind::CYCLE_KW,
    SyntaxKind::DATA_KW,
    SyntaxKind::DATABASE_KW,
    SyntaxKind::DAY_KW,
    SyntaxKind::DEALLOCATE_KW,
    SyntaxKind::DEC_KW,
    SyntaxKind::DECIMAL_KW,
    SyntaxKind::DECLARE_KW,
    SyntaxKind::DEFAULTS_KW,
    SyntaxKind::DEFERRED_KW,
    SyntaxKind::DEFINER_KW,
    SyntaxKind::DELETE_KW,
    SyntaxKind::DELIMITER_KW,
    SyntaxKind::DELIMITERS_KW,
    SyntaxKind::DEPENDS_KW,
    SyntaxKind::DEPTH_KW,
    SyntaxKind::DETACH_KW,
    SyntaxKind::DICTIONARY_KW,
    SyntaxKind::DISABLE_KW,
    SyntaxKind::DISCARD_KW,
    SyntaxKind::DOCUMENT_KW,
    SyntaxKind::DOMAIN_KW,
    SyntaxKind::DOUBLE_KW,
    SyntaxKind::DROP_KW,
    SyntaxKind::EACH_KW,
    SyntaxKind::EMPTY_KW,
    SyntaxKind::ENABLE_KW,
    SyntaxKind::ENCODING_KW,
    SyntaxKind::ENCRYPTED_KW,
    SyntaxKind::ENFORCED_KW,
    SyntaxKind::ENUM_KW,
    SyntaxKind::ERROR_KW,
    SyntaxKind::ESCAPE_KW,
    SyntaxKind::EVENT_KW,
    SyntaxKind::EXCLUDE_KW,
    SyntaxKind::EXCLUDING_KW,
    SyntaxKind::EXCLUSIVE_KW,
    SyntaxKind::EXECUTE_KW,
    SyntaxKind::EXISTS_KW,
    SyntaxKind::EXPLAIN_KW,
    SyntaxKind::EXPRESSION_KW,
    SyntaxKind::EXTENSION_KW,
    SyntaxKind::EXTERNAL_KW,
    SyntaxKind::EXTRACT_KW,
    SyntaxKind::FAMILY_KW,
    SyntaxKind::FILTER_KW,
    SyntaxKind::FINALIZE_KW,
    SyntaxKind::FIRST_KW,
    SyntaxKind::FLOAT_KW,
    SyntaxKind::FOLLOWING_KW,
    SyntaxKind::FORCE_KW,
    SyntaxKind::FORMAT_KW,
    SyntaxKind::FORWARD_KW,
    SyntaxKind::FUNCTION_KW,
    SyntaxKind::FUNCTIONS_KW,
    SyntaxKind::GENERATED_KW,
    SyntaxKind::GLOBAL_KW,
    SyntaxKind::GRANTED_KW,
    SyntaxKind::GREATEST_KW,
    SyntaxKind::GROUPING_KW,
    SyntaxKind::GROUPS_KW,
    SyntaxKind::HANDLER_KW,
    SyntaxKind::HEADER_KW,
    SyntaxKind::HOLD_KW,
    SyntaxKind::HOUR_KW,
    SyntaxKind::IDENTITY_KW,
    SyntaxKind::IF_KW,
    SyntaxKind::IGNORE_KW,
    SyntaxKind::IMMEDIATE_KW,
    SyntaxKind::IMMUTABLE_KW,
    SyntaxKind::IMPLICIT_KW,
    SyntaxKind::IMPORT_KW,
    SyntaxKind::INCLUDE_KW,
    SyntaxKind::INCLUDING_KW,
    SyntaxKind::INCREMENT_KW,
    SyntaxKind::INDENT_KW,
    SyntaxKind::INDEX_KW,
    SyntaxKind::INDEXES_KW,
    SyntaxKind::INHERIT_KW,
    SyntaxKind::INHERITS_KW,
    SyntaxKind::INLINE_KW,
    SyntaxKind::INOUT_KW,
    SyntaxKind::INPUT_KW,
    SyntaxKind::INSENSITIVE_KW,
    SyntaxKind::INSERT_KW,
    SyntaxKind::INSTEAD_KW,
    SyntaxKind::INT_KW,
    SyntaxKind::INTEGER_KW,
    SyntaxKind::INTERVAL_KW,
    SyntaxKind::INVOKER_KW,
    SyntaxKind::ISOLATION_KW,
    SyntaxKind::JSON_KW,
    SyntaxKind::JSON_ARRAY_KW,
    SyntaxKind::JSON_ARRAYAGG_KW,
    SyntaxKind::JSON_EXISTS_KW,
    SyntaxKind::JSON_OBJECT_KW,
    SyntaxKind::JSON_OBJECTAGG_KW,
    SyntaxKind::JSON_QUERY_KW,
    SyntaxKind::JSON_SCALAR_KW,
    SyntaxKind::JSON_SERIALIZE_KW,
    SyntaxKind::JSON_TABLE_KW,
    SyntaxKind::JSON_VALUE_KW,
    SyntaxKind::KEEP_KW,
    SyntaxKind::KEY_KW,
    SyntaxKind::KEYS_KW,
    SyntaxKind::LABEL_KW,
    SyntaxKind::LANGUAGE_KW,
    SyntaxKind::LARGE_KW,
    SyntaxKind::LAST_KW,
    SyntaxKind::LEAKPROOF_KW,
    SyntaxKind::LEAST_KW,
    SyntaxKind::LEVEL_KW,
    SyntaxKind::LISTEN_KW,
    SyntaxKind::LOAD_KW,
    SyntaxKind::LOCAL_KW,
    SyntaxKind::LOCATION_KW,
    SyntaxKind::LOCK_KW,
    SyntaxKind::LOCKED_KW,
    SyntaxKind::LOGGED_KW,
    SyntaxKind::LSN_KW,
    SyntaxKind::MAPPING_KW,
    SyntaxKind::MATCH_KW,
    SyntaxKind::MATCHED_KW,
    SyntaxKind::MATERIALIZED_KW,
    SyntaxKind::MAXVALUE_KW,
    SyntaxKind::MERGE_KW,
    SyntaxKind::MERGE_ACTION_KW,
    SyntaxKind::METHOD_KW,
    SyntaxKind::MINUTE_KW,
    SyntaxKind::MINVALUE_KW,
    SyntaxKind::MODE_KW,
    SyntaxKind::MONTH_KW,
    SyntaxKind::MOVE_KW,
    SyntaxKind::NAME_KW,
    SyntaxKind::NAMES_KW,
    SyntaxKind::NATIONAL_KW,
    SyntaxKind::NCHAR_KW,
    SyntaxKind::NESTED_KW,
    SyntaxKind::NEW_KW,
    SyntaxKind::NEXT_KW,
    SyntaxKind::NFC_KW,
    SyntaxKind::NFD_KW,
    SyntaxKind::NFKC_KW,
    SyntaxKind::NFKD_KW,
    SyntaxKind::NO_KW,
    SyntaxKind::NONE_KW,
    SyntaxKind::NORMALIZE_KW,
    SyntaxKind::NORMALIZED_KW,
    SyntaxKind::NOTHING_KW,
    SyntaxKind::NOTIFY_KW,
    SyntaxKind::NOWAIT_KW,
    SyntaxKind::NULLIF_KW,
    SyntaxKind::NULLS_KW,
    SyntaxKind::NUMERIC_KW,
    SyntaxKind::OBJECT_KW,
    SyntaxKind::OBJECTS_KW,
    SyntaxKind::OF_KW,
    SyntaxKind::OFF_KW,
    SyntaxKind::OIDS_KW,
    SyntaxKind::OLD_KW,
    SyntaxKind::OMIT_KW,
    SyntaxKind::OPERATOR_KW,
    SyntaxKind::OPTION_KW,
    SyntaxKind::OPTIONS_KW,
    SyntaxKind::ORDINALITY_KW,
    SyntaxKind::OTHERS_KW,
    SyntaxKind::OUT_KW,
    SyntaxKind::OVER_KW,
    SyntaxKind::OVERLAY_KW,
    SyntaxKind::OVERRIDING_KW,
    SyntaxKind::OWNED_KW,
    SyntaxKind::OWNER_KW,
    SyntaxKind::PARALLEL_KW,
    SyntaxKind::PARAMETER_KW,
    SyntaxKind::PARSER_KW,
    SyntaxKind::PARTIAL_KW,
    SyntaxKind::PARTITION_KW,
    SyntaxKind::PARTITIONS_KW,
    SyntaxKind::PASSING_KW,
    SyntaxKind::PASSWORD_KW,
    SyntaxKind::PATH_KW,
    SyntaxKind::PERIOD_KW,
    SyntaxKind::PLAN_KW,
    SyntaxKind::PLANS_KW,
    SyntaxKind::POLICY_KW,
    SyntaxKind::POSITION_KW,
    SyntaxKind::PRECEDING_KW,
    SyntaxKind::PRECISION_KW,
    SyntaxKind::PREPARE_KW,
    SyntaxKind::PREPARED_KW,
    SyntaxKind::PRESERVE_KW,
    SyntaxKind::PRIOR_KW,
    SyntaxKind::PRIVILEGES_KW,
    SyntaxKind::PROCEDURAL_KW,
    SyntaxKind::PROCEDURE_KW,
    SyntaxKind::PROCEDURES_KW,
    SyntaxKind::PROGRAM_KW,
    SyntaxKind::PUBLICATION_KW,
    SyntaxKind::QUOTE_KW,
    SyntaxKind::QUOTES_KW,
    SyntaxKind::RANGE_KW,
    SyntaxKind::READ_KW,
    SyntaxKind::REAL_KW,
    SyntaxKind::REASSIGN_KW,
    SyntaxKind::RECURSIVE_KW,
    SyntaxKind::REF_KW,
    SyntaxKind::REFERENCING_KW,
    SyntaxKind::REFRESH_KW,
    SyntaxKind::REINDEX_KW,
    SyntaxKind::RELATIVE_KW,
    SyntaxKind::RELEASE_KW,
    SyntaxKind::RENAME_KW,
    SyntaxKind::REPEATABLE_KW,
    SyntaxKind::REPLACE_KW,
    SyntaxKind::REPLICA_KW,
    SyntaxKind::RESET_KW,
    SyntaxKind::RESPECT_KW,
    SyntaxKind::RESTART_KW,
    SyntaxKind::RESTRICT_KW,
    SyntaxKind::RETURN_KW,
    SyntaxKind::RETURNS_KW,
    SyntaxKind::REVOKE_KW,
    SyntaxKind::ROLE_KW,
    SyntaxKind::ROLLBACK_KW,
    SyntaxKind::ROLLUP_KW,
    SyntaxKind::ROUTINE_KW,
    SyntaxKind::ROUTINES_KW,
    SyntaxKind::ROW_KW,
    SyntaxKind::ROWS_KW,
    SyntaxKind::RULE_KW,
    SyntaxKind::SAVEPOINT_KW,
    SyntaxKind::SCALAR_KW,
    SyntaxKind::SCHEMA_KW,
    SyntaxKind::SCHEMAS_KW,
    SyntaxKind::SCROLL_KW,
    SyntaxKind::SEARCH_KW,
    SyntaxKind::SECOND_KW,
    SyntaxKind::SECURITY_KW,
    SyntaxKind::SEQUENCE_KW,
    SyntaxKind::SEQUENCES_KW,
    SyntaxKind::SERIALIZABLE_KW,
    SyntaxKind::SERVER_KW,
    SyntaxKind::SESSION_KW,
    SyntaxKind::SET_KW,
    SyntaxKind::SETOF_KW,
    SyntaxKind::SETS_KW,
    SyntaxKind::SHARE_KW,
    SyntaxKind::SHOW_KW,
    SyntaxKind::SIMPLE_KW,
    SyntaxKind::SKIP_KW,
    SyntaxKind::SMALLINT_KW,
    SyntaxKind::SNAPSHOT_KW,
    SyntaxKind::SOURCE_KW,
    SyntaxKind::SPLIT_KW,
    SyntaxKind::SQL_KW,
    SyntaxKind::STABLE_KW,
    SyntaxKind::STANDALONE_KW,
    SyntaxKind::START_KW,
    SyntaxKind::STATEMENT_KW,
    SyntaxKind::STATISTICS_KW,
    SyntaxKind::STDIN_KW,
    SyntaxKind::STDOUT_KW,
    SyntaxKind::STORAGE_KW,
    SyntaxKind::STORED_KW,
    SyntaxKind::STRICT_KW,
    SyntaxKind::STRING_KW,
    SyntaxKind::STRIP_KW,
    SyntaxKind::SUBSCRIPTION_KW,
    SyntaxKind::SUBSTRING_KW,
    SyntaxKind::SUPPORT_KW,
    SyntaxKind::SYSID_KW,
    SyntaxKind::SYSTEM_KW,
    SyntaxKind::TABLES_KW,
    SyntaxKind::TABLESPACE_KW,
    SyntaxKind::TARGET_KW,
    SyntaxKind::TEMP_KW,
    SyntaxKind::TEMPLATE_KW,
    SyntaxKind::TEMPORARY_KW,
    SyntaxKind::TEXT_KW,
    SyntaxKind::TIES_KW,
    SyntaxKind::TIME_KW,
    SyntaxKind::TIMESTAMP_KW,
    SyntaxKind::TRANSACTION_KW,
    SyntaxKind::TRANSFORM_KW,
    SyntaxKind::TREAT_KW,
    SyntaxKind::TRIGGER_KW,
    SyntaxKind::TRIM_KW,
    SyntaxKind::TRUNCATE_KW,
    SyntaxKind::TRUSTED_KW,
    SyntaxKind::TYPE_KW,
    SyntaxKind::TYPES_KW,
    SyntaxKind::UESCAPE_KW,
    SyntaxKind::UNBOUNDED_KW,
    SyntaxKind::UNCOMMITTED_KW,
    SyntaxKind::UNCONDITIONAL_KW,
    SyntaxKind::UNENCRYPTED_KW,
    SyntaxKind::UNKNOWN_KW,
    SyntaxKind::UNLISTEN_KW,
    SyntaxKind::UNLOGGED_KW,
    SyntaxKind::UNTIL_KW,
    SyntaxKind::UPDATE_KW,
    SyntaxKind::VACUUM_KW,
    SyntaxKind::VALID_KW,
    SyntaxKind::VALIDATE_KW,
    SyntaxKind::VALIDATOR_KW,
    SyntaxKind::VALUE_KW,
    SyntaxKind::VALUES_KW,
    SyntaxKind::VARCHAR_KW,
    SyntaxKind::VARYING_KW,
    SyntaxKind::VERSION_KW,
    SyntaxKind::VIEW_KW,
    SyntaxKind::VIEWS_KW,
    SyntaxKind::VIRTUAL_KW,
    SyntaxKind::VOLATILE_KW,
    SyntaxKind::WAIT_KW,
    SyntaxKind::WHITESPACE_KW,
    SyntaxKind::WITHIN_KW,
    SyntaxKind::WITHOUT_KW,
    SyntaxKind::WORK_KW,
    SyntaxKind::WRAPPER_KW,
    SyntaxKind::WRITE_KW,
    SyntaxKind::XML_KW,
    SyntaxKind::XMLATTRIBUTES_KW,
    SyntaxKind::XMLCONCAT_KW,
    SyntaxKind::XMLELEMENT_KW,
    SyntaxKind::XMLEXISTS_KW,
    SyntaxKind::XMLFOREST_KW,
    SyntaxKind::XMLNAMESPACES_KW,
    SyntaxKind::XMLPARSE_KW,
    SyntaxKind::XMLPI_KW,
    SyntaxKind::XMLROOT_KW,
    SyntaxKind::XMLSERIALIZE_KW,
    SyntaxKind::XMLTABLE_KW,
    SyntaxKind::YEAR_KW,
    SyntaxKind::YES_KW,
    SyntaxKind::ZONE_KW,
]);

pub(crate) const TYPE_KEYWORDS: TokenSet = TokenSet::new(&[
    SyntaxKind::ABORT_KW,
    SyntaxKind::ABSENT_KW,
    SyntaxKind::ABSOLUTE_KW,
    SyntaxKind::ACCESS_KW,
    SyntaxKind::ACTION_KW,
    SyntaxKind::ADD_KW,
    SyntaxKind::ADMIN_KW,
    SyntaxKind::AFTER_KW,
    SyntaxKind::AGGREGATE_KW,
    SyntaxKind::ALSO_KW,
    SyntaxKind::ALTER_KW,
    SyntaxKind::ALWAYS_KW,
    SyntaxKind::ASENSITIVE_KW,
    SyntaxKind::ASSERTION_KW,
    SyntaxKind::ASSIGNMENT_KW,
    SyntaxKind::AT_KW,
    SyntaxKind::ATOMIC_KW,
    SyntaxKind::ATTACH_KW,
    SyntaxKind::ATTRIBUTE_KW,
    SyntaxKind::AUTHORIZATION_KW,
    SyntaxKind::BACKWARD_KW,
    SyntaxKind::BEFORE_KW,
    SyntaxKind::BEGIN_KW,
    SyntaxKind::BETWEEN_KW,
    SyntaxKind::BIGINT_KW,
    SyntaxKind::BINARY_KW,
    SyntaxKind::BIT_KW,
    SyntaxKind::BOOLEAN_KW,
    SyntaxKind::BREADTH_KW,
    SyntaxKind::BY_KW,
    SyntaxKind::CACHE_KW,
    SyntaxKind::CALL_KW,
    SyntaxKind::CALLED_KW,
    SyntaxKind::CASCADE_KW,
    SyntaxKind::CASCADED_KW,
    SyntaxKind::CATALOG_KW,
    SyntaxKind::CHAIN_KW,
    SyntaxKind::CHAR_KW,
    SyntaxKind::CHARACTER_KW,
    SyntaxKind::CHARACTERISTICS_KW,
    SyntaxKind::CHECKPOINT_KW,
    SyntaxKind::CLASS_KW,
    SyntaxKind::CLOSE_KW,
    SyntaxKind::CLUSTER_KW,
    SyntaxKind::COALESCE_KW,
    SyntaxKind::COLLATION_KW,
    SyntaxKind::COLUMNS_KW,
    SyntaxKind::COMMENT_KW,
    SyntaxKind::COMMENTS_KW,
    SyntaxKind::COMMIT_KW,
    SyntaxKind::COMMITTED_KW,
    SyntaxKind::COMPRESSION_KW,
    SyntaxKind::CONCURRENTLY_KW,
    SyntaxKind::CONDITIONAL_KW,
    SyntaxKind::CONFIGURATION_KW,
    SyntaxKind::CONFLICT_KW,
    SyntaxKind::CONNECTION_KW,
    SyntaxKind::CONSTRAINTS_KW,
    SyntaxKind::CONTENT_KW,
    SyntaxKind::CONTINUE_KW,
    SyntaxKind::CONVERSION_KW,
    SyntaxKind::COPY_KW,
    SyntaxKind::COST_KW,
    SyntaxKind::CROSS_KW,
    SyntaxKind::CSV_KW,
    SyntaxKind::CUBE_KW,
    SyntaxKind::CURRENT_KW,
    SyntaxKind::CURRENT_SCHEMA_KW,
    SyntaxKind::CURSOR_KW,
    SyntaxKind::CYCLE_KW,
    SyntaxKind::DATA_KW,
    SyntaxKind::DATABASE_KW,
    SyntaxKind::DAY_KW,
    SyntaxKind::DEALLOCATE_KW,
    SyntaxKind::DEC_KW,
    SyntaxKind::DECIMAL_KW,
    SyntaxKind::DECLARE_KW,
    SyntaxKind::DEFAULTS_KW,
    SyntaxKind::DEFERRED_KW,
    SyntaxKind::DEFINER_KW,
    SyntaxKind::DELETE_KW,
    SyntaxKind::DELIMITER_KW,
    SyntaxKind::DELIMITERS_KW,
    SyntaxKind::DEPENDS_KW,
    SyntaxKind::DEPTH_KW,
    SyntaxKind::DETACH_KW,
    SyntaxKind::DICTIONARY_KW,
    SyntaxKind::DISABLE_KW,
    SyntaxKind::DISCARD_KW,
    SyntaxKind::DOCUMENT_KW,
    SyntaxKind::DOMAIN_KW,
    SyntaxKind::DOUBLE_KW,
    SyntaxKind::DROP_KW,
    SyntaxKind::EACH_KW,
    SyntaxKind::EMPTY_KW,
    SyntaxKind::ENABLE_KW,
    SyntaxKind::ENCODING_KW,
    SyntaxKind::ENCRYPTED_KW,
    SyntaxKind::ENFORCED_KW,
    SyntaxKind::ENUM_KW,
    SyntaxKind::ERROR_KW,
    SyntaxKind::ESCAPE_KW,
    SyntaxKind::EVENT_KW,
    SyntaxKind::EXCLUDE_KW,
    SyntaxKind::EXCLUDING_KW,
    SyntaxKind::EXCLUSIVE_KW,
    SyntaxKind::EXECUTE_KW,
    SyntaxKind::EXISTS_KW,
    SyntaxKind::EXPLAIN_KW,
    SyntaxKind::EXPRESSION_KW,
    SyntaxKind::EXTENSION_KW,
    SyntaxKind::EXTERNAL_KW,
    SyntaxKind::EXTRACT_KW,
    SyntaxKind::FAMILY_KW,
    SyntaxKind::FILTER_KW,
    SyntaxKind::FINALIZE_KW,
    SyntaxKind::FIRST_KW,
    SyntaxKind::FLOAT_KW,
    SyntaxKind::FOLLOWING_KW,
    SyntaxKind::FORCE_KW,
    SyntaxKind::FORMAT_KW,
    SyntaxKind::FORWARD_KW,
    SyntaxKind::FREEZE_KW,
    SyntaxKind::FULL_KW,
    SyntaxKind::FUNCTION_KW,
    SyntaxKind::FUNCTIONS_KW,
    SyntaxKind::GENERATED_KW,
    SyntaxKind::GLOBAL_KW,
    SyntaxKind::GRANTED_KW,
    SyntaxKind::GREATEST_KW,
    SyntaxKind::GROUPING_KW,
    SyntaxKind::GROUPS_KW,
    SyntaxKind::HANDLER_KW,
    SyntaxKind::HEADER_KW,
    SyntaxKind::HOLD_KW,
    SyntaxKind::HOUR_KW,
    SyntaxKind::IDENTITY_KW,
    SyntaxKind::IF_KW,
    SyntaxKind::IGNORE_KW,
    SyntaxKind::ILIKE_KW,
    SyntaxKind::IMMEDIATE_KW,
    SyntaxKind::IMMUTABLE_KW,
    SyntaxKind::IMPLICIT_KW,
    SyntaxKind::IMPORT_KW,
    SyntaxKind::INCLUDE_KW,
    SyntaxKind::INCLUDING_KW,
    SyntaxKind::INCREMENT_KW,
    SyntaxKind::INDENT_KW,
    SyntaxKind::INDEX_KW,
    SyntaxKind::INDEXES_KW,
    SyntaxKind::INHERIT_KW,
    SyntaxKind::INHERITS_KW,
    SyntaxKind::INLINE_KW,
    SyntaxKind::INNER_KW,
    SyntaxKind::INOUT_KW,
    SyntaxKind::INPUT_KW,
    SyntaxKind::INSENSITIVE_KW,
    SyntaxKind::INSERT_KW,
    SyntaxKind::INSTEAD_KW,
    SyntaxKind::INT_KW,
    SyntaxKind::INTEGER_KW,
    SyntaxKind::INTERVAL_KW,
    SyntaxKind::INVOKER_KW,
    SyntaxKind::IS_KW,
    SyntaxKind::ISNULL_KW,
    SyntaxKind::ISOLATION_KW,
    SyntaxKind::JOIN_KW,
    SyntaxKind::JSON_KW,
    SyntaxKind::JSON_ARRAY_KW,
    SyntaxKind::JSON_ARRAYAGG_KW,
    SyntaxKind::JSON_EXISTS_KW,
    SyntaxKind::JSON_OBJECT_KW,
    SyntaxKind::JSON_OBJECTAGG_KW,
    SyntaxKind::JSON_QUERY_KW,
    SyntaxKind::JSON_SCALAR_KW,
    SyntaxKind::JSON_SERIALIZE_KW,
    SyntaxKind::JSON_TABLE_KW,
    SyntaxKind::JSON_VALUE_KW,
    SyntaxKind::KEEP_KW,
    SyntaxKind::KEY_KW,
    SyntaxKind::KEYS_KW,
    SyntaxKind::LABEL_KW,
    SyntaxKind::LANGUAGE_KW,
    SyntaxKind::LARGE_KW,
    SyntaxKind::LAST_KW,
    SyntaxKind::LEAKPROOF_KW,
    SyntaxKind::LEAST_KW,
    SyntaxKind::LEFT_KW,
    SyntaxKind::LEVEL_KW,
    SyntaxKind::LIKE_KW,
    SyntaxKind::LISTEN_KW,
    SyntaxKind::LOAD_KW,
    SyntaxKind::LOCAL_KW,
    SyntaxKind::LOCATION_KW,
    SyntaxKind::LOCK_KW,
    SyntaxKind::LOCKED_KW,
    SyntaxKind::LOGGED_KW,
    SyntaxKind::LSN_KW,
    SyntaxKind::MAPPING_KW,
    SyntaxKind::MATCH_KW,
    SyntaxKind::MATCHED_KW,
    SyntaxKind::MATERIALIZED_KW,
    SyntaxKind::MAXVALUE_KW,
    SyntaxKind::MERGE_KW,
    SyntaxKind::MERGE_ACTION_KW,
    SyntaxKind::METHOD_KW,
    SyntaxKind::MINUTE_KW,
    SyntaxKind::MINVALUE_KW,
    SyntaxKind::MODE_KW,
    SyntaxKind::MONTH_KW,
    SyntaxKind::MOVE_KW,
    SyntaxKind::NAME_KW,
    SyntaxKind::NAMES_KW,
    SyntaxKind::NATIONAL_KW,
    SyntaxKind::NATURAL_KW,
    SyntaxKind::NCHAR_KW,
    SyntaxKind::NESTED_KW,
    SyntaxKind::NEW_KW,
    SyntaxKind::NEXT_KW,
    SyntaxKind::NFC_KW,
    SyntaxKind::NFD_KW,
    SyntaxKind::NFKC_KW,
    SyntaxKind::NFKD_KW,
    SyntaxKind::NO_KW,
    SyntaxKind::NONE_KW,
    SyntaxKind::NORMALIZE_KW,
    SyntaxKind::NORMALIZED_KW,
    SyntaxKind::NOTHING_KW,
    SyntaxKind::NOTIFY_KW,
    SyntaxKind::NOTNULL_KW,
    SyntaxKind::NOWAIT_KW,
    SyntaxKind::NULLIF_KW,
    SyntaxKind::NULLS_KW,
    SyntaxKind::NUMERIC_KW,
    SyntaxKind::OBJECT_KW,
    SyntaxKind::OBJECTS_KW,
    SyntaxKind::OF_KW,
    SyntaxKind::OFF_KW,
    SyntaxKind::OIDS_KW,
    SyntaxKind::OLD_KW,
    SyntaxKind::OMIT_KW,
    SyntaxKind::OPERATOR_KW,
    SyntaxKind::OPTION_KW,
    SyntaxKind::OPTIONS_KW,
    SyntaxKind::ORDINALITY_KW,
    SyntaxKind::OTHERS_KW,
    SyntaxKind::OUT_KW,
    SyntaxKind::OUTER_KW,
    SyntaxKind::OVER_KW,
    SyntaxKind::OVERLAPS_KW,
    SyntaxKind::OVERLAY_KW,
    SyntaxKind::OVERRIDING_KW,
    SyntaxKind::OWNED_KW,
    SyntaxKind::OWNER_KW,
    SyntaxKind::PARALLEL_KW,
    SyntaxKind::PARAMETER_KW,
    SyntaxKind::PARSER_KW,
    SyntaxKind::PARTIAL_KW,
    SyntaxKind::PARTITION_KW,
    SyntaxKind::PARTITIONS_KW,
    SyntaxKind::PASSING_KW,
    SyntaxKind::PASSWORD_KW,
    SyntaxKind::PATH_KW,
    SyntaxKind::PERIOD_KW,
    SyntaxKind::PLAN_KW,
    SyntaxKind::PLANS_KW,
    SyntaxKind::POLICY_KW,
    SyntaxKind::POSITION_KW,
    SyntaxKind::PRECEDING_KW,
    SyntaxKind::PRECISION_KW,
    SyntaxKind::PREPARE_KW,
    SyntaxKind::PREPARED_KW,
    SyntaxKind::PRESERVE_KW,
    SyntaxKind::PRIOR_KW,
    SyntaxKind::PRIVILEGES_KW,
    SyntaxKind::PROCEDURAL_KW,
    SyntaxKind::PROCEDURE_KW,
    SyntaxKind::PROCEDURES_KW,
    SyntaxKind::PROGRAM_KW,
    SyntaxKind::PUBLICATION_KW,
    SyntaxKind::QUOTE_KW,
    SyntaxKind::QUOTES_KW,
    SyntaxKind::RANGE_KW,
    SyntaxKind::READ_KW,
    SyntaxKind::REAL_KW,
    SyntaxKind::REASSIGN_KW,
    SyntaxKind::RECURSIVE_KW,
    SyntaxKind::REF_KW,
    SyntaxKind::REFERENCING_KW,
    SyntaxKind::REFRESH_KW,
    SyntaxKind::REINDEX_KW,
    SyntaxKind::RELATIVE_KW,
    SyntaxKind::RELEASE_KW,
    SyntaxKind::RENAME_KW,
    SyntaxKind::REPEATABLE_KW,
    SyntaxKind::REPLACE_KW,
    SyntaxKind::REPLICA_KW,
    SyntaxKind::RESET_KW,
    SyntaxKind::RESPECT_KW,
    SyntaxKind::RESTART_KW,
    SyntaxKind::RESTRICT_KW,
    SyntaxKind::RETURN_KW,
    SyntaxKind::RETURNS_KW,
    SyntaxKind::REVOKE_KW,
    SyntaxKind::RIGHT_KW,
    SyntaxKind::ROLE_KW,
    SyntaxKind::ROLLBACK_KW,
    SyntaxKind::ROLLUP_KW,
    SyntaxKind::ROUTINE_KW,
    SyntaxKind::ROUTINES_KW,
    SyntaxKind::ROW_KW,
    SyntaxKind::ROWS_KW,
    SyntaxKind::RULE_KW,
    SyntaxKind::SAVEPOINT_KW,
    SyntaxKind::SCALAR_KW,
    SyntaxKind::SCHEMA_KW,
    SyntaxKind::SCHEMAS_KW,
    SyntaxKind::SCROLL_KW,
    SyntaxKind::SEARCH_KW,
    SyntaxKind::SECOND_KW,
    SyntaxKind::SECURITY_KW,
    SyntaxKind::SEQUENCE_KW,
    SyntaxKind::SEQUENCES_KW,
    SyntaxKind::SERIALIZABLE_KW,
    SyntaxKind::SERVER_KW,
    SyntaxKind::SESSION_KW,
    SyntaxKind::SET_KW,
    SyntaxKind::SETOF_KW,
    SyntaxKind::SETS_KW,
    SyntaxKind::SHARE_KW,
    SyntaxKind::SHOW_KW,
    SyntaxKind::SIMILAR_KW,
    SyntaxKind::SIMPLE_KW,
    SyntaxKind::SKIP_KW,
    SyntaxKind::SMALLINT_KW,
    SyntaxKind::SNAPSHOT_KW,
    SyntaxKind::SOURCE_KW,
    SyntaxKind::SPLIT_KW,
    SyntaxKind::SQL_KW,
    SyntaxKind::STABLE_KW,
    SyntaxKind::STANDALONE_KW,
    SyntaxKind::START_KW,
    SyntaxKind::STATEMENT_KW,
    SyntaxKind::STATISTICS_KW,
    SyntaxKind::STDIN_KW,
    SyntaxKind::STDOUT_KW,
    SyntaxKind::STORAGE_KW,
    SyntaxKind::STORED_KW,
    SyntaxKind::STRICT_KW,
    SyntaxKind::STRING_KW,
    SyntaxKind::STRIP_KW,
    SyntaxKind::SUBSCRIPTION_KW,
    SyntaxKind::SUBSTRING_KW,
    SyntaxKind::SUPPORT_KW,
    SyntaxKind::SYSID_KW,
    SyntaxKind::SYSTEM_KW,
    SyntaxKind::TABLES_KW,
    SyntaxKind::TABLESAMPLE_KW,
    SyntaxKind::TABLESPACE_KW,
    SyntaxKind::TARGET_KW,
    SyntaxKind::TEMP_KW,
    SyntaxKind::TEMPLATE_KW,
    SyntaxKind::TEMPORARY_KW,
    SyntaxKind::TEXT_KW,
    SyntaxKind::TIES_KW,
    SyntaxKind::TIME_KW,
    SyntaxKind::TIMESTAMP_KW,
    SyntaxKind::TRANSACTION_KW,
    SyntaxKind::TRANSFORM_KW,
    SyntaxKind::TREAT_KW,
    SyntaxKind::TRIGGER_KW,
    SyntaxKind::TRIM_KW,
    SyntaxKind::TRUNCATE_KW,
    SyntaxKind::TRUSTED_KW,
    SyntaxKind::TYPE_KW,
    SyntaxKind::TYPES_KW,
    SyntaxKind::UESCAPE_KW,
    SyntaxKind::UNBOUNDED_KW,
    SyntaxKind::UNCOMMITTED_KW,
    SyntaxKind::UNCONDITIONAL_KW,
    SyntaxKind::UNENCRYPTED_KW,
    SyntaxKind::UNKNOWN_KW,
    SyntaxKind::UNLISTEN_KW,
    SyntaxKind::UNLOGGED_KW,
    SyntaxKind::UNTIL_KW,
    SyntaxKind::UPDATE_KW,
    SyntaxKind::VACUUM_KW,
    SyntaxKind::VALID_KW,
    SyntaxKind::VALIDATE_KW,
    SyntaxKind::VALIDATOR_KW,
    SyntaxKind::VALUE_KW,
    SyntaxKind::VALUES_KW,
    SyntaxKind::VARCHAR_KW,
    SyntaxKind::VARYING_KW,
    SyntaxKind::VERBOSE_KW,
    SyntaxKind::VERSION_KW,
    SyntaxKind::VIEW_KW,
    SyntaxKind::VIEWS_KW,
    SyntaxKind::VIRTUAL_KW,
    SyntaxKind::VOLATILE_KW,
    SyntaxKind::WAIT_KW,
    SyntaxKind::WHITESPACE_KW,
    SyntaxKind::WITHIN_KW,
    SyntaxKind::WITHOUT_KW,
    SyntaxKind::WORK_KW,
    SyntaxKind::WRAPPER_KW,
    SyntaxKind::WRITE_KW,
    SyntaxKind::XML_KW,
    SyntaxKind::XMLATTRIBUTES_KW,
    SyntaxKind::XMLCONCAT_KW,
    SyntaxKind::XMLELEMENT_KW,
    SyntaxKind::XMLEXISTS_KW,
    SyntaxKind::XMLFOREST_KW,
    SyntaxKind::XMLNAMESPACES_KW,
    SyntaxKind::XMLPARSE_KW,
    SyntaxKind::XMLPI_KW,
    SyntaxKind::XMLROOT_KW,
    SyntaxKind::XMLSERIALIZE_KW,
    SyntaxKind::XMLTABLE_KW,
    SyntaxKind::YEAR_KW,
    SyntaxKind::YES_KW,
    SyntaxKind::ZONE_KW,
]);

pub(crate) const ALL_KEYWORDS: TokenSet = TokenSet::new(&[
    SyntaxKind::ABORT_KW,
    SyntaxKind::ABSENT_KW,
    SyntaxKind::ABSOLUTE_KW,
    SyntaxKind::ACCESS_KW,
    SyntaxKind::ACTION_KW,
    SyntaxKind::ADD_KW,
    SyntaxKind::ADMIN_KW,
    SyntaxKind::AFTER_KW,
    SyntaxKind::AGGREGATE_KW,
    SyntaxKind::ALL_KW,
    SyntaxKind::ALSO_KW,
    SyntaxKind::ALTER_KW,
    SyntaxKind::ALWAYS_KW,
    SyntaxKind::ANALYSE_KW,
    SyntaxKind::ANALYZE_KW,
    SyntaxKind::AND_KW,
    SyntaxKind::ANY_KW,
    SyntaxKind::ARRAY_KW,
    SyntaxKind::AS_KW,
    SyntaxKind::ASC_KW,
    SyntaxKind::ASENSITIVE_KW,
    SyntaxKind::ASSERTION_KW,
    SyntaxKind::ASSIGNMENT_KW,
    SyntaxKind::ASYMMETRIC_KW,
    SyntaxKind::AT_KW,
    SyntaxKind::ATOMIC_KW,
    SyntaxKind::ATTACH_KW,
    SyntaxKind::ATTRIBUTE_KW,
    SyntaxKind::AUTHORIZATION_KW,
    SyntaxKind::BACKWARD_KW,
    SyntaxKind::BEFORE_KW,
    SyntaxKind::BEGIN_KW,
    SyntaxKind::BETWEEN_KW,
    SyntaxKind::BIGINT_KW,
    SyntaxKind::BINARY_KW,
    SyntaxKind::BIT_KW,
    SyntaxKind::BOOLEAN_KW,
    SyntaxKind::BOTH_KW,
    SyntaxKind::BREADTH_KW,
    SyntaxKind::BY_KW,
    SyntaxKind::CACHE_KW,
    SyntaxKind::CALL_KW,
    SyntaxKind::CALLED_KW,
    SyntaxKind::CASCADE_KW,
    SyntaxKind::CASCADED_KW,
    SyntaxKind::CASE_KW,
    SyntaxKind::CAST_KW,
    SyntaxKind::CATALOG_KW,
    SyntaxKind::CHAIN_KW,
    SyntaxKind::CHAR_KW,
    SyntaxKind::CHARACTER_KW,
    SyntaxKind::CHARACTERISTICS_KW,
    SyntaxKind::CHECK_KW,
    SyntaxKind::CHECKPOINT_KW,
    SyntaxKind::CLASS_KW,
    SyntaxKind::CLOSE_KW,
    SyntaxKind::CLUSTER_KW,
    SyntaxKind::COALESCE_KW,
    SyntaxKind::COLLATE_KW,
    SyntaxKind::COLLATION_KW,
    SyntaxKind::COLUMN_KW,
    SyntaxKind::COLUMNS_KW,
    SyntaxKind::COMMENT_KW,
    SyntaxKind::COMMENTS_KW,
    SyntaxKind::COMMIT_KW,
    SyntaxKind::COMMITTED_KW,
    SyntaxKind::COMPRESSION_KW,
    SyntaxKind::CONCURRENTLY_KW,
    SyntaxKind::CONDITIONAL_KW,
    SyntaxKind::CONFIGURATION_KW,
    SyntaxKind::CONFLICT_KW,
    SyntaxKind::CONNECTION_KW,
    SyntaxKind::CONSTRAINT_KW,
    SyntaxKind::CONSTRAINTS_KW,
    SyntaxKind::CONTENT_KW,
    SyntaxKind::CONTINUE_KW,
    SyntaxKind::CONVERSION_KW,
    SyntaxKind::COPY_KW,
    SyntaxKind::COST_KW,
    SyntaxKind::CREATE_KW,
    SyntaxKind::CROSS_KW,
    SyntaxKind::CSV_KW,
    SyntaxKind::CUBE_KW,
    SyntaxKind::CURRENT_KW,
    SyntaxKind::CURRENT_CATALOG_KW,
    SyntaxKind::CURRENT_DATE_KW,
    SyntaxKind::CURRENT_ROLE_KW,
    SyntaxKind::CURRENT_SCHEMA_KW,
    SyntaxKind::CURRENT_TIME_KW,
    SyntaxKind::CURRENT_TIMESTAMP_KW,
    SyntaxKind::CURRENT_USER_KW,
    SyntaxKind::CURSOR_KW,
    SyntaxKind::CYCLE_KW,
    SyntaxKind::DATA_KW,
    SyntaxKind::DATABASE_KW,
    SyntaxKind::DAY_KW,
    SyntaxKind::DEALLOCATE_KW,
    SyntaxKind::DEC_KW,
    SyntaxKind::DECIMAL_KW,
    SyntaxKind::DECLARE_KW,
    SyntaxKind::DEFAULT_KW,
    SyntaxKind::DEFAULTS_KW,
    SyntaxKind::DEFERRABLE_KW,
    SyntaxKind::DEFERRED_KW,
    SyntaxKind::DEFINER_KW,
    SyntaxKind::DELETE_KW,
    SyntaxKind::DELIMITER_KW,
    SyntaxKind::DELIMITERS_KW,
    SyntaxKind::DEPENDS_KW,
    SyntaxKind::DEPTH_KW,
    SyntaxKind::DESC_KW,
    SyntaxKind::DETACH_KW,
    SyntaxKind::DICTIONARY_KW,
    SyntaxKind::DISABLE_KW,
    SyntaxKind::DISCARD_KW,
    SyntaxKind::DISTINCT_KW,
    SyntaxKind::DO_KW,
    SyntaxKind::DOCUMENT_KW,
    SyntaxKind::DOMAIN_KW,
    SyntaxKind::DOUBLE_KW,
    SyntaxKind::DROP_KW,
    SyntaxKind::EACH_KW,
    SyntaxKind::ELSE_KW,
    SyntaxKind::EMPTY_KW,
    SyntaxKind::ENABLE_KW,
    SyntaxKind::ENCODING_KW,
    SyntaxKind::ENCRYPTED_KW,
    SyntaxKind::END_KW,
    SyntaxKind::ENFORCED_KW,
    SyntaxKind::ENUM_KW,
    SyntaxKind::ERROR_KW,
    SyntaxKind::ESCAPE_KW,
    SyntaxKind::EVENT_KW,
    SyntaxKind::EXCEPT_KW,
    SyntaxKind::EXCLUDE_KW,
    SyntaxKind::EXCLUDING_KW,
    SyntaxKind::EXCLUSIVE_KW,
    SyntaxKind::EXECUTE_KW,
    SyntaxKind::EXISTS_KW,
    SyntaxKind::EXPLAIN_KW,
    SyntaxKind::EXPRESSION_KW,
    SyntaxKind::EXTENSION_KW,
    SyntaxKind::EXTERNAL_KW,
    SyntaxKind::EXTRACT_KW,
    SyntaxKind::FALSE_KW,
    SyntaxKind::FAMILY_KW,
    SyntaxKind::FETCH_KW,
    SyntaxKind::FILTER_KW,
    SyntaxKind::FINALIZE_KW,
    SyntaxKind::FIRST_KW,
    SyntaxKind::FLOAT_KW,
    SyntaxKind::FOLLOWING_KW,
    SyntaxKind::FOR_KW,
    SyntaxKind::FORCE_KW,
    SyntaxKind::FOREIGN_KW,
    SyntaxKind::FORMAT_KW,
    SyntaxKind::FORWARD_KW,
    SyntaxKind::FREEZE_KW,
    SyntaxKind::FROM_KW,
    SyntaxKind::FULL_KW,
    SyntaxKind::FUNCTION_KW,
    SyntaxKind::FUNCTIONS_KW,
    SyntaxKind::GENERATED_KW,
    SyntaxKind::GLOBAL_KW,
    SyntaxKind::GRANT_KW,
    SyntaxKind::GRANTED_KW,
    SyntaxKind::GREATEST_KW,
    SyntaxKind::GROUP_KW,
    SyntaxKind::GROUPING_KW,
    SyntaxKind::GROUPS_KW,
    SyntaxKind::HANDLER_KW,
    SyntaxKind::HAVING_KW,
    SyntaxKind::HEADER_KW,
    SyntaxKind::HOLD_KW,
    SyntaxKind::HOUR_KW,
    SyntaxKind::IDENTITY_KW,
    SyntaxKind::IF_KW,
    SyntaxKind::IGNORE_KW,
    SyntaxKind::ILIKE_KW,
    SyntaxKind::IMMEDIATE_KW,
    SyntaxKind::IMMUTABLE_KW,
    SyntaxKind::IMPLICIT_KW,
    SyntaxKind::IMPORT_KW,
    SyntaxKind::IN_KW,
    SyntaxKind::INCLUDE_KW,
    SyntaxKind::INCLUDING_KW,
    SyntaxKind::INCREMENT_KW,
    SyntaxKind::INDENT_KW,
    SyntaxKind::INDEX_KW,
    SyntaxKind::INDEXES_KW,
    SyntaxKind::INHERIT_KW,
    SyntaxKind::INHERITS_KW,
    SyntaxKind::INITIALLY_KW,
    SyntaxKind::INLINE_KW,
    SyntaxKind::INNER_KW,
    SyntaxKind::INOUT_KW,
    SyntaxKind::INPUT_KW,
    SyntaxKind::INSENSITIVE_KW,
    SyntaxKind::INSERT_KW,
    SyntaxKind::INSTEAD_KW,
    SyntaxKind::INT_KW,
    SyntaxKind::INTEGER_KW,
    SyntaxKind::INTERSECT_KW,
    SyntaxKind::INTERVAL_KW,
    SyntaxKind::INTO_KW,
    SyntaxKind::INVOKER_KW,
    SyntaxKind::IS_KW,
    SyntaxKind::ISNULL_KW,
    SyntaxKind::ISOLATION_KW,
    SyntaxKind::JOIN_KW,
    SyntaxKind::JSON_KW,
    SyntaxKind::JSON_ARRAY_KW,
    SyntaxKind::JSON_ARRAYAGG_KW,
    SyntaxKind::JSON_EXISTS_KW,
    SyntaxKind::JSON_OBJECT_KW,
    SyntaxKind::JSON_OBJECTAGG_KW,
    SyntaxKind::JSON_QUERY_KW,
    SyntaxKind::JSON_SCALAR_KW,
    SyntaxKind::JSON_SERIALIZE_KW,
    SyntaxKind::JSON_TABLE_KW,
    SyntaxKind::JSON_VALUE_KW,
    SyntaxKind::KEEP_KW,
    SyntaxKind::KEY_KW,
    SyntaxKind::KEYS_KW,
    SyntaxKind::LABEL_KW,
    SyntaxKind::LANGUAGE_KW,
    SyntaxKind::LARGE_KW,
    SyntaxKind::LAST_KW,
    SyntaxKind::LATERAL_KW,
    SyntaxKind::LEADING_KW,
    SyntaxKind::LEAKPROOF_KW,
    SyntaxKind::LEAST_KW,
    SyntaxKind::LEFT_KW,
    SyntaxKind::LEVEL_KW,
    SyntaxKind::LIKE_KW,
    SyntaxKind::LIMIT_KW,
    SyntaxKind::LISTEN_KW,
    SyntaxKind::LOAD_KW,
    SyntaxKind::LOCAL_KW,
    SyntaxKind::LOCALTIME_KW,
    SyntaxKind::LOCALTIMESTAMP_KW,
    SyntaxKind::LOCATION_KW,
    SyntaxKind::LOCK_KW,
    SyntaxKind::LOCKED_KW,
    SyntaxKind::LOGGED_KW,
    SyntaxKind::LSN_KW,
    SyntaxKind::MAPPING_KW,
    SyntaxKind::MATCH_KW,
    SyntaxKind::MATCHED_KW,
    SyntaxKind::MATERIALIZED_KW,
    SyntaxKind::MAXVALUE_KW,
    SyntaxKind::MERGE_KW,
    SyntaxKind::MERGE_ACTION_KW,
    SyntaxKind::METHOD_KW,
    SyntaxKind::MINUTE_KW,
    SyntaxKind::MINVALUE_KW,
    SyntaxKind::MODE_KW,
    SyntaxKind::MONTH_KW,
    SyntaxKind::MOVE_KW,
    SyntaxKind::NAME_KW,
    SyntaxKind::NAMES_KW,
    SyntaxKind::NATIONAL_KW,
    SyntaxKind::NATURAL_KW,
    SyntaxKind::NCHAR_KW,
    SyntaxKind::NESTED_KW,
    SyntaxKind::NEW_KW,
    SyntaxKind::NEXT_KW,
    SyntaxKind::NFC_KW,
    SyntaxKind::NFD_KW,
    SyntaxKind::NFKC_KW,
    SyntaxKind::NFKD_KW,
    SyntaxKind::NO_KW,
    SyntaxKind::NONE_KW,
    SyntaxKind::NORMALIZE_KW,
    SyntaxKind::NORMALIZED_KW,
    SyntaxKind::NOT_KW,
    SyntaxKind::NOTHING_KW,
    SyntaxKind::NOTIFY_KW,
    SyntaxKind::NOTNULL_KW,
    SyntaxKind::NOWAIT_KW,
    SyntaxKind::NULL_KW,
    SyntaxKind::NULLIF_KW,
    SyntaxKind::NULLS_KW,
    SyntaxKind::NUMERIC_KW,
    SyntaxKind::OBJECT_KW,
    SyntaxKind::OBJECTS_KW,
    SyntaxKind::OF_KW,
    SyntaxKind::OFF_KW,
    SyntaxKind::OFFSET_KW,
    SyntaxKind::OIDS_KW,
    SyntaxKind::OLD_KW,
    SyntaxKind::OMIT_KW,
    SyntaxKind::ON_KW,
    SyntaxKind::ONLY_KW,
    SyntaxKind::OPERATOR_KW,
    SyntaxKind::OPTION_KW,
    SyntaxKind::OPTIONS_KW,
    SyntaxKind::OR_KW,
    SyntaxKind::ORDER_KW,
    SyntaxKind::ORDINALITY_KW,
    SyntaxKind::OTHERS_KW,
    SyntaxKind::OUT_KW,
    SyntaxKind::OUTER_KW,
    SyntaxKind::OVER_KW,
    SyntaxKind::OVERLAPS_KW,
    SyntaxKind::OVERLAY_KW,
    SyntaxKind::OVERRIDING_KW,
    SyntaxKind::OWNED_KW,
    SyntaxKind::OWNER_KW,
    SyntaxKind::PARALLEL_KW,
    SyntaxKind::PARAMETER_KW,
    SyntaxKind::PARSER_KW,
    SyntaxKind::PARTIAL_KW,
    SyntaxKind::PARTITION_KW,
    SyntaxKind::PARTITIONS_KW,
    SyntaxKind::PASSING_KW,
    SyntaxKind::PASSWORD_KW,
    SyntaxKind::PATH_KW,
    SyntaxKind::PERIOD_KW,
    SyntaxKind::PLACING_KW,
    SyntaxKind::PLAN_KW,
    SyntaxKind::PLANS_KW,
    SyntaxKind::POLICY_KW,
    SyntaxKind::POSITION_KW,
    SyntaxKind::PRECEDING_KW,
    SyntaxKind::PRECISION_KW,
    SyntaxKind::PREPARE_KW,
    SyntaxKind::PREPARED_KW,
    SyntaxKind::PRESERVE_KW,
    SyntaxKind::PRIMARY_KW,
    SyntaxKind::PRIOR_KW,
    SyntaxKind::PRIVILEGES_KW,
    SyntaxKind::PROCEDURAL_KW,
    SyntaxKind::PROCEDURE_KW,
    SyntaxKind::PROCEDURES_KW,
    SyntaxKind::PROGRAM_KW,
    SyntaxKind::PUBLICATION_KW,
    SyntaxKind::QUOTE_KW,
    SyntaxKind::QUOTES_KW,
    SyntaxKind::RANGE_KW,
    SyntaxKind::READ_KW,
    SyntaxKind::REAL_KW,
    SyntaxKind::REASSIGN_KW,
    SyntaxKind::RECURSIVE_KW,
    SyntaxKind::REF_KW,
    SyntaxKind::REFERENCES_KW,
    SyntaxKind::REFERENCING_KW,
    SyntaxKind::REFRESH_KW,
    SyntaxKind::REINDEX_KW,
    SyntaxKind::RELATIVE_KW,
    SyntaxKind::RELEASE_KW,
    SyntaxKind::RENAME_KW,
    SyntaxKind::REPEATABLE_KW,
    SyntaxKind::REPLACE_KW,
    SyntaxKind::REPLICA_KW,
    SyntaxKind::RESET_KW,
    SyntaxKind::RESPECT_KW,
    SyntaxKind::RESTART_KW,
    SyntaxKind::RESTRICT_KW,
    SyntaxKind::RETURN_KW,
    SyntaxKind::RETURNING_KW,
    SyntaxKind::RETURNS_KW,
    SyntaxKind::REVOKE_KW,
    SyntaxKind::RIGHT_KW,
    SyntaxKind::ROLE_KW,
    SyntaxKind::ROLLBACK_KW,
    SyntaxKind::ROLLUP_KW,
    SyntaxKind::ROUTINE_KW,
    SyntaxKind::ROUTINES_KW,
    SyntaxKind::ROW_KW,
    SyntaxKind::ROWS_KW,
    SyntaxKind::RULE_KW,
    SyntaxKind::SAVEPOINT_KW,
    SyntaxKind::SCALAR_KW,
    SyntaxKind::SCHEMA_KW,
    SyntaxKind::SCHEMAS_KW,
    SyntaxKind::SCROLL_KW,
    SyntaxKind::SEARCH_KW,
    SyntaxKind::SECOND_KW,
    SyntaxKind::SECURITY_KW,
    SyntaxKind::SELECT_KW,
    SyntaxKind::SEQUENCE_KW,
    SyntaxKind::SEQUENCES_KW,
    SyntaxKind::SERIALIZABLE_KW,
    SyntaxKind::SERVER_KW,
    SyntaxKind::SESSION_KW,
    SyntaxKind::SESSION_USER_KW,
    SyntaxKind::SET_KW,
    SyntaxKind::SETOF_KW,
    SyntaxKind::SETS_KW,
    SyntaxKind::SHARE_KW,
    SyntaxKind::SHOW_KW,
    SyntaxKind::SIMILAR_KW,
    SyntaxKind::SIMPLE_KW,
    SyntaxKind::SKIP_KW,
    SyntaxKind::SMALLINT_KW,
    SyntaxKind::SNAPSHOT_KW,
    SyntaxKind::SOME_KW,
    SyntaxKind::SOURCE_KW,
    SyntaxKind::SPLIT_KW,
    SyntaxKind::SQL_KW,
    SyntaxKind::STABLE_KW,
    SyntaxKind::STANDALONE_KW,
    SyntaxKind::START_KW,
    SyntaxKind::STATEMENT_KW,
    SyntaxKind::STATISTICS_KW,
    SyntaxKind::STDIN_KW,
    SyntaxKind::STDOUT_KW,
    SyntaxKind::STORAGE_KW,
    SyntaxKind::STORED_KW,
    SyntaxKind::STRICT_KW,
    SyntaxKind::STRING_KW,
    SyntaxKind::STRIP_KW,
    SyntaxKind::SUBSCRIPTION_KW,
    SyntaxKind::SUBSTRING_KW,
    SyntaxKind::SUPPORT_KW,
    SyntaxKind::SYMMETRIC_KW,
    SyntaxKind::SYSID_KW,
    SyntaxKind::SYSTEM_KW,
    SyntaxKind::SYSTEM_USER_KW,
    SyntaxKind::TABLE_KW,
    SyntaxKind::TABLES_KW,
    SyntaxKind::TABLESAMPLE_KW,
    SyntaxKind::TABLESPACE_KW,
    SyntaxKind::TARGET_KW,
    SyntaxKind::TEMP_KW,
    SyntaxKind::TEMPLATE_KW,
    SyntaxKind::TEMPORARY_KW,
    SyntaxKind::TEXT_KW,
    SyntaxKind::THEN_KW,
    SyntaxKind::TIES_KW,
    SyntaxKind::TIME_KW,
    SyntaxKind::TIMESTAMP_KW,
    SyntaxKind::TO_KW,
    SyntaxKind::TRAILING_KW,
    SyntaxKind::TRANSACTION_KW,
    SyntaxKind::TRANSFORM_KW,
    SyntaxKind::TREAT_KW,
    SyntaxKind::TRIGGER_KW,
    SyntaxKind::TRIM_KW,
    SyntaxKind::TRUE_KW,
    SyntaxKind::TRUNCATE_KW,
    SyntaxKind::TRUSTED_KW,
    SyntaxKind::TYPE_KW,
    SyntaxKind::TYPES_KW,
    SyntaxKind::UESCAPE_KW,
    SyntaxKind::UNBOUNDED_KW,
    SyntaxKind::UNCOMMITTED_KW,
    SyntaxKind::UNCONDITIONAL_KW,
    SyntaxKind::UNENCRYPTED_KW,
    SyntaxKind::UNION_KW,
    SyntaxKind::UNIQUE_KW,
    SyntaxKind::UNKNOWN_KW,
    SyntaxKind::UNLISTEN_KW,
    SyntaxKind::UNLOGGED_KW,
    SyntaxKind::UNTIL_KW,
    SyntaxKind::UPDATE_KW,
    SyntaxKind::USER_KW,
    SyntaxKind::USING_KW,
    SyntaxKind::VACUUM_KW,
    SyntaxKind::VALID_KW,
    SyntaxKind::VALIDATE_KW,
    SyntaxKind::VALIDATOR_KW,
    SyntaxKind::VALUE_KW,
    SyntaxKind::VALUES_KW,
    SyntaxKind::VARCHAR_KW,
    SyntaxKind::VARIADIC_KW,
    SyntaxKind::VARYING_KW,
    SyntaxKind::VERBOSE_KW,
    SyntaxKind::VERSION_KW,
    SyntaxKind::VIEW_KW,
    SyntaxKind::VIEWS_KW,
    SyntaxKind::VIRTUAL_KW,
    SyntaxKind::VOLATILE_KW,
    SyntaxKind::WAIT_KW,
    SyntaxKind::WHEN_KW,
    SyntaxKind::WHERE_KW,
    SyntaxKind::WHITESPACE_KW,
    SyntaxKind::WINDOW_KW,
    SyntaxKind::WITH_KW,
    SyntaxKind::WITHIN_KW,
    SyntaxKind::WITHOUT_KW,
    SyntaxKind::WORK_KW,
    SyntaxKind::WRAPPER_KW,
    SyntaxKind::WRITE_KW,
    SyntaxKind::XML_KW,
    SyntaxKind::XMLATTRIBUTES_KW,
    SyntaxKind::XMLCONCAT_KW,
    SyntaxKind::XMLELEMENT_KW,
    SyntaxKind::XMLEXISTS_KW,
    SyntaxKind::XMLFOREST_KW,
    SyntaxKind::XMLNAMESPACES_KW,
    SyntaxKind::XMLPARSE_KW,
    SyntaxKind::XMLPI_KW,
    SyntaxKind::XMLROOT_KW,
    SyntaxKind::XMLSERIALIZE_KW,
    SyntaxKind::XMLTABLE_KW,
    SyntaxKind::YEAR_KW,
    SyntaxKind::YES_KW,
    SyntaxKind::ZONE_KW,
]);

pub(crate) const BARE_LABEL_KEYWORDS: TokenSet = TokenSet::new(&[
    SyntaxKind::ABORT_KW,
    SyntaxKind::ABSENT_KW,
    SyntaxKind::ABSOLUTE_KW,
    SyntaxKind::ACCESS_KW,
    SyntaxKind::ACTION_KW,
    SyntaxKind::ADD_KW,
    SyntaxKind::ADMIN_KW,
    SyntaxKind::AFTER_KW,
    SyntaxKind::AGGREGATE_KW,
    SyntaxKind::ALL_KW,
    SyntaxKind::ALSO_KW,
    SyntaxKind::ALTER_KW,
    SyntaxKind::ALWAYS_KW,
    SyntaxKind::ANALYSE_KW,
    SyntaxKind::ANALYZE_KW,
    SyntaxKind::AND_KW,
    SyntaxKind::ANY_KW,
    SyntaxKind::ASC_KW,
    SyntaxKind::ASENSITIVE_KW,
    SyntaxKind::ASSERTION_KW,
    SyntaxKind::ASSIGNMENT_KW,
    SyntaxKind::ASYMMETRIC_KW,
    SyntaxKind::AT_KW,
    SyntaxKind::ATOMIC_KW,
    SyntaxKind::ATTACH_KW,
    SyntaxKind::ATTRIBUTE_KW,
    SyntaxKind::AUTHORIZATION_KW,
    SyntaxKind::BACKWARD_KW,
    SyntaxKind::BEFORE_KW,
    SyntaxKind::BEGIN_KW,
    SyntaxKind::BETWEEN_KW,
    SyntaxKind::BIGINT_KW,
    SyntaxKind::BINARY_KW,
    SyntaxKind::BIT_KW,
    SyntaxKind::BOOLEAN_KW,
    SyntaxKind::BOTH_KW,
    SyntaxKind::BREADTH_KW,
    SyntaxKind::BY_KW,
    SyntaxKind::CACHE_KW,
    SyntaxKind::CALL_KW,
    SyntaxKind::CALLED_KW,
    SyntaxKind::CASCADE_KW,
    SyntaxKind::CASCADED_KW,
    SyntaxKind::CASE_KW,
    SyntaxKind::CAST_KW,
    SyntaxKind::CATALOG_KW,
    SyntaxKind::CHAIN_KW,
    SyntaxKind::CHARACTERISTICS_KW,
    SyntaxKind::CHECK_KW,
    SyntaxKind::CHECKPOINT_KW,
    SyntaxKind::CLASS_KW,
    SyntaxKind::CLOSE_KW,
    SyntaxKind::CLUSTER_KW,
    SyntaxKind::COALESCE_KW,
    SyntaxKind::COLLATE_KW,
    SyntaxKind::COLLATION_KW,
    SyntaxKind::COLUMN_KW,
    SyntaxKind::COLUMNS_KW,
    SyntaxKind::COMMENT_KW,
    SyntaxKind::COMMENTS_KW,
    SyntaxKind::COMMIT_KW,
    SyntaxKind::COMMITTED_KW,
    SyntaxKind::COMPRESSION_KW,
    SyntaxKind::CONCURRENTLY_KW,
    SyntaxKind::CONDITIONAL_KW,
    SyntaxKind::CONFIGURATION_KW,
    SyntaxKind::CONFLICT_KW,
    SyntaxKind::CONNECTION_KW,
    SyntaxKind::CONSTRAINT_KW,
    SyntaxKind::CONSTRAINTS_KW,
    SyntaxKind::CONTENT_KW,
    SyntaxKind::CONTINUE_KW,
    SyntaxKind::CONVERSION_KW,
    SyntaxKind::COPY_KW,
    SyntaxKind::COST_KW,
    SyntaxKind::CROSS_KW,
    SyntaxKind::CSV_KW,
    SyntaxKind::CUBE_KW,
    SyntaxKind::CURRENT_KW,
    SyntaxKind::CURRENT_CATALOG_KW,
    SyntaxKind::CURRENT_DATE_KW,
    SyntaxKind::CURRENT_ROLE_KW,
    SyntaxKind::CURRENT_SCHEMA_KW,
    SyntaxKind::CURRENT_TIME_KW,
    SyntaxKind::CURRENT_TIMESTAMP_KW,
    SyntaxKind::CURRENT_USER_KW,
    SyntaxKind::CURSOR_KW,
    SyntaxKind::CYCLE_KW,
    SyntaxKind::DATA_KW,
    SyntaxKind::DATABASE_KW,
    SyntaxKind::DEALLOCATE_KW,
    SyntaxKind::DEC_KW,
    SyntaxKind::DECIMAL_KW,
    SyntaxKind::DECLARE_KW,
    SyntaxKind::DEFAULT_KW,
    SyntaxKind::DEFAULTS_KW,
    SyntaxKind::DEFERRABLE_KW,
    SyntaxKind::DEFERRED_KW,
    SyntaxKind::DEFINER_KW,
    SyntaxKind::DELETE_KW,
    SyntaxKind::DELIMITER_KW,
    SyntaxKind::DELIMITERS_KW,
    SyntaxKind::DEPENDS_KW,
    SyntaxKind::DEPTH_KW,
    SyntaxKind::DESC_KW,
    SyntaxKind::DETACH_KW,
    SyntaxKind::DICTIONARY_KW,
    SyntaxKind::DISABLE_KW,
    SyntaxKind::DISCARD_KW,
    SyntaxKind::DISTINCT_KW,
    SyntaxKind::DO_KW,
    SyntaxKind::DOCUMENT_KW,
    SyntaxKind::DOMAIN_KW,
    SyntaxKind::DOUBLE_KW,
    SyntaxKind::DROP_KW,
    SyntaxKind::EACH_KW,
    SyntaxKind::ELSE_KW,
    SyntaxKind::EMPTY_KW,
    SyntaxKind::ENABLE_KW,
    SyntaxKind::ENCODING_KW,
    SyntaxKind::ENCRYPTED_KW,
    SyntaxKind::END_KW,
    SyntaxKind::ENFORCED_KW,
    SyntaxKind::ENUM_KW,
    SyntaxKind::ERROR_KW,
    SyntaxKind::ESCAPE_KW,
    SyntaxKind::EVENT_KW,
    SyntaxKind::EXCLUDE_KW,
    SyntaxKind::EXCLUDING_KW,
    SyntaxKind::EXCLUSIVE_KW,
    SyntaxKind::EXECUTE_KW,
    SyntaxKind::EXISTS_KW,
    SyntaxKind::EXPLAIN_KW,
    SyntaxKind::EXPRESSION_KW,
    SyntaxKind::EXTENSION_KW,
    SyntaxKind::EXTERNAL_KW,
    SyntaxKind::EXTRACT_KW,
    SyntaxKind::FALSE_KW,
    SyntaxKind::FAMILY_KW,
    SyntaxKind::FINALIZE_KW,
    SyntaxKind::FIRST_KW,
    SyntaxKind::FLOAT_KW,
    SyntaxKind::FOLLOWING_KW,
    SyntaxKind::FORCE_KW,
    SyntaxKind::FOREIGN_KW,
    SyntaxKind::FORMAT_KW,
    SyntaxKind::FORWARD_KW,
    SyntaxKind::FREEZE_KW,
    SyntaxKind::FULL_KW,
    SyntaxKind::FUNCTION_KW,
    SyntaxKind::FUNCTIONS_KW,
    SyntaxKind::GENERATED_KW,
    SyntaxKind::GLOBAL_KW,
    SyntaxKind::GRANTED_KW,
    SyntaxKind::GREATEST_KW,
    SyntaxKind::GROUPING_KW,
    SyntaxKind::GROUPS_KW,
    SyntaxKind::HANDLER_KW,
    SyntaxKind::HEADER_KW,
    SyntaxKind::HOLD_KW,
    SyntaxKind::IDENTITY_KW,
    SyntaxKind::IF_KW,
    SyntaxKind::ILIKE_KW,
    SyntaxKind::IMMEDIATE_KW,
    SyntaxKind::IMMUTABLE_KW,
    SyntaxKind::IMPLICIT_KW,
    SyntaxKind::IMPORT_KW,
    SyntaxKind::IN_KW,
    SyntaxKind::INCLUDE_KW,
    SyntaxKind::INCLUDING_KW,
    SyntaxKind::INCREMENT_KW,
    SyntaxKind::INDENT_KW,
    SyntaxKind::INDEX_KW,
    SyntaxKind::INDEXES_KW,
    SyntaxKind::INHERIT_KW,
    SyntaxKind::INHERITS_KW,
    SyntaxKind::INITIALLY_KW,
    SyntaxKind::INLINE_KW,
    SyntaxKind::INNER_KW,
    SyntaxKind::INOUT_KW,
    SyntaxKind::INPUT_KW,
    SyntaxKind::INSENSITIVE_KW,
    SyntaxKind::INSERT_KW,
    SyntaxKind::INSTEAD_KW,
    SyntaxKind::INT_KW,
    SyntaxKind::INTEGER_KW,
    SyntaxKind::INTERVAL_KW,
    SyntaxKind::INVOKER_KW,
    SyntaxKind::IS_KW,
    SyntaxKind::ISOLATION_KW,
    SyntaxKind::JOIN_KW,
    SyntaxKind::JSON_KW,
    SyntaxKind::JSON_ARRAY_KW,
    SyntaxKind::JSON_ARRAYAGG_KW,
    SyntaxKind::JSON_EXISTS_KW,
    SyntaxKind::JSON_OBJECT_KW,
    SyntaxKind::JSON_OBJECTAGG_KW,
    SyntaxKind::JSON_QUERY_KW,
    SyntaxKind::JSON_SCALAR_KW,
    SyntaxKind::JSON_SERIALIZE_KW,
    SyntaxKind::JSON_TABLE_KW,
    SyntaxKind::JSON_VALUE_KW,
    SyntaxKind::KEEP_KW,
    SyntaxKind::KEY_KW,
    SyntaxKind::KEYS_KW,
    SyntaxKind::LABEL_KW,
    SyntaxKind::LANGUAGE_KW,
    SyntaxKind::LARGE_KW,
    SyntaxKind::LAST_KW,
    SyntaxKind::LATERAL_KW,
    SyntaxKind::LEADING_KW,
    SyntaxKind::LEAKPROOF_KW,
    SyntaxKind::LEAST_KW,
    SyntaxKind::LEFT_KW,
    SyntaxKind::LEVEL_KW,
    SyntaxKind::LIKE_KW,
    SyntaxKind::LISTEN_KW,
    SyntaxKind::LOAD_KW,
    SyntaxKind::LOCAL_KW,
    SyntaxKind::LOCALTIME_KW,
    SyntaxKind::LOCALTIMESTAMP_KW,
    SyntaxKind::LOCATION_KW,
    SyntaxKind::LOCK_KW,
    SyntaxKind::LOCKED_KW,
    SyntaxKind::LOGGED_KW,
    SyntaxKind::LSN_KW,
    SyntaxKind::MAPPING_KW,
    SyntaxKind::MATCH_KW,
    SyntaxKind::MATCHED_KW,
    SyntaxKind::MATERIALIZED_KW,
    SyntaxKind::MAXVALUE_KW,
    SyntaxKind::MERGE_KW,
    SyntaxKind::MERGE_ACTION_KW,
    SyntaxKind::METHOD_KW,
    SyntaxKind::MINVALUE_KW,
    SyntaxKind::MODE_KW,
    SyntaxKind::MOVE_KW,
    SyntaxKind::NAME_KW,
    SyntaxKind::NAMES_KW,
    SyntaxKind::NATIONAL_KW,
    SyntaxKind::NATURAL_KW,
    SyntaxKind::NCHAR_KW,
    SyntaxKind::NESTED_KW,
    SyntaxKind::NEW_KW,
    SyntaxKind::NEXT_KW,
    SyntaxKind::NFC_KW,
    SyntaxKind::NFD_KW,
    SyntaxKind::NFKC_KW,
    SyntaxKind::NFKD_KW,
    SyntaxKind::NO_KW,
    SyntaxKind::NONE_KW,
    SyntaxKind::NORMALIZE_KW,
    SyntaxKind::NORMALIZED_KW,
    SyntaxKind::NOT_KW,
    SyntaxKind::NOTHING_KW,
    SyntaxKind::NOTIFY_KW,
    SyntaxKind::NOWAIT_KW,
    SyntaxKind::NULL_KW,
    SyntaxKind::NULLIF_KW,
    SyntaxKind::NULLS_KW,
    SyntaxKind::NUMERIC_KW,
    SyntaxKind::OBJECT_KW,
    SyntaxKind::OBJECTS_KW,
    SyntaxKind::OF_KW,
    SyntaxKind::OFF_KW,
    SyntaxKind::OIDS_KW,
    SyntaxKind::OLD_KW,
    SyntaxKind::OMIT_KW,
    SyntaxKind::ONLY_KW,
    SyntaxKind::OPERATOR_KW,
    SyntaxKind::OPTION_KW,
    SyntaxKind::OPTIONS_KW,
    SyntaxKind::OR_KW,
    SyntaxKind::ORDINALITY_KW,
    SyntaxKind::OTHERS_KW,
    SyntaxKind::OUT_KW,
    SyntaxKind::OUTER_KW,
    SyntaxKind::OVERLAY_KW,
    SyntaxKind::OVERRIDING_KW,
    SyntaxKind::OWNED_KW,
    SyntaxKind::OWNER_KW,
    SyntaxKind::PARALLEL_KW,
    SyntaxKind::PARAMETER_KW,
    SyntaxKind::PARSER_KW,
    SyntaxKind::PARTIAL_KW,
    SyntaxKind::PARTITION_KW,
    SyntaxKind::PARTITIONS_KW,
    SyntaxKind::PASSING_KW,
    SyntaxKind::PASSWORD_KW,
    SyntaxKind::PATH_KW,
    SyntaxKind::PERIOD_KW,
    SyntaxKind::PLACING_KW,
    SyntaxKind::PLAN_KW,
    SyntaxKind::PLANS_KW,
    SyntaxKind::POLICY_KW,
    SyntaxKind::POSITION_KW,
    SyntaxKind::PRECEDING_KW,
    SyntaxKind::PREPARE_KW,
    SyntaxKind::PREPARED_KW,
    SyntaxKind::PRESERVE_KW,
    SyntaxKind::PRIMARY_KW,
    SyntaxKind::PRIOR_KW,
    SyntaxKind::PRIVILEGES_KW,
    SyntaxKind::PROCEDURAL_KW,
    SyntaxKind::PROCEDURE_KW,
    SyntaxKind::PROCEDURES_KW,
    SyntaxKind::PROGRAM_KW,
    SyntaxKind::PUBLICATION_KW,
    SyntaxKind::QUOTE_KW,
    SyntaxKind::QUOTES_KW,
    SyntaxKind::RANGE_KW,
    SyntaxKind::READ_KW,
    SyntaxKind::REAL_KW,
    SyntaxKind::REASSIGN_KW,
    SyntaxKind::RECURSIVE_KW,
    SyntaxKind::REF_KW,
    SyntaxKind::REFERENCES_KW,
    SyntaxKind::REFERENCING_KW,
    SyntaxKind::REFRESH_KW,
    SyntaxKind::REINDEX_KW,
    SyntaxKind::RELATIVE_KW,
    SyntaxKind::RELEASE_KW,
    SyntaxKind::RENAME_KW,
    SyntaxKind::REPEATABLE_KW,
    SyntaxKind::REPLACE_KW,
    SyntaxKind::REPLICA_KW,
    SyntaxKind::RESET_KW,
    SyntaxKind::RESTART_KW,
    SyntaxKind::RESTRICT_KW,
    SyntaxKind::RETURN_KW,
    SyntaxKind::RETURNS_KW,
    SyntaxKind::REVOKE_KW,
    SyntaxKind::RIGHT_KW,
    SyntaxKind::ROLE_KW,
    SyntaxKind::ROLLBACK_KW,
    SyntaxKind::ROLLUP_KW,
    SyntaxKind::ROUTINE_KW,
    SyntaxKind::ROUTINES_KW,
    SyntaxKind::ROW_KW,
    SyntaxKind::ROWS_KW,
    SyntaxKind::RULE_KW,
    SyntaxKind::SAVEPOINT_KW,
    SyntaxKind::SCALAR_KW,
    SyntaxKind::SCHEMA_KW,
    SyntaxKind::SCHEMAS_KW,
    SyntaxKind::SCROLL_KW,
    SyntaxKind::SEARCH_KW,
    SyntaxKind::SECURITY_KW,
    SyntaxKind::SELECT_KW,
    SyntaxKind::SEQUENCE_KW,
    SyntaxKind::SEQUENCES_KW,
    SyntaxKind::SERIALIZABLE_KW,
    SyntaxKind::SERVER_KW,
    SyntaxKind::SESSION_KW,
    SyntaxKind::SESSION_USER_KW,
    SyntaxKind::SET_KW,
    SyntaxKind::SETOF_KW,
    SyntaxKind::SETS_KW,
    SyntaxKind::SHARE_KW,
    SyntaxKind::SHOW_KW,
    SyntaxKind::SIMILAR_KW,
    SyntaxKind::SIMPLE_KW,
    SyntaxKind::SKIP_KW,
    SyntaxKind::SMALLINT_KW,
    SyntaxKind::SNAPSHOT_KW,
    SyntaxKind::SOME_KW,
    SyntaxKind::SOURCE_KW,
    SyntaxKind::SPLIT_KW,
    SyntaxKind::SQL_KW,
    SyntaxKind::STABLE_KW,
    SyntaxKind::STANDALONE_KW,
    SyntaxKind::START_KW,
    SyntaxKind::STATEMENT_KW,
    SyntaxKind::STATISTICS_KW,
    SyntaxKind::STDIN_KW,
    SyntaxKind::STDOUT_KW,
    SyntaxKind::STORAGE_KW,
    SyntaxKind::STORED_KW,
    SyntaxKind::STRICT_KW,
    SyntaxKind::STRING_KW,
    SyntaxKind::STRIP_KW,
    SyntaxKind::SUBSCRIPTION_KW,
    SyntaxKind::SUBSTRING_KW,
    SyntaxKind::SUPPORT_KW,
    SyntaxKind::SYMMETRIC_KW,
    SyntaxKind::SYSID_KW,
    SyntaxKind::SYSTEM_KW,
    SyntaxKind::SYSTEM_USER_KW,
    SyntaxKind::TABLE_KW,
    SyntaxKind::TABLES_KW,
    SyntaxKind::TABLESAMPLE_KW,
    SyntaxKind::TABLESPACE_KW,
    SyntaxKind::TARGET_KW,
    SyntaxKind::TEMP_KW,
    SyntaxKind::TEMPLATE_KW,
    SyntaxKind::TEMPORARY_KW,
    SyntaxKind::TEXT_KW,
    SyntaxKind::THEN_KW,
    SyntaxKind::TIES_KW,
    SyntaxKind::TIME_KW,
    SyntaxKind::TIMESTAMP_KW,
    SyntaxKind::TRAILING_KW,
    SyntaxKind::TRANSACTION_KW,
    SyntaxKind::TRANSFORM_KW,
    SyntaxKind::TREAT_KW,
    SyntaxKind::TRIGGER_KW,
    SyntaxKind::TRIM_KW,
    SyntaxKind::TRUE_KW,
    SyntaxKind::TRUNCATE_KW,
    SyntaxKind::TRUSTED_KW,
    SyntaxKind::TYPE_KW,
    SyntaxKind::TYPES_KW,
    SyntaxKind::UESCAPE_KW,
    SyntaxKind::UNBOUNDED_KW,
    SyntaxKind::UNCOMMITTED_KW,
    SyntaxKind::UNCONDITIONAL_KW,
    SyntaxKind::UNENCRYPTED_KW,
    SyntaxKind::UNIQUE_KW,
    SyntaxKind::UNKNOWN_KW,
    SyntaxKind::UNLISTEN_KW,
    SyntaxKind::UNLOGGED_KW,
    SyntaxKind::UNTIL_KW,
    SyntaxKind::UPDATE_KW,
    SyntaxKind::USER_KW,
    SyntaxKind::USING_KW,
    SyntaxKind::VACUUM_KW,
    SyntaxKind::VALID_KW,
    SyntaxKind::VALIDATE_KW,
    SyntaxKind::VALIDATOR_KW,
    SyntaxKind::VALUE_KW,
    SyntaxKind::VALUES_KW,
    SyntaxKind::VARCHAR_KW,
    SyntaxKind::VARIADIC_KW,
    SyntaxKind::VERBOSE_KW,
    SyntaxKind::VERSION_KW,
    SyntaxKind::VIEW_KW,
    SyntaxKind::VIEWS_KW,
    SyntaxKind::VIRTUAL_KW,
    SyntaxKind::VOLATILE_KW,
    SyntaxKind::WAIT_KW,
    SyntaxKind::WHEN_KW,
    SyntaxKind::WHITESPACE_KW,
    SyntaxKind::WORK_KW,
    SyntaxKind::WRAPPER_KW,
    SyntaxKind::WRITE_KW,
    SyntaxKind::XML_KW,
    SyntaxKind::XMLATTRIBUTES_KW,
    SyntaxKind::XMLCONCAT_KW,
    SyntaxKind::XMLELEMENT_KW,
    SyntaxKind::XMLEXISTS_KW,
    SyntaxKind::XMLFOREST_KW,
    SyntaxKind::XMLNAMESPACES_KW,
    SyntaxKind::XMLPARSE_KW,
    SyntaxKind::XMLPI_KW,
    SyntaxKind::XMLROOT_KW,
    SyntaxKind::XMLSERIALIZE_KW,
    SyntaxKind::XMLTABLE_KW,
    SyntaxKind::YES_KW,
    SyntaxKind::ZONE_KW,
]);

pub(crate) const UNRESERVED_KEYWORDS: TokenSet = TokenSet::new(&[
    SyntaxKind::ABORT_KW,
    SyntaxKind::ABSENT_KW,
    SyntaxKind::ABSOLUTE_KW,
    SyntaxKind::ACCESS_KW,
    SyntaxKind::ACTION_KW,
    SyntaxKind::ADD_KW,
    SyntaxKind::ADMIN_KW,
    SyntaxKind::AFTER_KW,
    SyntaxKind::AGGREGATE_KW,
    SyntaxKind::ALSO_KW,
    SyntaxKind::ALTER_KW,
    SyntaxKind::ALWAYS_KW,
    SyntaxKind::ASENSITIVE_KW,
    SyntaxKind::ASSERTION_KW,
    SyntaxKind::ASSIGNMENT_KW,
    SyntaxKind::AT_KW,
    SyntaxKind::ATOMIC_KW,
    SyntaxKind::ATTACH_KW,
    SyntaxKind::ATTRIBUTE_KW,
    SyntaxKind::BACKWARD_KW,
    SyntaxKind::BEFORE_KW,
    SyntaxKind::BEGIN_KW,
    SyntaxKind::BREADTH_KW,
    SyntaxKind::BY_KW,
    SyntaxKind::CACHE_KW,
    SyntaxKind::CALL_KW,
    SyntaxKind::CALLED_KW,
    SyntaxKind::CASCADE_KW,
    SyntaxKind::CASCADED_KW,
    SyntaxKind::CATALOG_KW,
    SyntaxKind::CHAIN_KW,
    SyntaxKind::CHARACTERISTICS_KW,
    SyntaxKind::CHECKPOINT_KW,
    SyntaxKind::CLASS_KW,
    SyntaxKind::CLOSE_KW,
    SyntaxKind::CLUSTER_KW,
    SyntaxKind::COLUMNS_KW,
    SyntaxKind::COMMENT_KW,
    SyntaxKind::COMMENTS_KW,
    SyntaxKind::COMMIT_KW,
    SyntaxKind::COMMITTED_KW,
    SyntaxKind::COMPRESSION_KW,
    SyntaxKind::CONDITIONAL_KW,
    SyntaxKind::CONFIGURATION_KW,
    SyntaxKind::CONFLICT_KW,
    SyntaxKind::CONNECTION_KW,
    SyntaxKind::CONSTRAINTS_KW,
    SyntaxKind::CONTENT_KW,
    SyntaxKind::CONTINUE_KW,
    SyntaxKind::CONVERSION_KW,
    SyntaxKind::COPY_KW,
    SyntaxKind::COST_KW,
    SyntaxKind::CSV_KW,
    SyntaxKind::CUBE_KW,
    SyntaxKind::CURRENT_KW,
    SyntaxKind::CURSOR_KW,
    SyntaxKind::CYCLE_KW,
    SyntaxKind::DATA_KW,
    SyntaxKind::DATABASE_KW,
    SyntaxKind::DAY_KW,
    SyntaxKind::DEALLOCATE_KW,
    SyntaxKind::DECLARE_KW,
    SyntaxKind::DEFAULTS_KW,
    SyntaxKind::DEFERRED_KW,
    SyntaxKind::DEFINER_KW,
    SyntaxKind::DELETE_KW,
    SyntaxKind::DELIMITER_KW,
    SyntaxKind::DELIMITERS_KW,
    SyntaxKind::DEPENDS_KW,
    SyntaxKind::DEPTH_KW,
    SyntaxKind::DETACH_KW,
    SyntaxKind::DICTIONARY_KW,
    SyntaxKind::DISABLE_KW,
    SyntaxKind::DISCARD_KW,
    SyntaxKind::DOCUMENT_KW,
    SyntaxKind::DOMAIN_KW,
    SyntaxKind::DOUBLE_KW,
    SyntaxKind::DROP_KW,
    SyntaxKind::EACH_KW,
    SyntaxKind::EMPTY_KW,
    SyntaxKind::ENABLE_KW,
    SyntaxKind::ENCODING_KW,
    SyntaxKind::ENCRYPTED_KW,
    SyntaxKind::ENFORCED_KW,
    SyntaxKind::ENUM_KW,
    SyntaxKind::ERROR_KW,
    SyntaxKind::ESCAPE_KW,
    SyntaxKind::EVENT_KW,
    SyntaxKind::EXCLUDE_KW,
    SyntaxKind::EXCLUDING_KW,
    SyntaxKind::EXCLUSIVE_KW,
    SyntaxKind::EXECUTE_KW,
    SyntaxKind::EXPLAIN_KW,
    SyntaxKind::EXPRESSION_KW,
    SyntaxKind::EXTENSION_KW,
    SyntaxKind::EXTERNAL_KW,
    SyntaxKind::FAMILY_KW,
    SyntaxKind::FILTER_KW,
    SyntaxKind::FINALIZE_KW,
    SyntaxKind::FIRST_KW,
    SyntaxKind::FOLLOWING_KW,
    SyntaxKind::FORCE_KW,
    SyntaxKind::FORMAT_KW,
    SyntaxKind::FORWARD_KW,
    SyntaxKind::FUNCTION_KW,
    SyntaxKind::FUNCTIONS_KW,
    SyntaxKind::GENERATED_KW,
    SyntaxKind::GLOBAL_KW,
    SyntaxKind::GRANTED_KW,
    SyntaxKind::GROUPS_KW,
    SyntaxKind::HANDLER_KW,
    SyntaxKind::HEADER_KW,
    SyntaxKind::HOLD_KW,
    SyntaxKind::HOUR_KW,
    SyntaxKind::IDENTITY_KW,
    SyntaxKind::IF_KW,
    SyntaxKind::IGNORE_KW,
    SyntaxKind::IMMEDIATE_KW,
    SyntaxKind::IMMUTABLE_KW,
    SyntaxKind::IMPLICIT_KW,
    SyntaxKind::IMPORT_KW,
    SyntaxKind::INCLUDE_KW,
    SyntaxKind::INCLUDING_KW,
    SyntaxKind::INCREMENT_KW,
    SyntaxKind::INDENT_KW,
    SyntaxKind::INDEX_KW,
    SyntaxKind::INDEXES_KW,
    SyntaxKind::INHERIT_KW,
    SyntaxKind::INHERITS_KW,
    SyntaxKind::INLINE_KW,
    SyntaxKind::INPUT_KW,
    SyntaxKind::INSENSITIVE_KW,
    SyntaxKind::INSERT_KW,
    SyntaxKind::INSTEAD_KW,
    SyntaxKind::INVOKER_KW,
    SyntaxKind::ISOLATION_KW,
    SyntaxKind::KEEP_KW,
    SyntaxKind::KEY_KW,
    SyntaxKind::KEYS_KW,
    SyntaxKind::LABEL_KW,
    SyntaxKind::LANGUAGE_KW,
    SyntaxKind::LARGE_KW,
    SyntaxKind::LAST_KW,
    SyntaxKind::LEAKPROOF_KW,
    SyntaxKind::LEVEL_KW,
    SyntaxKind::LISTEN_KW,
    SyntaxKind::LOAD_KW,
    SyntaxKind::LOCAL_KW,
    SyntaxKind::LOCATION_KW,
    SyntaxKind::LOCK_KW,
    SyntaxKind::LOCKED_KW,
    SyntaxKind::LOGGED_KW,
    SyntaxKind::LSN_KW,
    SyntaxKind::MAPPING_KW,
    SyntaxKind::MATCH_KW,
    SyntaxKind::MATCHED_KW,
    SyntaxKind::MATERIALIZED_KW,
    SyntaxKind::MAXVALUE_KW,
    SyntaxKind::MERGE_KW,
    SyntaxKind::METHOD_KW,
    SyntaxKind::MINUTE_KW,
    SyntaxKind::MINVALUE_KW,
    SyntaxKind::MODE_KW,
    SyntaxKind::MONTH_KW,
    SyntaxKind::MOVE_KW,
    SyntaxKind::NAME_KW,
    SyntaxKind::NAMES_KW,
    SyntaxKind::NESTED_KW,
    SyntaxKind::NEW_KW,
    SyntaxKind::NEXT_KW,
    SyntaxKind::NFC_KW,
    SyntaxKind::NFD_KW,
    SyntaxKind::NFKC_KW,
    SyntaxKind::NFKD_KW,
    SyntaxKind::NO_KW,
    SyntaxKind::NORMALIZED_KW,
    SyntaxKind::NOTHING_KW,
    SyntaxKind::NOTIFY_KW,
    SyntaxKind::NOWAIT_KW,
    SyntaxKind::NULLS_KW,
    SyntaxKind::OBJECT_KW,
    SyntaxKind::OBJECTS_KW,
    SyntaxKind::OF_KW,
    SyntaxKind::OFF_KW,
    SyntaxKind::OIDS_KW,
    SyntaxKind::OLD_KW,
    SyntaxKind::OMIT_KW,
    SyntaxKind::OPERATOR_KW,
    SyntaxKind::OPTION_KW,
    SyntaxKind::OPTIONS_KW,
    SyntaxKind::ORDINALITY_KW,
    SyntaxKind::OTHERS_KW,
    SyntaxKind::OVER_KW,
    SyntaxKind::OVERRIDING_KW,
    SyntaxKind::OWNED_KW,
    SyntaxKind::OWNER_KW,
    SyntaxKind::PARALLEL_KW,
    SyntaxKind::PARAMETER_KW,
    SyntaxKind::PARSER_KW,
    SyntaxKind::PARTIAL_KW,
    SyntaxKind::PARTITION_KW,
    SyntaxKind::PARTITIONS_KW,
    SyntaxKind::PASSING_KW,
    SyntaxKind::PASSWORD_KW,
    SyntaxKind::PATH_KW,
    SyntaxKind::PERIOD_KW,
    SyntaxKind::PLAN_KW,
    SyntaxKind::PLANS_KW,
    SyntaxKind::POLICY_KW,
    SyntaxKind::PRECEDING_KW,
    SyntaxKind::PREPARE_KW,
    SyntaxKind::PREPARED_KW,
    SyntaxKind::PRESERVE_KW,
    SyntaxKind::PRIOR_KW,
    SyntaxKind::PRIVILEGES_KW,
    SyntaxKind::PROCEDURAL_KW,
    SyntaxKind::PROCEDURE_KW,
    SyntaxKind::PROCEDURES_KW,
    SyntaxKind::PROGRAM_KW,
    SyntaxKind::PUBLICATION_KW,
    SyntaxKind::QUOTE_KW,
    SyntaxKind::QUOTES_KW,
    SyntaxKind::RANGE_KW,
    SyntaxKind::READ_KW,
    SyntaxKind::REASSIGN_KW,
    SyntaxKind::RECURSIVE_KW,
    SyntaxKind::REF_KW,
    SyntaxKind::REFERENCING_KW,
    SyntaxKind::REFRESH_KW,
    SyntaxKind::REINDEX_KW,
    SyntaxKind::RELATIVE_KW,
    SyntaxKind::RELEASE_KW,
    SyntaxKind::RENAME_KW,
    SyntaxKind::REPEATABLE_KW,
    SyntaxKind::REPLACE_KW,
    SyntaxKind::REPLICA_KW,
    SyntaxKind::RESET_KW,
    SyntaxKind::RESPECT_KW,
    SyntaxKind::RESTART_KW,
    SyntaxKind::RESTRICT_KW,
    SyntaxKind::RETURN_KW,
    SyntaxKind::RETURNS_KW,
    SyntaxKind::REVOKE_KW,
    SyntaxKind::ROLE_KW,
    SyntaxKind::ROLLBACK_KW,
    SyntaxKind::ROLLUP_KW,
    SyntaxKind::ROUTINE_KW,
    SyntaxKind::ROUTINES_KW,
    SyntaxKind::ROWS_KW,
    SyntaxKind::RULE_KW,
    SyntaxKind::SAVEPOINT_KW,
    SyntaxKind::SCALAR_KW,
    SyntaxKind::SCHEMA_KW,
    SyntaxKind::SCHEMAS_KW,
    SyntaxKind::SCROLL_KW,
    SyntaxKind::SEARCH_KW,
    SyntaxKind::SECOND_KW,
    SyntaxKind::SECURITY_KW,
    SyntaxKind::SEQUENCE_KW,
    SyntaxKind::SEQUENCES_KW,
    SyntaxKind::SERIALIZABLE_KW,
    SyntaxKind::SERVER_KW,
    SyntaxKind::SESSION_KW,
    SyntaxKind::SET_KW,
    SyntaxKind::SETS_KW,
    SyntaxKind::SHARE_KW,
    SyntaxKind::SHOW_KW,
    SyntaxKind::SIMPLE_KW,
    SyntaxKind::SKIP_KW,
    SyntaxKind::SNAPSHOT_KW,
    SyntaxKind::SOURCE_KW,
    SyntaxKind::SPLIT_KW,
    SyntaxKind::SQL_KW,
    SyntaxKind::STABLE_KW,
    SyntaxKind::STANDALONE_KW,
    SyntaxKind::START_KW,
    SyntaxKind::STATEMENT_KW,
    SyntaxKind::STATISTICS_KW,
    SyntaxKind::STDIN_KW,
    SyntaxKind::STDOUT_KW,
    SyntaxKind::STORAGE_KW,
    SyntaxKind::STORED_KW,
    SyntaxKind::STRICT_KW,
    SyntaxKind::STRING_KW,
    SyntaxKind::STRIP_KW,
    SyntaxKind::SUBSCRIPTION_KW,
    SyntaxKind::SUPPORT_KW,
    SyntaxKind::SYSID_KW,
    SyntaxKind::SYSTEM_KW,
    SyntaxKind::TABLES_KW,
    SyntaxKind::TABLESPACE_KW,
    SyntaxKind::TARGET_KW,
    SyntaxKind::TEMP_KW,
    SyntaxKind::TEMPLATE_KW,
    SyntaxKind::TEMPORARY_KW,
    SyntaxKind::TEXT_KW,
    SyntaxKind::TIES_KW,
    SyntaxKind::TRANSACTION_KW,
    SyntaxKind::TRANSFORM_KW,
    SyntaxKind::TRIGGER_KW,
    SyntaxKind::TRUNCATE_KW,
    SyntaxKind::TRUSTED_KW,
    SyntaxKind::TYPE_KW,
    SyntaxKind::TYPES_KW,
    SyntaxKind::UESCAPE_KW,
    SyntaxKind::UNBOUNDED_KW,
    SyntaxKind::UNCOMMITTED_KW,
    SyntaxKind::UNCONDITIONAL_KW,
    SyntaxKind::UNENCRYPTED_KW,
    SyntaxKind::UNKNOWN_KW,
    SyntaxKind::UNLISTEN_KW,
    SyntaxKind::UNLOGGED_KW,
    SyntaxKind::UNTIL_KW,
    SyntaxKind::UPDATE_KW,
    SyntaxKind::VACUUM_KW,
    SyntaxKind::VALID_KW,
    SyntaxKind::VALIDATE_KW,
    SyntaxKind::VALIDATOR_KW,
    SyntaxKind::VALUE_KW,
    SyntaxKind::VARYING_KW,
    SyntaxKind::VERSION_KW,
    SyntaxKind::VIEW_KW,
    SyntaxKind::VIEWS_KW,
    SyntaxKind::VIRTUAL_KW,
    SyntaxKind::VOLATILE_KW,
    SyntaxKind::WAIT_KW,
    SyntaxKind::WHITESPACE_KW,
    SyntaxKind::WITHIN_KW,
    SyntaxKind::WITHOUT_KW,
    SyntaxKind::WORK_KW,
    SyntaxKind::WRAPPER_KW,
    SyntaxKind::WRITE_KW,
    SyntaxKind::XML_KW,
    SyntaxKind::YEAR_KW,
    SyntaxKind::YES_KW,
    SyntaxKind::ZONE_KW,
]);

pub(crate) const RESERVED_KEYWORDS: TokenSet = TokenSet::new(&[
    SyntaxKind::ALL_KW,
    SyntaxKind::ANALYSE_KW,
    SyntaxKind::ANALYZE_KW,
    SyntaxKind::AND_KW,
    SyntaxKind::ANY_KW,
    SyntaxKind::ARRAY_KW,
    SyntaxKind::AS_KW,
    SyntaxKind::ASC_KW,
    SyntaxKind::ASYMMETRIC_KW,
    SyntaxKind::BOTH_KW,
    SyntaxKind::CASE_KW,
    SyntaxKind::CAST_KW,
    SyntaxKind::CHECK_KW,
    SyntaxKind::COLLATE_KW,
    SyntaxKind::COLUMN_KW,
    SyntaxKind::CONSTRAINT_KW,
    SyntaxKind::CREATE_KW,
    SyntaxKind::CURRENT_CATALOG_KW,
    SyntaxKind::CURRENT_DATE_KW,
    SyntaxKind::CURRENT_ROLE_KW,
    SyntaxKind::CURRENT_TIME_KW,
    SyntaxKind::CURRENT_TIMESTAMP_KW,
    SyntaxKind::CURRENT_USER_KW,
    SyntaxKind::DEFAULT_KW,
    SyntaxKind::DEFERRABLE_KW,
    SyntaxKind::DESC_KW,
    SyntaxKind::DISTINCT_KW,
    SyntaxKind::DO_KW,
    SyntaxKind::ELSE_KW,
    SyntaxKind::END_KW,
    SyntaxKind::EXCEPT_KW,
    SyntaxKind::FALSE_KW,
    SyntaxKind::FETCH_KW,
    SyntaxKind::FOR_KW,
    SyntaxKind::FOREIGN_KW,
    SyntaxKind::FROM_KW,
    SyntaxKind::GRANT_KW,
    SyntaxKind::GROUP_KW,
    SyntaxKind::HAVING_KW,
    SyntaxKind::IN_KW,
    SyntaxKind::INITIALLY_KW,
    SyntaxKind::INTERSECT_KW,
    SyntaxKind::INTO_KW,
    SyntaxKind::LATERAL_KW,
    SyntaxKind::LEADING_KW,
    SyntaxKind::LIMIT_KW,
    SyntaxKind::LOCALTIME_KW,
    SyntaxKind::LOCALTIMESTAMP_KW,
    SyntaxKind::NOT_KW,
    SyntaxKind::NULL_KW,
    SyntaxKind::OFFSET_KW,
    SyntaxKind::ON_KW,
    SyntaxKind::ONLY_KW,
    SyntaxKind::OR_KW,
    SyntaxKind::ORDER_KW,
    SyntaxKind::PLACING_KW,
    SyntaxKind::PRIMARY_KW,
    SyntaxKind::REFERENCES_KW,
    SyntaxKind::RETURNING_KW,
    SyntaxKind::SELECT_KW,
    SyntaxKind::SESSION_USER_KW,
    SyntaxKind::SOME_KW,
    SyntaxKind::SYMMETRIC_KW,
    SyntaxKind::SYSTEM_USER_KW,
    SyntaxKind::TABLE_KW,
    SyntaxKind::THEN_KW,
    SyntaxKind::TO_KW,
    SyntaxKind::TRAILING_KW,
    SyntaxKind::TRUE_KW,
    SyntaxKind::UNION_KW,
    SyntaxKind::UNIQUE_KW,
    SyntaxKind::USER_KW,
    SyntaxKind::USING_KW,
    SyntaxKind::VARIADIC_KW,
    SyntaxKind::WHEN_KW,
    SyntaxKind::WHERE_KW,
    SyntaxKind::WINDOW_KW,
    SyntaxKind::WITH_KW,
]);
