-- add column
alter table products add column description text;

-- change column data type
alter table products alter column price type numeric(10, 2);


-- alter_constraint
alter table t alter constraint c;
alter table t alter constraint c deferrable;
alter table t alter constraint c not deferrable;
alter table t alter constraint c not deferrable initially immediate;


-- validate_constraint
alter table t validate constraint foo;


-- change column default
alter table products alter column price set default 7.77;

-- remove column default
alter table products alter column price drop default;


-- alter_column
alter table t alter c set data type int collate "foo" using a > b;
alter table t alter c type int;

alter table t alter c set default 10 * b;
alter table t alter c drop default;

alter table t alter c set not null;
alter table t alter c drop not null;

alter table t alter c drop expression;
alter table t alter c drop expression if exists;

alter table t alter c add generated by default as identity;
alter table t alter c add generated always as identity;
alter table t alter c add generated always as identity ( sequence name foo cycle );

alter table t alter c set generated always set sequence name bar restart 10; 
alter table t alter c set generated always set sequence name bar restart with 10; 

alter table t alter c drop identity;
alter table t alter c drop identity if exists;

alter table t alter c set statistics 10;

alter table t alter c set ( foo = bar, buzz = b );
alter table t alter c reset ( foo, buzz, b );
alter table t alter c reset ( p.foo, buzz, b );
alter table t alter c set ( b = a.b, z = 'foo', w = 10, json = constraint );

alter table t alter c set storage plain;
alter table t alter c set storage external;
alter table t alter c set storage extended;
alter table t alter c set storage main;
alter table t alter c set storage default;

alter table t alter c set compression default;
alter table t alter c set compression foo;

alter table t alter c restart;

-- inherit
alter table t inherit t1;
alter table t no inherit t1;

-- remove constraint
alter table products drop constraint some_name;

-- remove column not null constraint
alter table products alter column product_no drop not null;

-- remove constraint if exists
alter table products drop constraint if exists some_name;

alter table t drop constraint if exists c restrict;
alter table t drop constraint if exists c cascade;


-- disable_trigger
alter table t disable trigger foo;
alter table t disable trigger all;
alter table t disable trigger user;

-- enable_trigger
alter table t enable trigger foo;
alter table t enable trigger all;
alter table t enable trigger user;

alter table t enable replica trigger c;
alter table t enable always trigger c;


-- replica_identity
alter table t replica identity default;
alter table t replica identity using index i;
alter table t replica identity full;
alter table t replica identity nothing;

-- rule_enable_disable
alter table t disable rule r;
alter table t enable rule r;

alter table t enable replica rule r;
alter table t enable always rule r;


-- row_level_security
alter table t disable row level security;
alter table t enable row level security;
alter table t force row level security;
alter table t no force row level security;


-- cluster
alter table t cluster on i;
alter table t set without cluster;
alter table t set without oids;

-- access_method
alter table t set access method foo;

alter table t set logged;
alter table t set unlogged;

-- of_type
alter table t of int8;
alter table t not of;

-- column constraint
alter table products add column description text check (description <> '');

-- add column not null constraint
alter table products alter column product_no set not null;

-- multi constraints
alter table products add column description text check (description <> '') not null;

alter table t alter c type timestamptz using c at time zone 'UTC';

-- remove_column
-- remove column
alter table products drop column description;

-- remove column cascade
alter table products drop column description cascade;

-- remove column restrict
alter table t drop column c restrict;

-- remove column concise
alter table products drop description;

-- remove column if exists
alter table products drop column if exists description;


-- add table_constraint
alter table products add check (name <> '');
alter table products add constraint some_name unique (product_no);
alter table products add unique nulls not distinct (a, b, c) with (foo = false, a = true);
alter table products add primary key (a, b);

alter table t add primary key (a)
  include (a, b)
  with (a = 1) 
  using index tablespace foo;

alter table t add exclude (
  a with =,
  tsrange(b, c) with &&
);
alter table t add exclude using gist (
  a with =,
  tsrange(b, c) with &&
) WHERE (d = 'active');

alter table t add foreign key (a, b) references t1;
alter table t add foreign key (a, b) references t1 match full;
alter table t add foreign key (a, b) references t1 match simple;
alter table t add foreign key (a, b) references t1(e, f) match full on delete no action on update set null;

alter table t add foreign key (a) references t1 on delete no action;
alter table t add foreign key (a) references t1 on delete restrict;
alter table t add foreign key (a) references t1 on delete cascade;
alter table t add foreign key (a) references t1 on delete set null;
alter table t add foreign key (a) references t1 on delete set null (a, b);
alter table t add foreign key (a) references t1 on delete set default;
alter table t add foreign key (a) references t1 on delete set default (a, b);

alter table products add foreign key (product_group_id) references product_groups;

-- table_constraint_using_index
alter table t add unique using index foo;
alter table t add primary key using index foo;

alter table t add constraint c unique using index foo;
alter table t add constraint c primary key using index foo;

-- not valid check
alter table t add constraint foo_not_null
  check ("foo" is not null) not valid;


-- rename column
alter table products rename column product_no to product_number;

alter table if exists only t
rename column c to d;

alter table t * 
rename column c to d;

-- rename table
alter table products rename to items;

alter table only (a) rename to b;

-- rename constraint
alter table t rename constraint a to b;

-- set_schema
alter table t set schema foo;

-- set tablespace
alter table all in tablespace foo set tablespace bar;

-- set tablespace all
alter table all in tablespace foo owned by a, b, c 
set tablespace bar nowait;

-- set tablespace owned by
alter table all in tablespace foo owned by bar
set tablespace buz;

alter table t set tablespace foo;

-- alter_table_owner
alter table table_name owner to new_owner;

-- default
alter table t attach partition f default;

-- partition spec
alter table t attach partition f for values in ('bar', 'buzz');

-- multiple_actions
alter table t not of, not of, set logged, set unlogged;

-- from pg docs
ALTER TABLE transactions
  ADD COLUMN status varchar(30) DEFAULT 'old',
  ALTER COLUMN status SET default 'current';

-- simple
alter table t detach partition f;

-- concurrently
alter table t detach partition f concurrently;

-- finalize
alter table t detach partition f finalize;
