# Template and Dependency Update

## Template update

To update the project template, thanks to the [update feature](https://copier.readthedocs.io/en/stable/updating/) provided by [Copier](https://github.com/copier-org/copier) and the [regex manager](https://docs.renovatebot.com/modules/manager/regex/) provided by Renovate, a pull request will be automatically created when a new version of the template is released. In most cases, Copier will update the project seamlessly. If conflicts arise, they can be resolved manually since everything is version-controlled by Git.

### Tips to minimize potential conflicts

To minimize potential conflicts, consider the following suggestions:

1. Avoid modifying the auto-generated files unless necessary.
1. For template-related changes, consider proposing an issue or a pull request to the [project template repository](http://github.com/serious-scaffold/ss-python) directly.
1. For project-specific changes, adopt an inheritance or extension approach to minimize modifications to auto-generated content.

## Dependency update

With the integration of [Renovate](https://github.com/renovatebot/renovate), all dependencies, including those used for development and CI/CD, will be automatically updated via pull requests whenever a new version is released. This allows us to focus solely on testing to ensure the new versions do not break anything. Moreover, an issue titled "Dependency Dashboard" will be created, so that you can have an overview of the state of all dependencies.

### Managed dependency types

The project template tracks the following dependencies:

1. Supported managers other than `regex`:
   1. [pep621](https://docs.renovatebot.com/modules/manager/pep621/): The lock file generated by PDM for both dependencies and development dependencies in `pyproject.toml`.
   1. [github-actions](https://docs.renovatebot.com/modules/manager/github-actions/): Actions, runners and containers in GitHub Actions.
   1. [gitlabci](https://docs.renovatebot.com/modules/manager/gitlabci/): Containers in GitLab CI/CD.
   1. [pre-commit](https://docs.renovatebot.com/modules/manager/pre-commit/): Pre-commit hooks.
1. Regex manager:
   1. Python packages installed with pip/pipx, listed in the README, DevContainer Dockerfile, GitHub Actions, GitLab CI/CD, ReadTheDocs configuration, Renovate configuration and documentation.
   1. Debian packages installed in the DevContainer Dockerfile.
   1. PDM version specified in the `pdm-project/setup-pdm` GitHub action.
   1. PDM version specified in the renovate constraints.
   1. NPM packages used with npx.
   1. The project template itself.

### Add new dependencies

When adding new dependencies that belong to the managed dependency type mentioned above, it is recommended to pin or lock their versions to ensure they are smoothly managed by Renovate.

When adding new types of dependencies, it is also recommended to manage them with Renovate.

- If this follows a common pattern, consider creating an issue or even sending a pull request to project template directly.
- If it is project-specific, you can extend the renovate configuration:
  - For supported managers other than `regex`, add them in the Renovate configuration using environment variable `RENOVATE_ENABLED_MANAGERS` in GitHub Actions or GitLab CI/CD and configure them in the `renovaterc.json` under the root directory if needed.
  - For `regex` managers, add new entries in the `customManagers` and configure `packageRules` if needed in the `.renovaterc.json`.

  ```{note}
  This also adheres to the <project:#tips-to-minimize-potential-conflicts>.
  ```

```{note}
For the complete list of supported managers and their corresponding configurations, please refer to the [Managers - Renovate Docs](https://docs.renovatebot.com/modules/manager/).
```
