# This file is part of ssh2-python.
# Copyright (C) 2017-2020 Panos Kittenis
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation, version 2.1.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

cdef extern from "libssh2.h" nogil:
    # Error Codes (defined by libssh2)
    # The library once used -1 as a generic error return value on numerous
    # places through the code, which subsequently was converted to
    # LIBSSH2_ERROR_SOCKET_NONE uses over time. As this is a generic error code,
    # the goal is to never ever return this code but instead make sure that a
    # more accurate and descriptive error code is used.
    enum:
        _LIBSSH2_ERROR_NONE "LIBSSH2_ERROR_NONE"
        _LIBSSH2_ERROR_SOCKET_NONE "LIBSSH2_ERROR_SOCKET_NONE"
        _LIBSSH2_ERROR_BANNER_RECV "LIBSSH2_ERROR_BANNER_RECV"
        _LIBSSH2_ERROR_BANNER_SEND "LIBSSH2_ERROR_BANNER_SEND"
        _LIBSSH2_ERROR_KEY_EXCHANGE_FAILURE "LIBSSH2_ERROR_KEY_EXCHANGE_FAILURE"
        _LIBSSH2_ERROR_TIMEOUT "LIBSSH2_ERROR_TIMEOUT"
        _LIBSSH2_ERROR_HOSTKEY_INIT "LIBSSH2_ERROR_HOSTKEY_INIT"
        _LIBSSH2_ERROR_HOSTKEY_SIGN "LIBSSH2_ERROR_HOSTKEY_SIGN"
        _LIBSSH2_ERROR_DECRYPT "LIBSSH2_ERROR_DECRYPT"
        _LIBSSH2_ERROR_SOCKET_DISCONNECT "LIBSSH2_ERROR_SOCKET_DISCONNECT"
        _LIBSSH2_ERROR_PROTO "LIBSSH2_ERROR_PROTO"
        _LIBSSH2_ERROR_PASSWORD_EXPIRED "LIBSSH2_ERROR_PASSWORD_EXPIRED"
        _LIBSSH2_ERROR_FILE "LIBSSH2_ERROR_FILE"
        _LIBSSH2_ERROR_METHOD_NONE "LIBSSH2_ERROR_METHOD_NONE"
        _LIBSSH2_ERROR_AUTHENTICATION_FAILED \
            "LIBSSH2_ERROR_AUTHENTICATION_FAILED"
        _LIBSSH2_ERROR_PUBLICKEY_UNRECOGNIZED \
            "LIBSSH2_ERROR_AUTHENTICATION_FAILED"
        _LIBSSH2_ERROR_PUBLICKEY_UNVERIFIED "LIBSSH2_ERROR_PUBLICKEY_UNVERIFIED"
        _LIBSSH2_ERROR_CHANNEL_OUTOFORDER "LIBSSH2_ERROR_CHANNEL_OUTOFORDER"
        _LIBSSH2_ERROR_CHANNEL_FAILURE "LIBSSH2_ERROR_CHANNEL_FAILURE"
        _LIBSSH2_ERROR_CHANNEL_REQUEST_DENIED \
            "LIBSSH2_ERROR_CHANNEL_REQUEST_DENIED"
        _LIBSSH2_ERROR_CHANNEL_UNKNOWN "LIBSSH2_ERROR_CHANNEL_UNKNOWN"
        _LIBSSH2_ERROR_CHANNEL_WINDOW_EXCEEDED \
            "LIBSSH2_ERROR_CHANNEL_WINDOW_EXCEEDED"
        _LIBSSH2_ERROR_CHANNEL_PACKET_EXCEEDED \
            "LIBSSH2_ERROR_CHANNEL_PACKET_EXCEEDED"
        _LIBSSH2_ERROR_CHANNEL_CLOSED "LIBSSH2_ERROR_CHANNEL_CLOSED"
        _LIBSSH2_ERROR_CHANNEL_EOF_SENT "LIBSSH2_ERROR_CHANNEL_EOF_SENT"
        _LIBSSH2_ERROR_SCP_PROTOCOL "LIBSSH2_ERROR_SCP_PROTOCOL"
        _LIBSSH2_ERROR_ZLIB "LIBSSH2_ERROR_ZLIB"
        _LIBSSH2_ERROR_SOCKET_TIMEOUT "LIBSSH2_ERROR_SOCKET_TIMEOUT"
        _LIBSSH2_ERROR_SFTP_PROTOCOL "LIBSSH2_ERROR_SFTP_PROTOCOL"
        _LIBSSH2_ERROR_REQUEST_DENIED "LIBSSH2_ERROR_REQUEST_DENIED"
        _LIBSSH2_ERROR_METHOD_NOT_SUPPORTED "LIBSSH2_ERROR_METHOD_NOT_SUPPORTED"
        _LIBSSH2_ERROR_INVAL "LIBSSH2_ERROR_INVAL"
        _LIBSSH2_ERROR_INVALID_POLL_TYPE "LIBSSH2_ERROR_INVALID_POLL_TYPE"
        _LIBSSH2_ERROR_PUBLICKEY_PROTOCOL "LIBSSH2_ERROR_PUBLICKEY_PROTOCOL"
        _LIBSSH2_ERROR_EAGAIN "LIBSSH2_ERROR_EAGAIN"
        _LIBSSH2CHANNEL_EAGAIN "LIBSSH2_ERROR_EAGAIN"
        _LIBSSH2_ERROR_BUFFER_TOO_SMALL "LIBSSH2_ERROR_BUFFER_TOO_SMALL"
        _LIBSSH2_ERROR_BAD_USE "LIBSSH2_ERROR_BAD_USE"
        _LIBSSH2_ERROR_COMPRESS "LIBSSH2_ERROR_COMPRESS"
        _LIBSSH2_ERROR_OUT_OF_BOUNDARY "LIBSSH2_ERROR_OUT_OF_BOUNDARY"
        _LIBSSH2_ERROR_AGENT_PROTOCOL "LIBSSH2_ERROR_AGENT_PROTOCOL"
        _LIBSSH2_ERROR_SOCKET_RECV "LIBSSH2_ERROR_SOCKET_RECV"
        _LIBSSH2_ERROR_SOCKET_SEND "LIBSSH2_ERROR_SOCKET_SEND"
        _LIBSSH2_ERROR_ENCRYPT "LIBSSH2_ERROR_ENCRYPT"
        _LIBSSH2_ERROR_BAD_SOCKET "LIBSSH2_ERROR_BAD_SOCKET"
        _LIBSSH2_ERROR_KNOWN_HOSTS "LIBSSH2_ERROR_KNOWN_HOSTS"
