# This file is part of ssh2-python.
# Copyright (C) 2017 Panos Kittenis

# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation, version 2.1.

# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA


cdef class AgentError(Exception):
    pass


cdef class AuthenticationError(Exception):
    pass


cdef class AgentConnectionError(AgentError):
    pass


cdef class AgentAuthenticationError(AuthenticationError):
    pass


cdef class AgentListIdentitiesError(AgentError):
    pass


cdef class AgentGetIdentityError(AgentError):
    pass


cdef class SessionStartupError(Exception):
    pass


cdef class SessionHandshakeError(Exception):
    pass


cdef class ChannelError(Exception):
    pass


cdef class SFTPHandleError(Exception):
    pass


cdef class SFTPBufferTooSmall(Exception):
    pass
