# from stackcore import matrix
# from stackcore import point_manipulation as pm
import sys
import os
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..', 'src')))

import stackcore.matrix as matrix
import stackcore.point_manipulation as pm
import numpy as np

#Matrix Tests
def test_norm():
    points=[
        [[0.737, 0.068, 0.382], [0.828, 0.198, 0.795], [0.508, 0.019, 0.736], [0.45606074, -0.87272887,  0.17422089]], 
        [[0.282, 0.99,  0.154], [0.812, 0.667, 0.875], [0.96,  0.07,  0.744], [0.82714061,  0.30817746, -0.46996284]], 
        [[0.763, 0.501, 0.537], [0.789, 0.956, 0.461], [0.154, 0.718, 0.085], [-0.54815667,  0.16817231,  0.81929381]]
    ]
    for p in points:
        p1, p2, p3, norm = np.array(p)
        assert(np.allclose(matrix.get_normal(p1, p2, p3), norm))

def test_transform():
    planes=[
        [np.array([[0.741, 0.871, 0.868],[0.691, 0.318, 0.644],[0.773, 0.468, 0.716]]),
         np.array([[0.941, 0.199, 0.922],[0.611, 0.325, 0.717],[0.17 , 0.686, 0.38 ]]),
         np.array([[ 0.56160938,  0.41335346,  0.71675227, -0.45732439],[ 0.80501752, -0.47311606, -0.35792175,  0.32524218],
                   [ 0.19115882,  0.77801035, -0.5984632 ,  0.62217036],[ 0.        ,  0.        ,  0.        ,  1.        ]])],
        [np.array([[0.922, 0.876, 0.744],[0.074, 0.435, 0.722],[0.882, 0.118, 0.469]]),
         np.array([[0.445, 0.565, 0.329],[0.438, 0.163, 0.163],[0.984, 0.325, 0.605]]),
         np.array([[ 0.74810179,  0.22672787, -0.62364908,  0.02063145],[-0.24178151,  0.96834712,  0.0620126 , -0.1064869 ],
            [ 0.61796878,  0.10439508,  0.77924082, -0.91197247],[ 0.        ,  0.        ,  0.        ,  1.        ]])]
    ]
    for p in planes:
        a, b, t = p
        assert(np.allclose(matrix.get_transformation_matrix(a,b), t))


#Point Manipulation Tests
class TestPM:
    a = [[np.array([[0.945],[0.559],[0.958]]), 
          np.array([[0.483, 0.376, 0.682]]), 
          -0.11263178369233398, 
          4.782114577044938, 
          np.array([[0.84951509, 0.96671983, 1.0006489 ],[0.46351509, 0.58071983, 0.6146489 ],[0.86251509, 0.97971983, 1.0136489 ]]), 
          np.array([[0.88563602, 0.89878705, 0.86117757],[0.49963602, 0.51278705, 0.47517757],[0.89863602, 0.91178705, 0.87417757]])], 
         [np.array([[0.834],[0.147],[0.201]]), 
          np.array([[0.983, 0.894, 0.173]]), 
          -0.11328084882282252, 
          2.4267471355473647, 
          np.array([[0.88446183, 0.7967706 , 0.73965952],[0.19746183, 0.1097706 , 0.05265952],[0.25146183, 0.1637706 , 0.10665952]]), 
          np.array([[0.75089582, 0.75842   , 0.81937434],[0.06389582, 0.07142   , 0.13237434],[0.11789582, 0.12542   , 0.18637434]])]
        ]
    
    def test_axis(self):
        for m in self.a:
            p, ax, tol, angle, rad, disp = m
            assert(np.allclose(pm.point_around_axis(p, ax, tol, angle), rad))

    def test_displacement(self):
        for m in self.a:
            p, ax, tol, angle, rad, disp = m
            assert(np.allclose(pm.point_displacement(p, ax, tol), disp))