# Stackify

## Description

Simplify setting up dev environments.

## Install

```bash
bash -c "$(curl -fsSL https://raw.githubusercontent.com/davidjrice/stackify/main/init.sh)"
```

```bash
pip install stackify
stackify
```

## Features

- 💻 Supported Operating Systems
  - [x] MacOS 🍎
  - [x] Ubuntu 🐧
  - [ ] Debian 🐧

- 📦 System Package managers
  - [Homebrew](https://brew.sh/) (MacOS 🍎 only)
  - [apt](https://wiki.debian.org/Apt) (Ubuntu 🐧 only)

- 🛠️ Tools
  - [Ansible](https://www.ansible.com/)
  - [Git](https://git-scm.com/)

- 🖥️ Terminal
  - [Zsh](https://www.zsh.org/)
  - [Oh My Zsh](https://ohmyz.sh/)
  - [Powerlevel10k](https://github.com/romkatv/powerlevel10k)

- 👩‍💻 Languages, environments, and package managers
  - [Python](https://www.python.org/) 🐍
    - [pyenv](https://github.com/pyenv/pyenv)
    - [poetry](https://python-poetry.org/)
  - [Ruby](https://www.ruby-lang.org/en/) 💎
    - [rbenv](https://github.com/rbenv/rbenv)
    - [bundler](https://bundler.io/)
  - [Go](https://golang.org/) 🦦
    - [go-env](https://github.com/Netflix/go-env)
  - [Node.js](https://nodejs.org/en/) 🟩
    - [nvm](https://github.com/nodenv/nodenv)

- 🧰 IDEs
  - [Visual Studio Code](https://code.visualstudio.com/)
  - [JetBrains](https://www.jetbrains.com/)
    - [JetBrains Toolbox](https://www.jetbrains.com/toolbox-app/)
    - [DataGrip](https://www.jetbrains.com/datagrip/)
    - [PyCharm](https://www.jetbrains.com/pycharm/)
    - [RubyMine](https://www.jetbrains.com/ruby/)

- 💾 Databases
  - [PostgreSQL](https://www.postgresql.org/) 🐘
  - [MySQL](https://www.mysql.com/) 🐬
  - [Redis](https://redis.io/) 🔥

## TODO

- [ ] Zsh
- [ ] Oh My Zsh
- [ ] Powerlevel10k
- [x] Python
    - [x] pyenv
- [x] Ruby
    - [x] rbenv
- [ ] Go
- [ ] Node.js
- [ ] IDEs
