# coding: utf-8

"""
    STACKIT Membership API

    The Membership API is used to manage memberships, roles and permissions of STACKIT resources, like projects, folders, organizations and other resources.

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
import re
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated, Self

from stackit.authorization.models.member import Member
from stackit.authorization.models.zookie import Zookie


class MembersResponse(BaseModel):
    """
    MembersResponse
    """

    members: List[Member]
    resource_id: Annotated[str, Field(strict=True)] = Field(alias="resourceId")
    resource_type: Annotated[str, Field(strict=True)] = Field(alias="resourceType")
    written_at: Optional[Zookie] = Field(default=None, alias="writtenAt")
    __properties: ClassVar[List[str]] = ["members", "resourceId", "resourceType", "writtenAt"]

    @field_validator("resource_id")
    def resource_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([a-zA-Z0-9\/_|\-=+@.]{1,})$", value):
            raise ValueError(r"must validate the regular expression /^([a-zA-Z0-9\/_|\-=+@.]{1,})$/")
        return value

    @field_validator("resource_type")
    def resource_type_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z](?:-?[a-z]){1,63}$", value):
            raise ValueError(r"must validate the regular expression /^[a-z](?:-?[a-z]){1,63}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MembersResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item in self.members:
                if _item:
                    _items.append(_item.to_dict())
            _dict["members"] = _items
        # override the default output from pydantic by calling `to_dict()` of written_at
        if self.written_at:
            _dict["writtenAt"] = self.written_at.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MembersResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "members": (
                    [Member.from_dict(_item) for _item in obj["members"]] if obj.get("members") is not None else None
                ),
                "resourceId": obj.get("resourceId"),
                "resourceType": obj.get("resourceType"),
                "writtenAt": Zookie.from_dict(obj["writtenAt"]) if obj.get("writtenAt") is not None else None,
            }
        )
        return _obj
