# coding: utf-8

"""
    STACKIT Git API

    STACKIT Git management API.

    The version of the OpenAPI document: 1beta.0.4
    Contact: git@stackit.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated, Self


class Instance(BaseModel):
    """
    Describes a STACKIT Git instance.
    """  # noqa: E501

    acl: List[StrictStr] = Field(description="Restricted ACL for instance access.")
    consumed_disk: StrictStr = Field(description="How many bytes of disk space is consumed. Read Only.")
    consumed_object_storage: StrictStr = Field(description="How many bytes of Object Storage is consumed. Read Only.")
    created: datetime = Field(description="The date and time the creation of the STACKIT Git instance was triggered.")
    flavor: StrictStr = Field(description="Desired instance flavor. Must be one of the defined enum values")
    id: Annotated[str, Field(strict=True, max_length=36)] = Field(
        description="A auto generated unique id which identifies the STACKIT Git instances."
    )
    name: Annotated[str, Field(strict=True, max_length=32)] = Field(
        description="A user chosen name to distinguish multiple STACKIT Git instances."
    )
    state: Annotated[str, Field(strict=True, max_length=32)] = Field(
        description="The current state of the STACKIT Git instance."
    )
    url: Annotated[str, Field(strict=True, max_length=2048)] = Field(
        description="The URL for reaching the STACKIT Git instance."
    )
    version: Annotated[str, Field(strict=True, max_length=20)] = Field(
        description="The current version of STACKIT Git deployed to the instance."
    )
    __properties: ClassVar[List[str]] = [
        "acl",
        "consumed_disk",
        "consumed_object_storage",
        "created",
        "flavor",
        "id",
        "name",
        "state",
        "url",
        "version",
    ]

    @field_validator("created", mode="before")
    def created_change_year_zero_to_one(cls, value):
        """Workaround which prevents year 0 issue"""
        if isinstance(value, str):
            # Check for year "0000" at the beginning of the string
            # This assumes common date formats like YYYY-MM-DDTHH:MM:SS+00:00 or YYYY-MM-DDTHH:MM:SSZ
            if value.startswith("0000-01-01T") and re.match(
                r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\+\d{2}:\d{2}|Z)$", value
            ):
                # Workaround: Replace "0000" with "0001"
                return "0001" + value[4:]  # Take "0001" and append the rest of the string
        return value

    @field_validator("state")
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(["Creating", "WaitingForResources", "Updating", "Deleting", "Ready", "Error"]):
            raise ValueError(
                "must be one of enum values ('Creating', 'WaitingForResources', 'Updating', 'Deleting', 'Ready', 'Error')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Instance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Instance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "acl": obj.get("acl"),
                "consumed_disk": obj.get("consumed_disk"),
                "consumed_object_storage": obj.get("consumed_object_storage"),
                "created": obj.get("created"),
                "flavor": obj.get("flavor"),
                "id": obj.get("id"),
                "name": obj.get("name"),
                "state": obj.get("state"),
                "url": obj.get("url"),
                "version": obj.get("version"),
            }
        )
        return _obj
