# coding: utf-8

"""
    Application Load Balancer API

    ### DEPRECATED! This service, lb-application, is no longer maintained. Please use the alb service, version v2beta2 instead  This API offers an interface to provision and manage load balancing servers in your STACKIT project. It also has the possibility of pooling target servers for load balancing purposes.  For each application load balancer provided, two VMs are deployed in your OpenStack project subject to a fee.

    The version of the OpenAPI document: 1beta.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing_extensions import Self

from stackit.lbapplication.models.cookie_persistence import CookiePersistence
from stackit.lbapplication.models.header import Header
from stackit.lbapplication.models.query_parameters import QueryParameters


class Matcher(BaseModel):
    """
    Matcher
    """

    cookie_persistence: Optional[CookiePersistence] = Field(default=None, alias="cookiePersistence")
    headers: Optional[List[Header]] = Field(default=None, description="Headers for the matcher")
    path_prefix: Optional[StrictStr] = Field(
        default=None, description="Path prefix for the matcher", alias="pathPrefix"
    )
    query_parameters: Optional[List[QueryParameters]] = Field(
        default=None, description="Query Parameters for the matcher", alias="queryParameters"
    )
    target_pool: Optional[StrictStr] = Field(
        default=None, description="Reference target pool by target pool name.", alias="targetPool"
    )
    web_socket: Optional[StrictBool] = Field(
        default=None,
        description="If enabled, when client sends an HTTP request with and Upgrade header, indicating the desire to establish a Websocket connection,  if backend server supports WebSocket, it responds with HTTP 101 status code, switching protocols from HTTP to WebSocket. Hence the client and the server can exchange data in real-time using one long-lived TCP connection.",
        alias="webSocket",
    )
    __properties: ClassVar[List[str]] = [
        "cookiePersistence",
        "headers",
        "pathPrefix",
        "queryParameters",
        "targetPool",
        "webSocket",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Matcher from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cookie_persistence
        if self.cookie_persistence:
            _dict["cookiePersistence"] = self.cookie_persistence.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in headers (list)
        _items = []
        if self.headers:
            for _item in self.headers:
                if _item:
                    _items.append(_item.to_dict())
            _dict["headers"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in query_parameters (list)
        _items = []
        if self.query_parameters:
            for _item in self.query_parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict["queryParameters"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Matcher from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "cookiePersistence": (
                    CookiePersistence.from_dict(obj["cookiePersistence"])
                    if obj.get("cookiePersistence") is not None
                    else None
                ),
                "headers": (
                    [Header.from_dict(_item) for _item in obj["headers"]] if obj.get("headers") is not None else None
                ),
                "pathPrefix": obj.get("pathPrefix"),
                "queryParameters": (
                    [QueryParameters.from_dict(_item) for _item in obj["queryParameters"]]
                    if obj.get("queryParameters") is not None
                    else None
                ),
                "targetPool": obj.get("targetPool"),
                "webSocket": obj.get("webSocket"),
            }
        )
        return _obj
