# coding: utf-8

"""
    Application Load Balancer API

    ### DEPRECATED! This service, lb-application, is no longer maintained. Please use the alb service, version v2beta2 instead  This API offers an interface to provision and manage load balancing servers in your STACKIT project. It also has the possibility of pooling target servers for load balancing purposes.  For each application load balancer provided, two VMs are deployed in your OpenStack project subject to a fee.

    The version of the OpenAPI document: 1beta.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
import re
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated, Self

from stackit.lbapplication.models.active_health_check import ActiveHealthCheck
from stackit.lbapplication.models.target import Target


class TargetPool(BaseModel):
    """
    TargetPool
    """

    active_health_check: Optional[ActiveHealthCheck] = Field(default=None, alias="activeHealthCheck")
    name: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Target pool name")
    target_port: Optional[Annotated[int, Field(le=65535, strict=True, ge=1)]] = Field(
        default=None,
        description="The number identifying the port where each target listens for traffic.",
        alias="targetPort",
    )
    targets: Optional[List[Target]] = Field(
        default=None, description="List of all targets which will be used in the pool. Limited to 250."
    )
    __properties: ClassVar[List[str]] = ["activeHealthCheck", "name", "targetPort", "targets"]

    @field_validator("name")
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9a-z](?:(?:[0-9a-z]|-){0,18}[0-9a-z])?$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-z](?:(?:[0-9a-z]|-){0,18}[0-9a-z])?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TargetPool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of active_health_check
        if self.active_health_check:
            _dict["activeHealthCheck"] = self.active_health_check.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in targets (list)
        _items = []
        if self.targets:
            for _item in self.targets:
                if _item:
                    _items.append(_item.to_dict())
            _dict["targets"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TargetPool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "activeHealthCheck": (
                    ActiveHealthCheck.from_dict(obj["activeHealthCheck"])
                    if obj.get("activeHealthCheck") is not None
                    else None
                ),
                "name": obj.get("name"),
                "targetPort": obj.get("targetPort"),
                "targets": (
                    [Target.from_dict(_item) for _item in obj["targets"]] if obj.get("targets") is not None else None
                ),
            }
        )
        return _obj
