# coding: utf-8

"""
    Load Balancer API

    This API offers an interface to provision and manage load balancing servers in your STACKIT project. It also has the possibility of pooling target servers for load balancing purposes.  For each load balancer provided, two VMs are deployed in your OpenStack project subject to a fee.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
import re
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated, Self


class ActiveHealthCheck(BaseModel):
    """
    ActiveHealthCheck
    """

    healthy_threshold: Optional[Annotated[int, Field(le=1000000, strict=True, ge=1)]] = Field(
        default=None, description="Healthy threshold of the health checking", alias="healthyThreshold"
    )
    interval: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None, description="Interval duration of health checking in seconds"
    )
    interval_jitter: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None,
        description="Interval duration threshold of the health checking in seconds",
        alias="intervalJitter",
    )
    timeout: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None, description="Active health checking timeout duration in seconds"
    )
    unhealthy_threshold: Optional[Annotated[int, Field(le=1000000, strict=True, ge=1)]] = Field(
        default=None, description="Unhealthy threshold of the health checking", alias="unhealthyThreshold"
    )
    __properties: ClassVar[List[str]] = [
        "healthyThreshold",
        "interval",
        "intervalJitter",
        "timeout",
        "unhealthyThreshold",
    ]

    @field_validator("interval")
    def interval_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^-?(?:0|[1-9][0-9]{0,11})(?:\.[0-9]{1,9})?s$", value):
            raise ValueError(r"must validate the regular expression /^-?(?:0|[1-9][0-9]{0,11})(?:\.[0-9]{1,9})?s$/")
        return value

    @field_validator("interval_jitter")
    def interval_jitter_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^-?(?:0|[1-9][0-9]{0,11})(?:\.[0-9]{1,9})?s$", value):
            raise ValueError(r"must validate the regular expression /^-?(?:0|[1-9][0-9]{0,11})(?:\.[0-9]{1,9})?s$/")
        return value

    @field_validator("timeout")
    def timeout_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^-?(?:0|[1-9][0-9]{0,11})(?:\.[0-9]{1,9})?s$", value):
            raise ValueError(r"must validate the regular expression /^-?(?:0|[1-9][0-9]{0,11})(?:\.[0-9]{1,9})?s$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActiveHealthCheck from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActiveHealthCheck from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "healthyThreshold": obj.get("healthyThreshold"),
                "interval": obj.get("interval"),
                "intervalJitter": obj.get("intervalJitter"),
                "timeout": obj.get("timeout"),
                "unhealthyThreshold": obj.get("unhealthyThreshold"),
            }
        )
        return _obj
