# coding: utf-8

"""
    STACKIT Model Serving API

    This API provides endpoints for the model serving api

    The version of the OpenAPI document: 1.0.0
    Contact: model-serving@mail.schwarz
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated, Self

from stackit.modelserving.models.sku import SKU


class Model(BaseModel):
    """
    Model
    """  # noqa: E501

    category: StrictStr
    description: Annotated[str, Field(strict=True, max_length=2000)]
    displayed_name: Annotated[str, Field(min_length=1, strict=True, max_length=200)] = Field(alias="displayedName")
    id: StrictStr = Field(description="generated uuid to identify a model")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=200)] = Field(description="huggingface name")
    region: StrictStr
    skus: List[SKU]
    tags: Optional[List[StrictStr]] = None
    type: StrictStr
    url: Annotated[str, Field(min_length=1, strict=True, max_length=200)] = Field(description="url of the model")
    __properties: ClassVar[List[str]] = [
        "category",
        "description",
        "displayedName",
        "id",
        "name",
        "region",
        "skus",
        "tags",
        "type",
        "url",
    ]

    @field_validator("category")
    def category_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(["standard", "plus", "premium"]):
            raise ValueError("must be one of enum values ('standard', 'plus', 'premium')")
        return value

    @field_validator("description")
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9a-zA-Z\s.:\/\-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-zA-Z\s.:\/\-]+$/")
        return value

    @field_validator("displayed_name")
    def displayed_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9a-zA-Z\s_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-zA-Z\s_-]+$/")
        return value

    @field_validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(["chat", "embedding"]):
            raise ValueError("must be one of enum values ('chat', 'embedding')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Model from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in skus (list)
        _items = []
        if self.skus:
            for _item in self.skus:
                if _item:
                    _items.append(_item.to_dict())
            _dict["skus"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Model from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "category": obj.get("category"),
                "description": obj.get("description"),
                "displayedName": obj.get("displayedName"),
                "id": obj.get("id"),
                "name": obj.get("name"),
                "region": obj.get("region"),
                "skus": [SKU.from_dict(_item) for _item in obj["skus"]] if obj.get("skus") is not None else None,
                "tags": obj.get("tags"),
                "type": obj.get("type"),
                "url": obj.get("url"),
            }
        )
        return _obj
