# coding: utf-8

"""
    STACKIT Model Serving API

    This API provides endpoints for the model serving api

    The version of the OpenAPI document: 1.0.0
    Contact: model-serving@mail.schwarz
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated, Self


class TokenCreated(BaseModel):
    """
    TokenCreated
    """  # noqa: E501

    content: Annotated[str, Field(min_length=1, strict=True, max_length=200)]
    description: Optional[Annotated[str, Field(strict=True, max_length=2000)]] = None
    id: StrictStr
    name: Annotated[str, Field(min_length=1, strict=True, max_length=200)]
    region: StrictStr
    state: StrictStr
    valid_until: datetime = Field(alias="validUntil")
    __properties: ClassVar[List[str]] = ["content", "description", "id", "name", "region", "state", "validUntil"]

    @field_validator("content")
    def content_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9a-zA-Z\s_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-zA-Z\s_-]+$/")
        return value

    @field_validator("description")
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9a-zA-Z\s.:\/\-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-zA-Z\s.:\/\-]+$/")
        return value

    @field_validator("name")
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9a-zA-Z\s_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-zA-Z\s_-]+$/")
        return value

    @field_validator("state")
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(["creating", "active", "deleting"]):
            raise ValueError("must be one of enum values ('creating', 'active', 'deleting')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TokenCreated from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TokenCreated from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "content": obj.get("content"),
                "description": obj.get("description"),
                "id": obj.get("id"),
                "name": obj.get("name"),
                "region": obj.get("region"),
                "state": obj.get("state"),
                "validUntil": obj.get("validUntil"),
            }
        )
        return _obj
