# coding: utf-8

"""
    STACKIT Object Storage API

    STACKIT API to manage the Object Storage 

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Self


class CreateAccessKeyResponse(BaseModel):
    """
    CreateAccessKeyResponse
    """

    access_key: StrictStr = Field(description="Access key", alias="accessKey")
    display_name: StrictStr = Field(description="Obfuscated access key", alias="displayName")
    expires: StrictStr = Field(description="Expiration date. Null means never expires.")
    key_id: StrictStr = Field(
        description="Identifies the pair of access key and secret access key for deletion", alias="keyId"
    )
    project: StrictStr = Field(description="Project ID")
    secret_access_key: StrictStr = Field(description="Secret access key", alias="secretAccessKey")
    __properties: ClassVar[List[str]] = ["accessKey", "displayName", "expires", "keyId", "project", "secretAccessKey"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAccessKeyResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAccessKeyResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "accessKey": obj.get("accessKey"),
                "displayName": obj.get("displayName"),
                "expires": obj.get("expires"),
                "keyId": obj.get("keyId"),
                "project": obj.get("project"),
                "secretAccessKey": obj.get("secretAccessKey"),
            }
        )
        return _obj
