# coding: utf-8

"""
    STACKIT Secrets Manager API

    This API provides endpoints for managing the Secrets-Manager. 

    The version of the OpenAPI document: 1.4.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictStr,
)
from typing_extensions import Self


class User(BaseModel):
    """
    User
    """  # noqa: E501

    description: StrictStr = Field(description="A user chosen description to differentiate between multiple users.")
    id: StrictStr = Field(description="A auto generated unique id which identifies the users.")
    password: StrictStr = Field(description="A auto generated password for logging in with the user.")
    username: StrictStr = Field(description="A auto generated username for logging in with the user.")
    write: StrictBool = Field(
        description="Is true if the user has write access to the secrets engine. Is false for a read-only user."
    )
    __properties: ClassVar[List[str]] = ["description", "id", "password", "username", "write"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "description": obj.get("description"),
                "id": obj.get("id"),
                "password": obj.get("password"),
                "username": obj.get("username"),
                "write": obj.get("write"),
            }
        )
        return _obj
