# coding: utf-8

"""
    STACKIT Server Backup Management API

    API endpoints for Server Backup Operations on STACKIT Servers.

    The version of the OpenAPI document: 2.0
    Contact: support@stackit.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing_extensions import Self

from stackit.serverbackup.models.backup_properties import BackupProperties


class BackupSchedule(BaseModel):
    """
    BackupSchedule
    """

    backup_properties: Optional[BackupProperties] = Field(default=None, alias="backupProperties")
    enabled: StrictBool
    id: StrictInt
    name: StrictStr
    rrule: StrictStr
    __properties: ClassVar[List[str]] = ["backupProperties", "enabled", "id", "name", "rrule"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BackupSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of backup_properties
        if self.backup_properties:
            _dict["backupProperties"] = self.backup_properties.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BackupSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "backupProperties": (
                    BackupProperties.from_dict(obj["backupProperties"])
                    if obj.get("backupProperties") is not None
                    else None
                ),
                "enabled": obj.get("enabled"),
                "id": obj.get("id"),
                "name": obj.get("name"),
                "rrule": obj.get("rrule"),
            }
        )
        return _obj
