# coding: utf-8

"""
    STACKIT MSSQL Service API

    This is the documentation for the STACKIT MSSQL service

    The version of the OpenAPI document: 2.0.0
    Contact: support@stackit.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Self


class GetBackupResponse(BaseModel):
    """
    GetBackupResponse
    """

    end_time: Optional[StrictStr] = Field(
        default=None, description="Backup end time represents local server time", alias="endTime"
    )
    error: Optional[StrictStr] = Field(default=None, description="Backup error")
    id: Optional[StrictStr] = Field(default=None, description="Backup id")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Backup labels")
    name: Optional[StrictStr] = Field(default=None, description="Backup name")
    options: Optional[Dict[str, StrictStr]] = Field(default=None, description="Backup specific options")
    size: Optional[StrictInt] = Field(default=None, description="Backup size in byte")
    start_time: Optional[StrictStr] = Field(
        default=None, description="Backup start time represents local server time", alias="startTime"
    )
    __properties: ClassVar[List[str]] = ["endTime", "error", "id", "labels", "name", "options", "size", "startTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetBackupResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetBackupResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "endTime": obj.get("endTime"),
                "error": obj.get("error"),
                "id": obj.get("id"),
                "labels": obj.get("labels"),
                "name": obj.get("name"),
                "options": obj.get("options"),
                "size": obj.get("size"),
                "startTime": obj.get("startTime"),
            }
        )
        return _obj
