import os

import click
import stackl_client


class StacklContext(object):
    def __init__(self):
        with open(config_path, 'r+') as stackl_config:
            host = stackl_config.read()
        configuration = stackl_client.Configuration()
        configuration.host = host
        self.api_client = stackl_client.ApiClient(configuration=configuration)
        self.infrastructure_base_api = stackl_client.InfrastructureBaseApi(
            api_client=self.api_client)
        self.functional_requirements_api = stackl_client.FunctionalRequirementsApi(
            api_client=self.api_client)
        self.services_api = stackl_client.ServicesApi(
            api_client=self.api_client)
        self.sat_api = stackl_client.StackApplicationTemplatesApi(
            api_client=self.api_client)
        self.sit_api = stackl_client.StackInfrastructureTemplatesApi(
            api_client=self.api_client)
        self.stack_instances_api = stackl_client.StackInstancesApi(
            api_client=self.api_client)
        self.policy_templates_api = stackl_client.PolicyTemplatesApi(
            api_client=self.api_client)
        self.snapshot_api = stackl_client.SnapshotsApi(
            api_client=self.api_client)


pass_stackl_context = click.make_pass_decorator(StacklContext, ensure=True)

config_path = os.path.expanduser('~') + os.sep + '.stackl' + os.sep + 'config'
