# Credit Card Statement Processor

A Python CLI tool that extracts transaction data from PDF credit card statements, parses them into structured data, and categorizes transactions as recurring (monthly/yearly) or one-time.

## Core Capabilities

- PDF text extraction using Docling
- Transaction parsing with date normalization and amount handling
- Recurrence detection (monthly, yearly, one-time)
- Vendor aggregation (transaction counts and totals by merchant)
- CSV export for transactions and summaries

## Target Use Case

Processing PNC CashBuilder credit card statement PDFs to:
1. Extract all transactions with dates, descriptions, and amounts
2. Identify recurring subscriptions vs one-time purchases
3. Generate CSV reports for financial analysis

## Key Outputs

- `full_transactions.csv` - All extracted transactions with category
- `recurring_transactions.csv` - Monthly and yearly recurring transactions
- `adhoc_transactions.csv` - One-time transactions
- `vendor_amounts.csv` - Vendors aggregated with transaction counts and totals
