# Tech Stack

## Language & Runtime

- Python 3.13+
- Package manager: `uv`

## Core Dependencies

- `docling` - PDF text extraction and document conversion
- `pandas` - Data manipulation and CSV export
- `pydantic` - Data models and validation

## Testing

- `pytest` - Test framework
- `hypothesis` - Property-based testing

## Common Commands

```bash
# Install dependencies
uv sync

# Run the processor
uv run python main.py <input_dirs> [--output <dir>] [--debug <dir>] [--tolerance <float>] [--no-strict]

# Examples
uv run python main.py ./statements
uv run python main.py ./2024_cc ./2025_cc -o ./results -d ./debug -t 0.10
uv run python main.py ./statements --no-strict  # Continue on validation errors

# Run tests
uv run pytest

# Run tests with verbose output
uv run pytest -v
```

## Code Style

- Type hints on all function signatures
- Docstrings with Args/Returns sections
- Logging via `logging` module (not print statements)
- Pydantic models for data structures with Field descriptions
- Property-based tests using Hypothesis for parsing logic
