# Future Features

This folder contains code from the legacy `src/` implementation that represents planned functionality not yet integrated into the main `statement_processor` package.

## Contents

### recurrence_analyzer.py
Classifies transactions as monthly recurring, yearly recurring, or one-time based on:
- Amount clustering with configurable tolerance
- Calendar month analysis across years
- Frequency-based pattern detection

### feature_engineer.py
Stub for enriching transaction data with parsed description fields:
- Vendor name extraction
- Phone number parsing
- City/state extraction
- Online transaction detection

## Integration Notes

These modules were designed for the original `src/` codebase. To integrate into `statement_processor`:

1. **RecurrenceAnalyzer** could become a `ClusteringStrategy` implementation
2. **FeatureEngineer** could be a preprocessing step before clustering

Both would need to be adapted to work with the `BaseTransaction` interface and DataFrame conventions used by the analytics framework.
