#!/usr/bin/env python
"""Credit Card Statement Processor - Main Entry Point.

Process PDF financial statements, extract transactions, and generate
vendor summary reports.

Usage:
    python main.py <input_dir> [<input_dir2> ...] [--output <dir>] [--debug <dir>]

Examples:
    python main.py ./statements
    python main.py ./2024_statements ./2025_statements --output ./results
    python main.py ./statements --debug ./debug_output
"""

import sys

from statement_processor.cli import main

if __name__ == "__main__":
    sys.exit(main())
