"""Analytics module for transaction clustering and pattern analysis.

This module provides a unified clustering framework where all transaction
analysis problems are modeled as clustering.

Core components:
- ClusteringStrategy: Abstract base for clustering algorithms
- TransactionCluster: Cluster with membership scores
- ClusterRunner: Orchestrates strategies and merges results
- VendorClusterer: High-level vendor clustering interface
"""

from statement_processor.analytics.clustering import (
    ClusteringStrategy,
    TransactionCluster,
)
from statement_processor.analytics.cluster_runner import ClusterRunner
from statement_processor.analytics.vendor_clusterer import VendorClusterer
from statement_processor.analytics.vendor_patterns import (
    VENDOR_PATTERNS,
    load_patterns,
)

__all__ = [
    "ClusteringStrategy",
    "TransactionCluster",
    "ClusterRunner",
    "VendorClusterer",
    "VENDOR_PATTERNS",
    "load_patterns",
]
