"""Strategy implementations for transaction clustering.

This package contains built-in clustering strategies. Third-party
plugins can add additional strategies via entry points.
"""

from statement_processor.analytics.strategies.exact_match import ExactMatchStrategy
from statement_processor.analytics.strategies.regex_vendor import (
    RegexVendorStrategy,
    VendorPattern,
)

__all__ = [
    "ExactMatchStrategy",
    "RegexVendorStrategy",
    "VendorPattern",
]
