"""Core interfaces and plugin registry for Statement Processor.

This module defines the abstract base classes that plugins implement
and the registry for discovering installed plugins.
"""

from statement_processor.core.base_transaction import BaseTransaction
from statement_processor.core.base_parser import BaseStatementParser
from statement_processor.core.registry import (
    discover_parsers,
    discover_strategies,
    auto_detect_parser,
    get_parser_by_name,
)

__all__ = [
    "BaseTransaction",
    "BaseStatementParser",
    "discover_parsers",
    "discover_strategies",
    "auto_detect_parser",
    "get_parser_by_name",
]
