"""PDF extraction modules for Statement Processor.

This package provides PDF to markdown extraction using Docling.
"""

__all__ = ["PdfMarkdownExtractor", "PDFScanner"]


def __getattr__(name: str):
    """Lazy imports to avoid circular dependencies."""
    if name == "PdfMarkdownExtractor":
        from statement_processor.extraction.pdf_markdown_extractor import PdfMarkdownExtractor
        return PdfMarkdownExtractor
    if name == "PDFScanner":
        from statement_processor.extraction.pdf_scanner import PDFScanner
        return PDFScanner
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
