"""Shared fixtures and Hypothesis profiles for tests."""

import pytest
from hypothesis import settings, Verbosity

# Configure Hypothesis profiles
settings.register_profile(
    "default",
    max_examples=100,
    verbosity=Verbosity.normal,
)

settings.register_profile(
    "ci",
    max_examples=100,
    verbosity=Verbosity.verbose,
)

settings.load_profile("default")


def pytest_configure(config):
    """Register custom markers."""
    config.addinivalue_line(
        "markers", "slow: marks tests as slow (deselect with '-m \"not slow\"')"
    )
