from collections import ChainMap

import numpy as np

from std_utils.std_types.float import FLOAT_DTYPES, FLOAT_DTYPE_INFO, FLOAT_PRECISION_INFO_MAP
from std_utils.std_types.int import DOUBLE_INT_DTYPES, HALF_INT_DTYPES, INT_DTYPE_INFO, INT_DTYPES, INT_PRECISION_INFO_MAP, QUARTER_INT_DTYPES, SINGLE_INT_DTYPES




NUMERIC_DTYPES = INT_DTYPES | FLOAT_DTYPES


HALF_NUMERIC_DTYPES = HALF_INT_DTYPES | {np.dtypes.Float16DType}

SINGLE_NUMERIC_DTYPES = SINGLE_INT_DTYPES | {np.dtypes.Float32DType}

DOUBLE_NUMERIC_DTYPES = DOUBLE_INT_DTYPES | {np.dtypes.Float64DType}

NUMERIC_DTYPE_INFO = ChainMap(INT_DTYPE_INFO, FLOAT_DTYPE_INFO)
NUMERIC_PRECISION_INFO_MAP = ChainMap(INT_PRECISION_INFO_MAP, FLOAT_PRECISION_INFO_MAP)
