"""
Setup script for rivulet
"""

from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

with open("requirements.txt", "r", encoding="utf-8") as fh:
    requirements = [line.strip() for line in fh if line.strip() and not line.startswith("#")]

setup(
    name="streaming-sql-engine",
    version="0.1.0",
    author="Ierofantis",
    author_email="teopanta1986@gmail.com",
    description="A lightweight SQL execution engine for streaming row-by-row queries with joins",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Ierofantis/streaming-sql-engine",
    # Package files are now in the streaming_sql_engine directory
    packages=["streaming_sql_engine"],
    include_package_data=True,
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Database",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.8",
    install_requires=requirements,
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-cov>=4.0.0",
            "black>=23.0.0",
            "flake8>=6.0.0",
        ],
    },
    keywords="sql streaming join database query engine",
    project_urls={
        "Bug Reports": "https://github.com/Ierofantis/streaming-sql-engine",
        "Source": "https://github.com/Ierofantis/streaming-sql-engine",
        "Documentation": "https://github.com/Ierofantis/streaming-sql-engine",
    },
)

