"""
Streaming SQL Join Engine

A lightweight SQL execution engine that processes queries row-by-row
without loading full tables into memory.
"""

from .engine import Engine
from .db_connector import (
    PostgreSQLPool,
    MySQLPool,
    create_pool_from_env,
    create_mysql_pool_from_env,
    create_postgresql_pool_from_env,
    stream_query,
    create_table_source
)

__version__ = "0.1.2"
__all__ = [
    "Engine",
    "PostgreSQLPool",
    "MySQLPool",
    "create_pool_from_env",
    "create_mysql_pool_from_env",
    "create_postgresql_pool_from_env",
    "stream_query",
    "create_table_source"
]

