# suger-sdk-python
CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.suger.io/support](https://www.suger.io/support)

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/sugerio/suger-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/sugerio/suger-sdk-python.git`)

Then import the package:
```python
import suger_sdk_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import suger_sdk_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import suger_sdk_python
from suger_sdk_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://https://api.suger.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = suger_sdk_python.Configuration(
    host = "http://https://api.suger.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyAuth
configuration.api_key['APIKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with suger_sdk_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = suger_sdk_python.APIApi(api_client)
    org_id = 'org_id_example' # str | Organization ID
    api_client_id = 'api_client_id_example' # str | API client ID

    try:
        # get api client
        api_response = api_instance.get_api_client(org_id, api_client_id)
        print("The response of APIApi->get_api_client:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIApi->get_api_client: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://https://api.suger.cloud*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIApi* | [**get_api_client**](docs/APIApi.md#get_api_client) | **GET** /org/{orgId}/apiClient/{apiClientId} | get api client
*APIApi* | [**get_api_client_access_token**](docs/APIApi.md#get_api_client_access_token) | **POST** /public/apiClient/accessToken | get api access token
*APIApi* | [**list_api_clients**](docs/APIApi.md#list_api_clients) | **GET** /org/{orgId}/apiClient | list api clients
*BillingApi* | [**create_addon**](docs/BillingApi.md#create_addon) | **POST** /org/{orgId}/addon | create addon
*BillingApi* | [**create_refund**](docs/BillingApi.md#create_refund) | **POST** /org/{orgId}/buyer/{buyerId}/paymentTransaction/{paymentTransactionId}/refund | create refund.
*BillingApi* | [**delete_addon**](docs/BillingApi.md#delete_addon) | **DELETE** /org/{orgId}/addon/{addonId} | delete addon
*BillingApi* | [**get_addon**](docs/BillingApi.md#get_addon) | **GET** /org/{orgId}/addon/{addonId} | get addon
*BillingApi* | [**get_invoice**](docs/BillingApi.md#get_invoice) | **GET** /org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId} | get invoice
*BillingApi* | [**issue_invoice**](docs/BillingApi.md#issue_invoice) | **PATCH** /org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId}/issue | issue invoice
*BillingApi* | [**list_addons**](docs/BillingApi.md#list_addons) | **GET** /org/{orgId}/addon | list addons
*BillingApi* | [**list_invoices**](docs/BillingApi.md#list_invoices) | **GET** /org/{orgId}/invoice | list invoices
*BillingApi* | [**list_payment_transactions**](docs/BillingApi.md#list_payment_transactions) | **GET** /org/{orgId}/paymentTransaction | list payment transactions
*BillingApi* | [**list_refund_of_payment_transaction**](docs/BillingApi.md#list_refund_of_payment_transaction) | **GET** /org/{orgId}/buyer/{buyerId}/paymentTransaction/{paymentTransactionId}/refund | list refunds.
*BillingApi* | [**pay_invoice**](docs/BillingApi.md#pay_invoice) | **PATCH** /org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId}/pay | pay invoice
*BillingApi* | [**update_addon**](docs/BillingApi.md#update_addon) | **PATCH** /org/{orgId}/addon/{addonId} | update addon
*BillingApi* | [**void_invoice**](docs/BillingApi.md#void_invoice) | **PATCH** /org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId}/void | void invoice
*BuyerApi* | [**close_credit_wallet**](docs/BuyerApi.md#close_credit_wallet) | **PATCH** /org/{orgId}/buyer/{buyerId}/wallet/{walletId}/close | close credit wallet
*BuyerApi* | [**create_buyer**](docs/BuyerApi.md#create_buyer) | **POST** /org/{orgId}/buyer | create buyer
*BuyerApi* | [**create_credit_wallet**](docs/BuyerApi.md#create_credit_wallet) | **POST** /org/{orgId}/buyer/{buyerId}/wallet | create credit wallet
*BuyerApi* | [**delete_buyer_wallet**](docs/BuyerApi.md#delete_buyer_wallet) | **DELETE** /org/{orgId}/buyer/{buyerId}/wallet/{walletId} | delete buyer wallet
*BuyerApi* | [**get_buyer**](docs/BuyerApi.md#get_buyer) | **GET** /org/{orgId}/buyer/{buyerId} | get buyer
*BuyerApi* | [**list_buyer_wallets**](docs/BuyerApi.md#list_buyer_wallets) | **GET** /org/{orgId}/buyer/{buyerId}/wallet | list buyer&#39;s wallets
*BuyerApi* | [**list_buyers**](docs/BuyerApi.md#list_buyers) | **GET** /org/{orgId}/buyer | list buyers
*BuyerApi* | [**set_buyer_default_wallet**](docs/BuyerApi.md#set_buyer_default_wallet) | **PATCH** /org/{orgId}/buyer/{buyerId}/wallet/{walletId}/default | set buyer default wallet
*BuyerApi* | [**update_buyer**](docs/BuyerApi.md#update_buyer) | **PATCH** /org/{orgId}/buyer/{buyerId} | update buyer
*BuyerApi* | [**update_credit_wallet**](docs/BuyerApi.md#update_credit_wallet) | **PATCH** /org/{orgId}/buyer/{buyerId}/wallet/{walletId} | update credit wallet
*ContactApi* | [**add_contact_to_buyer**](docs/ContactApi.md#add_contact_to_buyer) | **POST** /org/{orgId}/contact/{contactId}/buyer/{buyerId} | add contact to buyer
*ContactApi* | [**add_contact_to_offer**](docs/ContactApi.md#add_contact_to_offer) | **POST** /org/{orgId}/contact/{contactId}/offer/{offerId} | add contact to offer
*ContactApi* | [**batch_create_contacts**](docs/ContactApi.md#batch_create_contacts) | **POST** /org/{orgId}/contact/batch | batch create contacts
*ContactApi* | [**create_contact**](docs/ContactApi.md#create_contact) | **POST** /org/{orgId}/contact | create contact
*ContactApi* | [**get_contact**](docs/ContactApi.md#get_contact) | **GET** /org/{orgId}/contact/{contactId} | get contact
*ContactApi* | [**list_contacts_by_organization**](docs/ContactApi.md#list_contacts_by_organization) | **GET** /org/{orgId}/contact | list contacts by organization
*ContactApi* | [**remove_contact_from_buyer**](docs/ContactApi.md#remove_contact_from_buyer) | **DELETE** /org/{orgId}/contact/{contactId}/buyer/{buyerId} | remove contact from buyer
*ContactApi* | [**remove_contact_from_offer**](docs/ContactApi.md#remove_contact_from_offer) | **DELETE** /org/{orgId}/contact/{contactId}/offer/{offerId} | remove contact from offer
*ContactApi* | [**update_contact**](docs/ContactApi.md#update_contact) | **PATCH** /org/{orgId}/contact/{contactId} | update contact
*EntitlementApi* | [**add_entitlement_credit**](docs/EntitlementApi.md#add_entitlement_credit) | **POST** /org/{orgId}/entitlement/{entitlementId}/addCredit | add entitlement credit
*EntitlementApi* | [**apply_addon_to_entitlement**](docs/EntitlementApi.md#apply_addon_to_entitlement) | **POST** /org/{orgId}/entitlement/{entitlementId}/addon | apply addon to entitlement
*EntitlementApi* | [**approve_entitlement**](docs/EntitlementApi.md#approve_entitlement) | **POST** /org/{orgId}/entitlement/{entitlementId}/approve | approve entitlement
*EntitlementApi* | [**cancel_entitlement**](docs/EntitlementApi.md#cancel_entitlement) | **POST** /org/{orgId}/entitlement/{entitlementId}/cancel | cancel entitlement
*EntitlementApi* | [**create_entitlement**](docs/EntitlementApi.md#create_entitlement) | **POST** /org/{orgId}/entitlement | create entitlement
*EntitlementApi* | [**delete_entitlement_term**](docs/EntitlementApi.md#delete_entitlement_term) | **DELETE** /org/{orgId}/entitlement/{entitlementId}/entitlementTerm/{entitlementTermId} | delete entitlement term
*EntitlementApi* | [**divide_entitlement_commit**](docs/EntitlementApi.md#divide_entitlement_commit) | **POST** /org/{orgId}/entitlement/{entitlementId}/divideCommit | divide entitlement commit
*EntitlementApi* | [**get_entitlement**](docs/EntitlementApi.md#get_entitlement) | **GET** /org/{orgId}/entitlement/{entitlementId} | get entitlement
*EntitlementApi* | [**get_entitlement_term**](docs/EntitlementApi.md#get_entitlement_term) | **GET** /org/{orgId}/entitlement/{entitlementId}/entitlementTerm/{entitlementTermId} | get entitlement term
*EntitlementApi* | [**list_entitlement_terms**](docs/EntitlementApi.md#list_entitlement_terms) | **GET** /org/{orgId}/entitlement/{entitlementId}/entitlementTerm | list entitlement terms
*EntitlementApi* | [**list_entitlements**](docs/EntitlementApi.md#list_entitlements) | **GET** /org/{orgId}/entitlement | list entitlements
*EntitlementApi* | [**schedule_entitlement_cancellation**](docs/EntitlementApi.md#schedule_entitlement_cancellation) | **POST** /org/{orgId}/entitlement/{entitlementId}/scheduleCancellation | schedule entitlement cancellation
*EntitlementApi* | [**unschedule_entitlement_cancellation**](docs/EntitlementApi.md#unschedule_entitlement_cancellation) | **POST** /org/{orgId}/entitlement/{entitlementId}/unscheduleCancellation | unschedule entitlement cancellation
*EntitlementApi* | [**update_entitlement_meta_info**](docs/EntitlementApi.md#update_entitlement_meta_info) | **PATCH** /org/{orgId}/entitlement/{entitlementId}/metaInfo | update entitlement meta info
*EntitlementApi* | [**update_entitlement_name**](docs/EntitlementApi.md#update_entitlement_name) | **PATCH** /org/{orgId}/entitlement/{entitlementId}/entitlementName | update entitlement name
*EntitlementApi* | [**update_entitlement_seat**](docs/EntitlementApi.md#update_entitlement_seat) | **PATCH** /org/{orgId}/entitlement/{entitlementId}/seat | update seat for the active AZURE subscription
*MeteringApi* | [**batch_report_usage_record_groups**](docs/MeteringApi.md#batch_report_usage_record_groups) | **POST** /org/{orgId}/batchCreateUsageRecordGroups | batch report usageRecordGroups
*MeteringApi* | [**batch_validate_usage_record_groups**](docs/MeteringApi.md#batch_validate_usage_record_groups) | **POST** /org/{orgId}/batchValidateUsageRecordGroups | batch validate usageRecordGroups
*MeteringApi* | [**create_billable_metric**](docs/MeteringApi.md#create_billable_metric) | **POST** /org/{orgId}/billableMetric | create billable metric
*MeteringApi* | [**delete_usage_record_group**](docs/MeteringApi.md#delete_usage_record_group) | **DELETE** /org/{orgId}/usageRecordGroup/{usageRecordGroupId} | delete usageRecordGroup
*MeteringApi* | [**get_billable_metric**](docs/MeteringApi.md#get_billable_metric) | **GET** /org/{orgId}/billableMetric/{billableMetricId} | get billable metric
*MeteringApi* | [**get_usage_metering_config_info**](docs/MeteringApi.md#get_usage_metering_config_info) | **GET** /org/{orgId}/usageMeteringConfigInfo | get usage metering config info
*MeteringApi* | [**list_billable_metrics**](docs/MeteringApi.md#list_billable_metrics) | **GET** /org/{orgId}/billableMetric | list billable metrics
*MeteringApi* | [**list_usage_record_groups**](docs/MeteringApi.md#list_usage_record_groups) | **GET** /org/{orgId}/usageRecordGroup | list usageRecordGroups
*MeteringApi* | [**list_usage_record_reports**](docs/MeteringApi.md#list_usage_record_reports) | **GET** /org/{orgId}/usageRecordReport | list usageRecordReports
*MeteringApi* | [**report_usage_record_group**](docs/MeteringApi.md#report_usage_record_group) | **POST** /org/{orgId}/entitlement/{entitlementId}/usageRecordGroup | report usageRecordGroup
*MeteringApi* | [**retry_usage_record_group**](docs/MeteringApi.md#retry_usage_record_group) | **POST** /org/{orgId}/usageRecordGroup/{usageRecordGroupId}/retry | retry usageRecordGroup
*MeteringApi* | [**update_billable_metric**](docs/MeteringApi.md#update_billable_metric) | **PATCH** /org/{orgId}/billableMetric/{billableMetricId} | update billable metric
*MeteringApi* | [**update_usage_metering_config_info**](docs/MeteringApi.md#update_usage_metering_config_info) | **PATCH** /org/{orgId}/usageMeteringConfigInfo | update usage metering config info
*NotificationApi* | [**get_notification_message**](docs/NotificationApi.md#get_notification_message) | **GET** /org/{orgId}/notificationMessage/{notificationMessageId} | get notification message
*NotificationApi* | [**list_notification_events**](docs/NotificationApi.md#list_notification_events) | **GET** /org/{orgId}/notificationEvent | list notification events
*NotificationApi* | [**list_notification_events_by_entity**](docs/NotificationApi.md#list_notification_events_by_entity) | **GET** /org/{orgId}/notificationEvent/{entityType}/{entityId} | list notification events by entity
*NotificationApi* | [**list_notification_messages**](docs/NotificationApi.md#list_notification_messages) | **GET** /org/{orgId}/notificationMessage | list notification messages
*OfferApi* | [**cancel_offer**](docs/OfferApi.md#cancel_offer) | **POST** /org/{orgId}/offer/{offerId}/cancel | cancel offer
*OfferApi* | [**create_offer**](docs/OfferApi.md#create_offer) | **POST** /org/{orgId}/offer | create offer
*OfferApi* | [**create_or_update_draft_offer**](docs/OfferApi.md#create_or_update_draft_offer) | **POST** /org/{orgId}/draftOffer | create or update draft offer
*OfferApi* | [**delete_offer**](docs/OfferApi.md#delete_offer) | **DELETE** /org/{orgId}/offer/{offerId} | delete offer
*OfferApi* | [**extend_private_offer_expiry_date**](docs/OfferApi.md#extend_private_offer_expiry_date) | **POST** /org/{orgId}/offer/{offerId}/extendExpiryDate | extend offer expiry date
*OfferApi* | [**get_offer**](docs/OfferApi.md#get_offer) | **GET** /org/{orgId}/offer/{offerId} | get offer
*OfferApi* | [**get_offer_by_external_id**](docs/OfferApi.md#get_offer_by_external_id) | **GET** /org/{orgId}/offerExternalId/{offerExternalId} | get offer by external ID
*OfferApi* | [**get_offer_eula**](docs/OfferApi.md#get_offer_eula) | **GET** /org/{orgId}/offer/{offerId}/eula | get offer EULA
*OfferApi* | [**get_offer_reseller_eula**](docs/OfferApi.md#get_offer_reseller_eula) | **GET** /org/{orgId}/offer/{offerId}/resellerEula | get offer reseller EULA
*OfferApi* | [**list_offers**](docs/OfferApi.md#list_offers) | **GET** /org/{orgId}/offer | list offers
*OfferApi* | [**send_offer_notifications**](docs/OfferApi.md#send_offer_notifications) | **POST** /org/{orgId}/offer/{offerId}/notifyContacts | notify offer contacts
*OfferApi* | [**update_offer_meta_info**](docs/OfferApi.md#update_offer_meta_info) | **PATCH** /org/{orgId}/offer/{offerId}/metaInfo | update offer meta info
*ProductApi* | [**create_or_update_draft_product**](docs/ProductApi.md#create_or_update_draft_product) | **POST** /org/{orgId}/draftProduct | create or update draft product
*ProductApi* | [**create_product**](docs/ProductApi.md#create_product) | **POST** /org/{orgId}/product | create product
*ProductApi* | [**delete_product**](docs/ProductApi.md#delete_product) | **DELETE** /org/{orgId}/product/{productId} | delete product
*ProductApi* | [**get_product**](docs/ProductApi.md#get_product) | **GET** /org/{orgId}/product/{productId} | get product
*ProductApi* | [**list_product_metering_dimensions**](docs/ProductApi.md#list_product_metering_dimensions) | **GET** /org/{orgId}/product/{productId}/dimension | list metering dimensions of product
*ProductApi* | [**list_products_by_organization**](docs/ProductApi.md#list_products_by_organization) | **GET** /org/{orgId}/product | list products by organization
*ProductApi* | [**list_products_by_partner**](docs/ProductApi.md#list_products_by_partner) | **GET** /org/{orgId}/partner/{partner}/product | list products by partner
*ProductApi* | [**publish_product**](docs/ProductApi.md#publish_product) | **PATCH** /org/{orgId}/product/{productId}/publish | publish product
*ProductApi* | [**update_product**](docs/ProductApi.md#update_product) | **PATCH** /org/{orgId}/product/{productId} | update product
*ProductApi* | [**update_product_fulfillment_url**](docs/ProductApi.md#update_product_fulfillment_url) | **PATCH** /org/{orgId}/product/{productId}/fulfillmentUrl | update product fulfillment url
*ProductApi* | [**update_product_meta_info**](docs/ProductApi.md#update_product_meta_info) | **PATCH** /org/{orgId}/product/{productId}/metaInfo | update product meta info
*ReportApi* | [**get_revenue_report**](docs/ReportApi.md#get_revenue_report) | **POST** /org/{orgId}/revenueReport | get revenue report
*ReportApi* | [**list_daily_revenue_records**](docs/ReportApi.md#list_daily_revenue_records) | **GET** /org/{orgId}/dailyRevenueRecord | list daily revenue records
*ReportApi* | [**list_revenue_record_details**](docs/ReportApi.md#list_revenue_record_details) | **GET** /org/{orgId}/partner/{partner}/revenueRecordDetail | list revenue record details
*ReportApi* | [**list_revenue_records**](docs/ReportApi.md#list_revenue_records) | **GET** /org/{orgId}/partner/{partner}/revenueRecord | list revenue records
*ReportApi* | [**list_usage_metering_daily_records**](docs/ReportApi.md#list_usage_metering_daily_records) | **GET** /org/{orgId}/partner/{partner}/usageMeteringDailyRecord | list usage metering daily records
*SupportApi* | [**close_support_ticket**](docs/SupportApi.md#close_support_ticket) | **PATCH** /org/{orgId}/support/ticket/{ticketId}/close | close support ticket
*SupportApi* | [**create_support_ticket**](docs/SupportApi.md#create_support_ticket) | **POST** /org/{orgId}/support/ticket | create support ticket
*SupportApi* | [**create_support_ticket_attachment**](docs/SupportApi.md#create_support_ticket_attachment) | **POST** /org/{orgId}/support/ticket/{ticketId}/attachment | create support ticket attachment
*SupportApi* | [**create_support_ticket_comment**](docs/SupportApi.md#create_support_ticket_comment) | **POST** /org/{orgId}/support/ticket/{ticketId}/comment | create support ticket comment
*SupportApi* | [**get_support_ticket**](docs/SupportApi.md#get_support_ticket) | **GET** /org/{orgId}/support/ticket/{ticketId} | get support ticket
*SupportApi* | [**list_support_tickets**](docs/SupportApi.md#list_support_tickets) | **GET** /org/{orgId}/support/ticket | list support tickets
*SupportApi* | [**reopen_support_ticket**](docs/SupportApi.md#reopen_support_ticket) | **PATCH** /org/{orgId}/support/ticket/{ticketId}/reopen | reopen support ticket
*SupportApi* | [**update_support_ticket**](docs/SupportApi.md#update_support_ticket) | **PATCH** /org/{orgId}/support/ticket/{ticketId} | update support ticket


## Documentation For Models

 - [AddEntitlementCreditParams](docs/AddEntitlementCreditParams.md)
 - [AddEntitlementCreditResponse](docs/AddEntitlementCreditResponse.md)
 - [AdyenBuyer](docs/AdyenBuyer.md)
 - [AggregatedMeteringUsageRecord](docs/AggregatedMeteringUsageRecord.md)
 - [AlibabaMarketplaceProduct](docs/AlibabaMarketplaceProduct.md)
 - [AlibabaMarketplaceProductExtra](docs/AlibabaMarketplaceProductExtra.md)
 - [AlibabaMarketplaceProductExtras](docs/AlibabaMarketplaceProductExtras.md)
 - [AlibabaMarketplaceProductShopInfo](docs/AlibabaMarketplaceProductShopInfo.md)
 - [AlibabaMarketplaceProductShopInfoTelephones](docs/AlibabaMarketplaceProductShopInfoTelephones.md)
 - [AlibabaMarketplaceProductShopInfoWangWang](docs/AlibabaMarketplaceProductShopInfoWangWang.md)
 - [AlibabaMarketplaceProductShopInfoWangWangs](docs/AlibabaMarketplaceProductShopInfoWangWangs.md)
 - [AlibabaMarketplaceProductSku](docs/AlibabaMarketplaceProductSku.md)
 - [AlibabaMarketplaceProductSkuModule](docs/AlibabaMarketplaceProductSkuModule.md)
 - [AlibabaMarketplaceProductSkuModuleProperties](docs/AlibabaMarketplaceProductSkuModuleProperties.md)
 - [AlibabaMarketplaceProductSkuModuleProperty](docs/AlibabaMarketplaceProductSkuModuleProperty.md)
 - [AlibabaMarketplaceProductSkuModulePropertyValue](docs/AlibabaMarketplaceProductSkuModulePropertyValue.md)
 - [AlibabaMarketplaceProductSkuModulePropertyValues](docs/AlibabaMarketplaceProductSkuModulePropertyValues.md)
 - [AlibabaMarketplaceProductSkuModules](docs/AlibabaMarketplaceProductSkuModules.md)
 - [AlibabaMarketplaceProductSkuOrderPeriod](docs/AlibabaMarketplaceProductSkuOrderPeriod.md)
 - [AlibabaMarketplaceProductSkuOrderPeriods](docs/AlibabaMarketplaceProductSkuOrderPeriods.md)
 - [AlibabaMarketplaceProductSkus](docs/AlibabaMarketplaceProductSkus.md)
 - [ApiClientAccessToken](docs/ApiClientAccessToken.md)
 - [AuditingEventPriority](docs/AuditingEventPriority.md)
 - [AwsAccountIdentifier](docs/AwsAccountIdentifier.md)
 - [AwsChannelPartner](docs/AwsChannelPartner.md)
 - [AwsMarketplaceAgreementStatus](docs/AwsMarketplaceAgreementStatus.md)
 - [AwsMarketplaceAgreementV2](docs/AwsMarketplaceAgreementV2.md)
 - [AwsMarketplaceBuyerAccount](docs/AwsMarketplaceBuyerAccount.md)
 - [AwsMarketplaceCatalogLegalTermDocument](docs/AwsMarketplaceCatalogLegalTermDocument.md)
 - [AwsMarketplaceCatalogLegalTermDocumentType](docs/AwsMarketplaceCatalogLegalTermDocumentType.md)
 - [AwsMarketplaceCatalogPricingModel](docs/AwsMarketplaceCatalogPricingModel.md)
 - [AwsMarketplaceCatalogPricingTermRateCard](docs/AwsMarketplaceCatalogPricingTermRateCard.md)
 - [AwsMarketplaceCatalogPricingTermRateCardConstraints](docs/AwsMarketplaceCatalogPricingTermRateCardConstraints.md)
 - [AwsMarketplaceCatalogPricingTermRateCardItem](docs/AwsMarketplaceCatalogPricingTermRateCardItem.md)
 - [AwsMarketplaceCatalogPricingTermRateCardSelector](docs/AwsMarketplaceCatalogPricingTermRateCardSelector.md)
 - [AwsMarketplaceCppoDiscountType](docs/AwsMarketplaceCppoDiscountType.md)
 - [AwsMarketplaceCppoDurationType](docs/AwsMarketplaceCppoDurationType.md)
 - [AwsMarketplaceCppoOpportunity](docs/AwsMarketplaceCppoOpportunity.md)
 - [AwsMarketplaceCppoOpportunityNegativeTargeting](docs/AwsMarketplaceCppoOpportunityNegativeTargeting.md)
 - [AwsMarketplaceCppoOpportunityOfferDetails](docs/AwsMarketplaceCppoOpportunityOfferDetails.md)
 - [AwsMarketplaceCppoOpportunityPaymentSchedule](docs/AwsMarketplaceCppoOpportunityPaymentSchedule.md)
 - [AwsMarketplaceCppoOpportunityPositiveTargeting](docs/AwsMarketplaceCppoOpportunityPositiveTargeting.md)
 - [AwsMarketplaceCppoOpportunityRule](docs/AwsMarketplaceCppoOpportunityRule.md)
 - [AwsMarketplaceCppoOpportunityRuleType](docs/AwsMarketplaceCppoOpportunityRuleType.md)
 - [AwsMarketplaceCppoOpportunityTerm](docs/AwsMarketplaceCppoOpportunityTerm.md)
 - [AwsMarketplaceCppoOpportunityTermType](docs/AwsMarketplaceCppoOpportunityTermType.md)
 - [AwsMarketplaceCppoOpportunityUpfrontPriceGrant](docs/AwsMarketplaceCppoOpportunityUpfrontPriceGrant.md)
 - [AwsMarketplaceEventBridgeEventAccount](docs/AwsMarketplaceEventBridgeEventAccount.md)
 - [AwsMarketplaceEventBridgeEventDetail](docs/AwsMarketplaceEventBridgeEventDetail.md)
 - [AwsMarketplaceEventBridgeEventOffer](docs/AwsMarketplaceEventBridgeEventOffer.md)
 - [AwsMarketplaceEventBridgeEventProduct](docs/AwsMarketplaceEventBridgeEventProduct.md)
 - [AwsMarketplaceMeteringBatchMeterUsageInput](docs/AwsMarketplaceMeteringBatchMeterUsageInput.md)
 - [AwsMarketplaceMeteringTag](docs/AwsMarketplaceMeteringTag.md)
 - [AwsMarketplaceMeteringUsageAllocation](docs/AwsMarketplaceMeteringUsageAllocation.md)
 - [AwsMarketplaceMeteringUsageRecord](docs/AwsMarketplaceMeteringUsageRecord.md)
 - [AwsMarketplacePreExistingAgreement](docs/AwsMarketplacePreExistingAgreement.md)
 - [AwsMarketplaceProductVisibility](docs/AwsMarketplaceProductVisibility.md)
 - [AwsProduct](docs/AwsProduct.md)
 - [AwsProductAdditionalResource](docs/AwsProductAdditionalResource.md)
 - [AwsProductDeliveryOption](docs/AwsProductDeliveryOption.md)
 - [AwsProductDescription](docs/AwsProductDescription.md)
 - [AwsProductDimension](docs/AwsProductDimension.md)
 - [AwsProductPromotionalResources](docs/AwsProductPromotionalResources.md)
 - [AwsProductRepository](docs/AwsProductRepository.md)
 - [AwsProductSignatureVerificationKey](docs/AwsProductSignatureVerificationKey.md)
 - [AwsProductSupportInformation](docs/AwsProductSupportInformation.md)
 - [AwsProductVersion](docs/AwsProductVersion.md)
 - [AwsRenewalOfferType](docs/AwsRenewalOfferType.md)
 - [AwsSnsSubscription](docs/AwsSnsSubscription.md)
 - [AwsSnsSubscriptionStatus](docs/AwsSnsSubscriptionStatus.md)
 - [AzureADIdentifier](docs/AzureADIdentifier.md)
 - [AzureAudience](docs/AzureAudience.md)
 - [AzureCommercialMarketplaceSetup](docs/AzureCommercialMarketplaceSetup.md)
 - [AzureGovernmentCertification](docs/AzureGovernmentCertification.md)
 - [AzureIncludedBaseQuantity](docs/AzureIncludedBaseQuantity.md)
 - [AzureListingContact](docs/AzureListingContact.md)
 - [AzureListingUri](docs/AzureListingUri.md)
 - [AzureLocalizedDateTime](docs/AzureLocalizedDateTime.md)
 - [AzureLocalizedTimeRange](docs/AzureLocalizedTimeRange.md)
 - [AzureMarket](docs/AzureMarket.md)
 - [AzureMarketState](docs/AzureMarketState.md)
 - [AzureMarketplaceContact](docs/AzureMarketplaceContact.md)
 - [AzureMarketplaceCustomAmendment](docs/AzureMarketplaceCustomAmendment.md)
 - [AzureMarketplaceCustomAmendmentTenant](docs/AzureMarketplaceCustomAmendmentTenant.md)
 - [AzureMarketplaceCustomAmendmentTenantManualEntry](docs/AzureMarketplaceCustomAmendmentTenantManualEntry.md)
 - [AzureMarketplaceCustomerLeads](docs/AzureMarketplaceCustomerLeads.md)
 - [AzureMarketplaceDeprecationSchedule](docs/AzureMarketplaceDeprecationSchedule.md)
 - [AzureMarketplaceDeprecationScheduleAlternative](docs/AzureMarketplaceDeprecationScheduleAlternative.md)
 - [AzureMarketplaceGeneralLink](docs/AzureMarketplaceGeneralLink.md)
 - [AzureMarketplaceGovernmentCertification](docs/AzureMarketplaceGovernmentCertification.md)
 - [AzureMarketplaceIdentity](docs/AzureMarketplaceIdentity.md)
 - [AzureMarketplaceListing](docs/AzureMarketplaceListing.md)
 - [AzureMarketplaceListingAsset](docs/AzureMarketplaceListingAsset.md)
 - [AzureMarketplaceListingAssetType](docs/AzureMarketplaceListingAssetType.md)
 - [AzureMarketplaceMeteringBatchUsageEvent](docs/AzureMarketplaceMeteringBatchUsageEvent.md)
 - [AzureMarketplaceMeteringUsageEvent](docs/AzureMarketplaceMeteringUsageEvent.md)
 - [AzureMarketplaceOfferPricingType](docs/AzureMarketplaceOfferPricingType.md)
 - [AzureMarketplacePlan](docs/AzureMarketplacePlan.md)
 - [AzureMarketplacePlanListing](docs/AzureMarketplacePlanListing.md)
 - [AzureMarketplacePlanResource](docs/AzureMarketplacePlanResource.md)
 - [AzureMarketplacePreviewAudience](docs/AzureMarketplacePreviewAudience.md)
 - [AzureMarketplacePrice](docs/AzureMarketplacePrice.md)
 - [AzureMarketplacePriceAndAvailabilityAudience](docs/AzureMarketplacePriceAndAvailabilityAudience.md)
 - [AzureMarketplacePriceAndAvailabilityCorePrice](docs/AzureMarketplacePriceAndAvailabilityCorePrice.md)
 - [AzureMarketplacePriceAndAvailabilityCustomMeter](docs/AzureMarketplacePriceAndAvailabilityCustomMeter.md)
 - [AzureMarketplacePriceAndAvailabilityCustomMeterItem](docs/AzureMarketplacePriceAndAvailabilityCustomMeterItem.md)
 - [AzureMarketplacePriceAndAvailabilityCustomMeterPrice](docs/AzureMarketplacePriceAndAvailabilityCustomMeterPrice.md)
 - [AzureMarketplacePriceAndAvailabilityCustomMeterPriceIncludedQuantityItem](docs/AzureMarketplacePriceAndAvailabilityCustomMeterPriceIncludedQuantityItem.md)
 - [AzureMarketplacePriceAndAvailabilityCustomMeterPriceMeterItem](docs/AzureMarketplacePriceAndAvailabilityCustomMeterPriceMeterItem.md)
 - [AzureMarketplacePriceAndAvailabilityCustomMeterPriceMeterItemPriceItem](docs/AzureMarketplacePriceAndAvailabilityCustomMeterPriceMeterItemPriceItem.md)
 - [AzureMarketplacePriceAndAvailabilityOffer](docs/AzureMarketplacePriceAndAvailabilityOffer.md)
 - [AzureMarketplacePriceAndAvailabilityPlan](docs/AzureMarketplacePriceAndAvailabilityPlan.md)
 - [AzureMarketplacePriceAndAvailabilityPrice](docs/AzureMarketplacePriceAndAvailabilityPrice.md)
 - [AzureMarketplacePriceAndAvailabilityPrivateOfferCustomMeters](docs/AzureMarketplacePriceAndAvailabilityPrivateOfferCustomMeters.md)
 - [AzureMarketplacePriceAndAvailabilityPrivateOfferPlan](docs/AzureMarketplacePriceAndAvailabilityPrivateOfferPlan.md)
 - [AzureMarketplacePriceAndAvailabilityPrivateOfferPlanSoftwareReservation](docs/AzureMarketplacePriceAndAvailabilityPrivateOfferPlanSoftwareReservation.md)
 - [AzureMarketplacePriceAndAvailabilityPrivateOfferPrice](docs/AzureMarketplacePriceAndAvailabilityPrivateOfferPrice.md)
 - [AzureMarketplacePriceAndAvailabilityRecurrentPrice](docs/AzureMarketplacePriceAndAvailabilityRecurrentPrice.md)
 - [AzureMarketplacePriceAndAvailabilityRecurrentPriceItem](docs/AzureMarketplacePriceAndAvailabilityRecurrentPriceItem.md)
 - [AzureMarketplacePriceAndAvailabilityRecurrentPriceUserLimit](docs/AzureMarketplacePriceAndAvailabilityRecurrentPriceUserLimit.md)
 - [AzureMarketplacePriceAndAvailabilitySoftwareReservation](docs/AzureMarketplacePriceAndAvailabilitySoftwareReservation.md)
 - [AzureMarketplacePriceAndAvailabilitySystemMeterPrice](docs/AzureMarketplacePriceAndAvailabilitySystemMeterPrice.md)
 - [AzureMarketplacePrivateOffer](docs/AzureMarketplacePrivateOffer.md)
 - [AzureMarketplacePrivateOfferAcceptanceLink](docs/AzureMarketplacePrivateOfferAcceptanceLink.md)
 - [AzureMarketplacePrivateOfferBeneficiary](docs/AzureMarketplacePrivateOfferBeneficiary.md)
 - [AzureMarketplacePrivateOfferBeneficiaryRecipient](docs/AzureMarketplacePrivateOfferBeneficiaryRecipient.md)
 - [AzureMarketplacePrivateOfferPartner](docs/AzureMarketplacePrivateOfferPartner.md)
 - [AzureMarketplacePrivateOfferPricing](docs/AzureMarketplacePrivateOfferPricing.md)
 - [AzureMarketplacePrivateOfferPricingNewPlanDetails](docs/AzureMarketplacePrivateOfferPricingNewPlanDetails.md)
 - [AzureMarketplacePrivateOfferPromotionReference](docs/AzureMarketplacePrivateOfferPromotionReference.md)
 - [AzureMarketplacePrivateOfferState](docs/AzureMarketplacePrivateOfferState.md)
 - [AzureMarketplacePrivateOfferSubState](docs/AzureMarketplacePrivateOfferSubState.md)
 - [AzureMarketplacePrivateOfferTermsDoc](docs/AzureMarketplacePrivateOfferTermsDoc.md)
 - [AzureMarketplacePrivateOfferType](docs/AzureMarketplacePrivateOfferType.md)
 - [AzureMarketplaceProduct](docs/AzureMarketplaceProduct.md)
 - [AzureMarketplaceProductResource](docs/AzureMarketplaceProductResource.md)
 - [AzureMarketplaceProductType](docs/AzureMarketplaceProductType.md)
 - [AzureMarketplaceProperty](docs/AzureMarketplaceProperty.md)
 - [AzureMarketplaceReseller](docs/AzureMarketplaceReseller.md)
 - [AzureMarketplaceResourceLifecycleState](docs/AzureMarketplaceResourceLifecycleState.md)
 - [AzureMarketplaceResourceTarget](docs/AzureMarketplaceResourceTarget.md)
 - [AzureMarketplaceSaasTechnicalConfiguration](docs/AzureMarketplaceSaasTechnicalConfiguration.md)
 - [AzureMarketplaceSubmission](docs/AzureMarketplaceSubmission.md)
 - [AzureMarketplaceSubscription](docs/AzureMarketplaceSubscription.md)
 - [AzureMarketplaceSubscriptionStatus](docs/AzureMarketplaceSubscriptionStatus.md)
 - [AzureMarketplaceTerm](docs/AzureMarketplaceTerm.md)
 - [AzureMarketplaceValidation](docs/AzureMarketplaceValidation.md)
 - [AzureMarketplaceVmPrice](docs/AzureMarketplaceVmPrice.md)
 - [AzureMarketplaceVmPricePropertyItem](docs/AzureMarketplaceVmPricePropertyItem.md)
 - [AzurePendingUpdateInfo](docs/AzurePendingUpdateInfo.md)
 - [AzurePrice](docs/AzurePrice.md)
 - [AzurePriceCadence](docs/AzurePriceCadence.md)
 - [AzurePriceSchedule](docs/AzurePriceSchedule.md)
 - [AzurePricingUnit](docs/AzurePricingUnit.md)
 - [AzureProduct](docs/AzureProduct.md)
 - [AzureProductAvailability](docs/AzureProductAvailability.md)
 - [AzureProductBranch](docs/AzureProductBranch.md)
 - [AzureProductFeatureAvailability](docs/AzureProductFeatureAvailability.md)
 - [AzureProductListing](docs/AzureProductListing.md)
 - [AzureProductListingAsset](docs/AzureProductListingAsset.md)
 - [AzureProductPackageConfiguration](docs/AzureProductPackageConfiguration.md)
 - [AzureProductProperty](docs/AzureProductProperty.md)
 - [AzureProductSetup](docs/AzureProductSetup.md)
 - [AzureProductSubmission](docs/AzureProductSubmission.md)
 - [AzureProductVariant](docs/AzureProductVariant.md)
 - [AzureProductVariantCustomMeter](docs/AzureProductVariantCustomMeter.md)
 - [AzureProductVariantPriceSchedule](docs/AzureProductVariantPriceSchedule.md)
 - [AzureProductVariantTrial](docs/AzureProductVariantTrial.md)
 - [AzureTerm](docs/AzureTerm.md)
 - [AzureTypeValue](docs/AzureTypeValue.md)
 - [AzureValidationResult](docs/AzureValidationResult.md)
 - [AzureVariantResource](docs/AzureVariantResource.md)
 - [BillableDimension](docs/BillableDimension.md)
 - [BillableDimensionFeeDetail](docs/BillableDimensionFeeDetail.md)
 - [BillableDimensionPriceModelDetail](docs/BillableDimensionPriceModelDetail.md)
 - [BillableDimensionUsageDailyRevenue](docs/BillableDimensionUsageDailyRevenue.md)
 - [BillableMetric](docs/BillableMetric.md)
 - [BillableMetricAggregationType](docs/BillableMetricAggregationType.md)
 - [BillableMetricFilter](docs/BillableMetricFilter.md)
 - [BillableMetricFilterGroup](docs/BillableMetricFilterGroup.md)
 - [BillableMetricFilterOperation](docs/BillableMetricFilterOperation.md)
 - [BillableMetricFilterValueType](docs/BillableMetricFilterValueType.md)
 - [BillableMetricInfo](docs/BillableMetricInfo.md)
 - [BillableMetricStatus](docs/BillableMetricStatus.md)
 - [BillingAddon](docs/BillingAddon.md)
 - [BillingAddonInfo](docs/BillingAddonInfo.md)
 - [BillingAddonRecord](docs/BillingAddonRecord.md)
 - [BillingAddonStatus](docs/BillingAddonStatus.md)
 - [BillingCycle](docs/BillingCycle.md)
 - [BillingDiscount](docs/BillingDiscount.md)
 - [BillingDiscountType](docs/BillingDiscountType.md)
 - [BillingInvoice](docs/BillingInvoice.md)
 - [BillingInvoiceInfo](docs/BillingInvoiceInfo.md)
 - [BillingInvoiceStatus](docs/BillingInvoiceStatus.md)
 - [BillingInvoiceType](docs/BillingInvoiceType.md)
 - [BillingMinimumCommitScope](docs/BillingMinimumCommitScope.md)
 - [BillingPaymentInstallmentDetail](docs/BillingPaymentInstallmentDetail.md)
 - [BillingPaymentStatus](docs/BillingPaymentStatus.md)
 - [BillingPaymentTransaction](docs/BillingPaymentTransaction.md)
 - [BillingPaymentTransactionInfo](docs/BillingPaymentTransactionInfo.md)
 - [BillingPaymentTransactionType](docs/BillingPaymentTransactionType.md)
 - [BillingWallet](docs/BillingWallet.md)
 - [BillingWalletInfo](docs/BillingWalletInfo.md)
 - [BillingWalletStatus](docs/BillingWalletStatus.md)
 - [BillingWalletType](docs/BillingWalletType.md)
 - [BuyerInfo](docs/BuyerInfo.md)
 - [CancellationSchedule](docs/CancellationSchedule.md)
 - [CancellationScheduleType](docs/CancellationScheduleType.md)
 - [ClientDescribeInstanceResponseBody](docs/ClientDescribeInstanceResponseBody.md)
 - [ClientDescribeInstanceResponseBodyModules](docs/ClientDescribeInstanceResponseBodyModules.md)
 - [ClientDescribeInstanceResponseBodyModulesModule](docs/ClientDescribeInstanceResponseBodyModulesModule.md)
 - [ClientDescribeInstanceResponseBodyModulesModuleProperties](docs/ClientDescribeInstanceResponseBodyModulesModuleProperties.md)
 - [ClientDescribeInstanceResponseBodyModulesModulePropertiesProperty](docs/ClientDescribeInstanceResponseBodyModulesModulePropertiesProperty.md)
 - [ClientDescribeInstanceResponseBodyModulesModulePropertiesPropertyPropertyValues](docs/ClientDescribeInstanceResponseBodyModulesModulePropertiesPropertyPropertyValues.md)
 - [ClientDescribeInstanceResponseBodyModulesModulePropertiesPropertyPropertyValuesPropertyValue](docs/ClientDescribeInstanceResponseBodyModulesModulePropertiesPropertyPropertyValuesPropertyValue.md)
 - [ClientDescribeInstanceResponseBodyRelationalData](docs/ClientDescribeInstanceResponseBodyRelationalData.md)
 - [ClientDescribeOrderResponseBody](docs/ClientDescribeOrderResponseBody.md)
 - [ClientDescribeOrderResponseBodyInstanceIds](docs/ClientDescribeOrderResponseBodyInstanceIds.md)
 - [ClientDescribeOrderResponseBodySupplierTelephones](docs/ClientDescribeOrderResponseBodySupplierTelephones.md)
 - [ClientPushMeteringDataRequest](docs/ClientPushMeteringDataRequest.md)
 - [ClientPushMeteringDataResponseBody](docs/ClientPushMeteringDataResponseBody.md)
 - [CommitDimension](docs/CommitDimension.md)
 - [CommitDimensionType](docs/CommitDimensionType.md)
 - [CommitRevenueDetail](docs/CommitRevenueDetail.md)
 - [CompanyInfo](docs/CompanyInfo.md)
 - [Contact](docs/Contact.md)
 - [CreateAndUpdateAddonParams](docs/CreateAndUpdateAddonParams.md)
 - [CreateBuyerParams](docs/CreateBuyerParams.md)
 - [CreateEntitlementParams](docs/CreateEntitlementParams.md)
 - [CreateUsageRecordGroupParams](docs/CreateUsageRecordGroupParams.md)
 - [DatabaseSqlNullTime](docs/DatabaseSqlNullTime.md)
 - [DivideEntitlementCommitParams](docs/DivideEntitlementCommitParams.md)
 - [EntitlementInfo](docs/EntitlementInfo.md)
 - [EntitlementStatus](docs/EntitlementStatus.md)
 - [EntitlementTermInfo](docs/EntitlementTermInfo.md)
 - [EntitlementTermType](docs/EntitlementTermType.md)
 - [EntityType](docs/EntityType.md)
 - [EulaType](docs/EulaType.md)
 - [GcpAmountConstraint](docs/GcpAmountConstraint.md)
 - [GcpAmountUnit](docs/GcpAmountUnit.md)
 - [GcpCommitmentAmountPerPeriodTemplate](docs/GcpCommitmentAmountPerPeriodTemplate.md)
 - [GcpMarketplaceConsumer](docs/GcpMarketplaceConsumer.md)
 - [GcpMarketplaceDocument](docs/GcpMarketplaceDocument.md)
 - [GcpMarketplaceEntitlement](docs/GcpMarketplaceEntitlement.md)
 - [GcpMarketplaceEntitlementState](docs/GcpMarketplaceEntitlementState.md)
 - [GcpMarketplaceExistingOfferData](docs/GcpMarketplaceExistingOfferData.md)
 - [GcpMarketplaceExistingPrivateOffer](docs/GcpMarketplaceExistingPrivateOffer.md)
 - [GcpMarketplaceExternalGoogleLink](docs/GcpMarketplaceExternalGoogleLink.md)
 - [GcpMarketplaceIsvInfo](docs/GcpMarketplaceIsvInfo.md)
 - [GcpMarketplaceMeteringMetricValue](docs/GcpMarketplaceMeteringMetricValue.md)
 - [GcpMarketplaceMeteringMetricValueSet](docs/GcpMarketplaceMeteringMetricValueSet.md)
 - [GcpMarketplaceMeteringMoney](docs/GcpMarketplaceMeteringMoney.md)
 - [GcpMarketplaceMeteringOperation](docs/GcpMarketplaceMeteringOperation.md)
 - [GcpMarketplaceOfferProration](docs/GcpMarketplaceOfferProration.md)
 - [GcpMarketplaceOfferStartPolicy](docs/GcpMarketplaceOfferStartPolicy.md)
 - [GcpMarketplaceOfferTemplatePolicies](docs/GcpMarketplaceOfferTemplatePolicies.md)
 - [GcpMarketplacePriceModel](docs/GcpMarketplacePriceModel.md)
 - [GcpMarketplacePrivateOffer](docs/GcpMarketplacePrivateOffer.md)
 - [GcpMarketplacePrivateOfferCustomerInfo](docs/GcpMarketplacePrivateOfferCustomerInfo.md)
 - [GcpMarketplacePrivateOfferInstallment](docs/GcpMarketplacePrivateOfferInstallment.md)
 - [GcpMarketplacePrivateOfferInstallmentTimeline](docs/GcpMarketplacePrivateOfferInstallmentTimeline.md)
 - [GcpMarketplacePrivateOfferMetricDetail](docs/GcpMarketplacePrivateOfferMetricDetail.md)
 - [GcpMarketplacePrivateOfferMetricInformation](docs/GcpMarketplacePrivateOfferMetricInformation.md)
 - [GcpMarketplacePrivateOfferMigrationMetadata](docs/GcpMarketplacePrivateOfferMigrationMetadata.md)
 - [GcpMarketplacePrivateOfferPriceModel](docs/GcpMarketplacePrivateOfferPriceModel.md)
 - [GcpMarketplacePrivateOfferPriceModelCommitment](docs/GcpMarketplacePrivateOfferPriceModelCommitment.md)
 - [GcpMarketplacePrivateOfferPriceModelDiscount](docs/GcpMarketplacePrivateOfferPriceModelDiscount.md)
 - [GcpMarketplacePrivateOfferPriceModelFixed](docs/GcpMarketplacePrivateOfferPriceModelFixed.md)
 - [GcpMarketplacePrivateOfferPriceModelOverage](docs/GcpMarketplacePrivateOfferPriceModelOverage.md)
 - [GcpMarketplacePrivateOfferPriceModelPayg](docs/GcpMarketplacePrivateOfferPriceModelPayg.md)
 - [GcpMarketplacePrivateOfferPriceModelType](docs/GcpMarketplacePrivateOfferPriceModelType.md)
 - [GcpMarketplacePrivateOfferProviderInfo](docs/GcpMarketplacePrivateOfferProviderInfo.md)
 - [GcpMarketplacePrivateOfferReplacementMetadata](docs/GcpMarketplacePrivateOfferReplacementMetadata.md)
 - [GcpMarketplacePrivateOfferState](docs/GcpMarketplacePrivateOfferState.md)
 - [GcpMarketplacePrivateOfferTerm](docs/GcpMarketplacePrivateOfferTerm.md)
 - [GcpMarketplacePrivateOfferTermDurationConstraint](docs/GcpMarketplacePrivateOfferTermDurationConstraint.md)
 - [GcpMarketplacePrivateOfferTermTemplate](docs/GcpMarketplacePrivateOfferTermTemplate.md)
 - [GcpMarketplaceProduct](docs/GcpMarketplaceProduct.md)
 - [GcpMarketplaceProductAccessState](docs/GcpMarketplaceProductAccessState.md)
 - [GcpMarketplaceProductDerivedDiscoveryState](docs/GcpMarketplaceProductDerivedDiscoveryState.md)
 - [GcpMarketplaceProductDocumentationSpec](docs/GcpMarketplaceProductDocumentationSpec.md)
 - [GcpMarketplaceProductExternalAccountSpec](docs/GcpMarketplaceProductExternalAccountSpec.md)
 - [GcpMarketplaceProductFeature](docs/GcpMarketplaceProductFeature.md)
 - [GcpMarketplaceProductFeatureValue](docs/GcpMarketplaceProductFeatureValue.md)
 - [GcpMarketplaceProductInfo](docs/GcpMarketplaceProductInfo.md)
 - [GcpMarketplaceProductLicenseSpec](docs/GcpMarketplaceProductLicenseSpec.md)
 - [GcpMarketplaceProductListingSpec](docs/GcpMarketplaceProductListingSpec.md)
 - [GcpMarketplaceProductMarketingSpec](docs/GcpMarketplaceProductMarketingSpec.md)
 - [GcpMarketplaceProductMeteringMetric](docs/GcpMarketplaceProductMeteringMetric.md)
 - [GcpMarketplaceProductPriceInfo](docs/GcpMarketplaceProductPriceInfo.md)
 - [GcpMarketplaceProductPurchaseOptionSpec](docs/GcpMarketplaceProductPurchaseOptionSpec.md)
 - [GcpMarketplaceProductPurchaseSpec](docs/GcpMarketplaceProductPurchaseSpec.md)
 - [GcpMarketplaceProductServiceConfig](docs/GcpMarketplaceProductServiceConfig.md)
 - [GcpMarketplaceProductServiceConfigBilling](docs/GcpMarketplaceProductServiceConfigBilling.md)
 - [GcpMarketplaceProductSubscriptionPlan](docs/GcpMarketplaceProductSubscriptionPlan.md)
 - [GcpMarketplaceProductSupportSpec](docs/GcpMarketplaceProductSupportSpec.md)
 - [GcpMarketplaceProductTermsSpec](docs/GcpMarketplaceProductTermsSpec.md)
 - [GcpMarketplaceProductUsageFee](docs/GcpMarketplaceProductUsageFee.md)
 - [GcpMarketplacePurchaseChannel](docs/GcpMarketplacePurchaseChannel.md)
 - [GcpMarketplaceResellerInfo](docs/GcpMarketplaceResellerInfo.md)
 - [GcpMarketplaceResellerPrivateOfferPlan](docs/GcpMarketplaceResellerPrivateOfferPlan.md)
 - [GcpMarketplaceResellerPrivateOfferPlanAgreementDocuments](docs/GcpMarketplaceResellerPrivateOfferPlanAgreementDocuments.md)
 - [GcpMarketplaceResellerPrivateOfferPlanDurationConfig](docs/GcpMarketplaceResellerPrivateOfferPlanDurationConfig.md)
 - [GcpMarketplaceResellerPrivateOfferPlanInstallmentTemplate](docs/GcpMarketplaceResellerPrivateOfferPlanInstallmentTemplate.md)
 - [GcpMarketplaceResellerPrivateOfferPlanInstallmentTimelineTemplate](docs/GcpMarketplaceResellerPrivateOfferPlanInstallmentTimelineTemplate.md)
 - [GcpMarketplaceResellerPrivateOfferPlanMargin](docs/GcpMarketplaceResellerPrivateOfferPlanMargin.md)
 - [GcpMarketplaceResellerPrivateOfferPlanMarginPercentage](docs/GcpMarketplaceResellerPrivateOfferPlanMarginPercentage.md)
 - [GcpMarketplaceResellerPrivateOfferPlanMetainfo](docs/GcpMarketplaceResellerPrivateOfferPlanMetainfo.md)
 - [GcpMarketplaceResellerPrivateOfferPlanNewState](docs/GcpMarketplaceResellerPrivateOfferPlanNewState.md)
 - [GcpMarketplaceResellerPrivateOfferPlanPriceModelSkuList](docs/GcpMarketplaceResellerPrivateOfferPlanPriceModelSkuList.md)
 - [GcpMarketplaceResellerPrivateOfferPlanPriceModelSkuRepresentation](docs/GcpMarketplaceResellerPrivateOfferPlanPriceModelSkuRepresentation.md)
 - [GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplate](docs/GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplate.md)
 - [GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateCommitment](docs/GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateCommitment.md)
 - [GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateFixedPrice](docs/GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateFixedPrice.md)
 - [GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateOverage](docs/GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateOverage.md)
 - [GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplatePayg](docs/GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplatePayg.md)
 - [GcpMarketplaceResellerPrivateOfferPlanReusePolicy](docs/GcpMarketplaceResellerPrivateOfferPlanReusePolicy.md)
 - [GcpMarketplaceResellerPrivateOfferPlanState](docs/GcpMarketplaceResellerPrivateOfferPlanState.md)
 - [GcpMarketplaceResellerPrivateOfferPlanStateTransition](docs/GcpMarketplaceResellerPrivateOfferPlanStateTransition.md)
 - [GcpMarketplaceResellerPrivateOfferPlanStateType](docs/GcpMarketplaceResellerPrivateOfferPlanStateType.md)
 - [GcpMarketplaceStartPolicy](docs/GcpMarketplaceStartPolicy.md)
 - [GcpMarketplaceUnstructuredDocument](docs/GcpMarketplaceUnstructuredDocument.md)
 - [GcpMarketplaceUsagePlanPriceModel](docs/GcpMarketplaceUsagePlanPriceModel.md)
 - [GcpMarketplaceUserAccount](docs/GcpMarketplaceUserAccount.md)
 - [GcpMarketplaceUserAccountApproval](docs/GcpMarketplaceUserAccountApproval.md)
 - [GcpMarketplaceUserAccountApprovalState](docs/GcpMarketplaceUserAccountApprovalState.md)
 - [GcpMarketplaceUserAccountState](docs/GcpMarketplaceUserAccountState.md)
 - [GcpPeriodDuration](docs/GcpPeriodDuration.md)
 - [GcpPeriodDurationUnit](docs/GcpPeriodDurationUnit.md)
 - [GcpPriceModelDiscountTemplate](docs/GcpPriceModelDiscountTemplate.md)
 - [GcpPriceTier](docs/GcpPriceTier.md)
 - [GcpPriceValue](docs/GcpPriceValue.md)
 - [GcpUserInfo](docs/GcpUserInfo.md)
 - [GetApiClientAccessTokenParams](docs/GetApiClientAccessTokenParams.md)
 - [GetRevenueReportParams](docs/GetRevenueReportParams.md)
 - [GithubComAwsAwsSdkGoV2ServiceMarketplacemeteringTypesTag](docs/GithubComAwsAwsSdkGoV2ServiceMarketplacemeteringTypesTag.md)
 - [GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1BatchUsageEventOkResponse](docs/GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1BatchUsageEventOkResponse.md)
 - [GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageBatchEventOkMessage](docs/GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageBatchEventOkMessage.md)
 - [GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventConflictResponse](docs/GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventConflictResponse.md)
 - [GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventConflictResponseAdditionalInfo](docs/GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventConflictResponseAdditionalInfo.md)
 - [GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventOkResponse](docs/GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventOkResponse.md)
 - [GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventStatusEnum](docs/GithubComSugerioMarketplaceServiceAzureSdkMarketplacemeteringv1UsageEventStatusEnum.md)
 - [GithubComSugerioMarketplaceServiceRdsDbLibBillingAwsBillingEvent](docs/GithubComSugerioMarketplaceServiceRdsDbLibBillingAwsBillingEvent.md)
 - [GithubComSugerioMarketplaceServiceRdsDbLibBillingAzureCmaRevenue](docs/GithubComSugerioMarketplaceServiceRdsDbLibBillingAzureCmaRevenue.md)
 - [GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage](docs/GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage.md)
 - [GithubComSugerioMarketplaceServiceRdsDbLibIdentityApiClient](docs/GithubComSugerioMarketplaceServiceRdsDbLibIdentityApiClient.md)
 - [GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams](docs/GithubComSugerioMarketplaceServiceRdsDbLibUpdateEntitlementNameParams.md)
 - [IdentityBuyer](docs/IdentityBuyer.md)
 - [IdentityConctactInfo](docs/IdentityConctactInfo.md)
 - [IdentityContact](docs/IdentityContact.md)
 - [InvoiceAddFixedFee](docs/InvoiceAddFixedFee.md)
 - [InvoiceAdjustDiscountByDimension](docs/InvoiceAdjustDiscountByDimension.md)
 - [InvoiceAdjustMinimumSpendByDimension](docs/InvoiceAdjustMinimumSpendByDimension.md)
 - [InvoiceAdjustOverallDiscount](docs/InvoiceAdjustOverallDiscount.md)
 - [InvoiceAdjustOverallMinimumSpend](docs/InvoiceAdjustOverallMinimumSpend.md)
 - [LastModifiedBy](docs/LastModifiedBy.md)
 - [ListNotificationEventsResponse](docs/ListNotificationEventsResponse.md)
 - [ListNotificationMessagesResponse](docs/ListNotificationMessagesResponse.md)
 - [ListRevenueRecordDetailsResponse](docs/ListRevenueRecordDetailsResponse.md)
 - [ListRevenueRecordsResponse](docs/ListRevenueRecordsResponse.md)
 - [ListSupportTicketsResponse](docs/ListSupportTicketsResponse.md)
 - [ListUsageMeteringDailyRecordsResponse](docs/ListUsageMeteringDailyRecordsResponse.md)
 - [ListUsageRecordGroupsResponse](docs/ListUsageRecordGroupsResponse.md)
 - [ListUsageRecordReportsResponse](docs/ListUsageRecordReportsResponse.md)
 - [MarketplacemeteringBatchMeterUsageOutput](docs/MarketplacemeteringBatchMeterUsageOutput.md)
 - [MeteringDimension](docs/MeteringDimension.md)
 - [MeteringUsageRecord](docs/MeteringUsageRecord.md)
 - [MeteringUsageRecordGroup](docs/MeteringUsageRecordGroup.md)
 - [MeteringUsageRecordGroupByKey](docs/MeteringUsageRecordGroupByKey.md)
 - [MeteringUsageRecordGroupMetaInfo](docs/MeteringUsageRecordGroupMetaInfo.md)
 - [MeteringUsageRecordReport](docs/MeteringUsageRecordReport.md)
 - [MeteringUsageRecordReportInfo](docs/MeteringUsageRecordReportInfo.md)
 - [NewUsageRecordGroup](docs/NewUsageRecordGroup.md)
 - [NotificationChannel](docs/NotificationChannel.md)
 - [NotificationEvent](docs/NotificationEvent.md)
 - [NotificationEventAction](docs/NotificationEventAction.md)
 - [NotificationEventStatus](docs/NotificationEventStatus.md)
 - [NotificationMessage](docs/NotificationMessage.md)
 - [NotificationMessageInfo](docs/NotificationMessageInfo.md)
 - [OfferInfo](docs/OfferInfo.md)
 - [OfferStatus](docs/OfferStatus.md)
 - [OfferType](docs/OfferType.md)
 - [Partner](docs/Partner.md)
 - [PartnerService](docs/PartnerService.md)
 - [PartnerUsageMeteringConfig](docs/PartnerUsageMeteringConfig.md)
 - [PaymentConfig](docs/PaymentConfig.md)
 - [PaymentInstallment](docs/PaymentInstallment.md)
 - [PaymentScheduleType](docs/PaymentScheduleType.md)
 - [PriceModelBasic](docs/PriceModelBasic.md)
 - [PriceModelBulk](docs/PriceModelBulk.md)
 - [PriceModelCategory](docs/PriceModelCategory.md)
 - [PriceModelMatrix](docs/PriceModelMatrix.md)
 - [PriceModelMatrixConfigGroup](docs/PriceModelMatrixConfigGroup.md)
 - [PriceModelMatrixProperty](docs/PriceModelMatrixProperty.md)
 - [PriceModelPercentage](docs/PriceModelPercentage.md)
 - [PriceModelTiered](docs/PriceModelTiered.md)
 - [PriceModelTieredConfig](docs/PriceModelTieredConfig.md)
 - [PriceModelTieredPercentage](docs/PriceModelTieredPercentage.md)
 - [PriceModelTieredPercentageConfig](docs/PriceModelTieredPercentageConfig.md)
 - [PriceModelVolume](docs/PriceModelVolume.md)
 - [PriceModelVolumeConfig](docs/PriceModelVolumeConfig.md)
 - [PrivateOfferDiscountType](docs/PrivateOfferDiscountType.md)
 - [ProductInfo](docs/ProductInfo.md)
 - [RevenueRecord](docs/RevenueRecord.md)
 - [RevenueRecordDetail](docs/RevenueRecordDetail.md)
 - [RevenueRecordInfo](docs/RevenueRecordInfo.md)
 - [RevenueReport](docs/RevenueReport.md)
 - [RevenueReportType](docs/RevenueReportType.md)
 - [ServicecontrolReportError](docs/ServicecontrolReportError.md)
 - [ServicecontrolReportResponse](docs/ServicecontrolReportResponse.md)
 - [ServicecontrolStatus](docs/ServicecontrolStatus.md)
 - [StripeBalanceTransaction](docs/StripeBalanceTransaction.md)
 - [StripeBalanceTransactionFeeDetail](docs/StripeBalanceTransactionFeeDetail.md)
 - [StripeCustomer](docs/StripeCustomer.md)
 - [StripeCustomerAddress](docs/StripeCustomerAddress.md)
 - [StripeDispute](docs/StripeDispute.md)
 - [StripeError](docs/StripeError.md)
 - [StripePaymentIntent](docs/StripePaymentIntent.md)
 - [StripePaymentIntentStatus](docs/StripePaymentIntentStatus.md)
 - [StripePaymentMethod](docs/StripePaymentMethod.md)
 - [StripePaymentMethodBACSDebit](docs/StripePaymentMethodBACSDebit.md)
 - [StripePaymentMethodCard](docs/StripePaymentMethodCard.md)
 - [StripePaymentMethodSEPADebit](docs/StripePaymentMethodSEPADebit.md)
 - [StripePaymentMethodUSBankAccount](docs/StripePaymentMethodUSBankAccount.md)
 - [StripeProduct](docs/StripeProduct.md)
 - [StripeProductMarketingFeature](docs/StripeProductMarketingFeature.md)
 - [StripeProductPackageDimensions](docs/StripeProductPackageDimensions.md)
 - [StripeRefund](docs/StripeRefund.md)
 - [StripeRefundDestinationDetails](docs/StripeRefundDestinationDetails.md)
 - [StripeRefundDestinationDetailsCard](docs/StripeRefundDestinationDetailsCard.md)
 - [StripeRefundDestinationDetailsUSBankTransfer](docs/StripeRefundDestinationDetailsUSBankTransfer.md)
 - [StripeRefundStatus](docs/StripeRefundStatus.md)
 - [SupportTicket](docs/SupportTicket.md)
 - [SupportTicketAttachment](docs/SupportTicketAttachment.md)
 - [SupportTicketComment](docs/SupportTicketComment.md)
 - [SupportTicketCommentDetail](docs/SupportTicketCommentDetail.md)
 - [SupportTicketFrame](docs/SupportTicketFrame.md)
 - [SupportTicketImage](docs/SupportTicketImage.md)
 - [SupportTicketPriority](docs/SupportTicketPriority.md)
 - [SupportTicketStatus](docs/SupportTicketStatus.md)
 - [SupportTicketUser](docs/SupportTicketUser.md)
 - [TimeUnit](docs/TimeUnit.md)
 - [TrackEvent](docs/TrackEvent.md)
 - [TrackEventActionType](docs/TrackEventActionType.md)
 - [TrialConfig](docs/TrialConfig.md)
 - [TypesEntitlement](docs/TypesEntitlement.md)
 - [TypesEntitlementValue](docs/TypesEntitlementValue.md)
 - [TypesUsageAllocation](docs/TypesUsageAllocation.md)
 - [TypesUsageRecord](docs/TypesUsageRecord.md)
 - [TypesUsageRecordResult](docs/TypesUsageRecordResult.md)
 - [TypesUsageRecordResultStatus](docs/TypesUsageRecordResultStatus.md)
 - [UniqueCountAggregationResult](docs/UniqueCountAggregationResult.md)
 - [UpdateBillableMetricParams](docs/UpdateBillableMetricParams.md)
 - [UpdateBuyerParams](docs/UpdateBuyerParams.md)
 - [UpdateProductParams](docs/UpdateProductParams.md)
 - [UpdateSupportTicketRequest](docs/UpdateSupportTicketRequest.md)
 - [UsageCount](docs/UsageCount.md)
 - [UsageMeteringConfigInfo](docs/UsageMeteringConfigInfo.md)
 - [UsageMeteringDailyRecord](docs/UsageMeteringDailyRecord.md)
 - [UsageMeteringDimensionMappingMode](docs/UsageMeteringDimensionMappingMode.md)
 - [UsageMeteringDimensionMappingValue](docs/UsageMeteringDimensionMappingValue.md)
 - [UsageRecordGroupSource](docs/UsageRecordGroupSource.md)
 - [UsageRecordReportStatus](docs/UsageRecordReportStatus.md)
 - [ValueType](docs/ValueType.md)
 - [WorkloadEntitlement](docs/WorkloadEntitlement.md)
 - [WorkloadEntitlementTerm](docs/WorkloadEntitlementTerm.md)
 - [WorkloadMetaInfo](docs/WorkloadMetaInfo.md)
 - [WorkloadOffer](docs/WorkloadOffer.md)
 - [WorkloadProduct](docs/WorkloadProduct.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="APIKeyAuth"></a>
### APIKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@suger.io


