# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from suger_sdk_python.models.get_revenue_report_params import GetRevenueReportParams
from suger_sdk_python.models.list_revenue_record_details_response import ListRevenueRecordDetailsResponse
from suger_sdk_python.models.list_revenue_records_response import ListRevenueRecordsResponse
from suger_sdk_python.models.list_usage_metering_daily_records_response import ListUsageMeteringDailyRecordsResponse
from suger_sdk_python.models.revenue_record import RevenueRecord
from suger_sdk_python.models.revenue_report import RevenueReport

from suger_sdk_python.api_client import ApiClient, RequestSerialized
from suger_sdk_python.api_response import ApiResponse
from suger_sdk_python.rest import RESTResponseType


class ReportApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_revenue_report(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        data: Annotated[GetRevenueReportParams, Field(description="Get Revenue Report Params")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RevenueReport:
        """get revenue report

        Get the revenue report of the given organization, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param data: Get Revenue Report Params (required)
        :type data: GetRevenueReportParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_revenue_report_serialize(
            org_id=org_id,
            data=data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RevenueReport",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_revenue_report_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        data: Annotated[GetRevenueReportParams, Field(description="Get Revenue Report Params")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RevenueReport]:
        """get revenue report

        Get the revenue report of the given organization, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param data: Get Revenue Report Params (required)
        :type data: GetRevenueReportParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_revenue_report_serialize(
            org_id=org_id,
            data=data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RevenueReport",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_revenue_report_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        data: Annotated[GetRevenueReportParams, Field(description="Get Revenue Report Params")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get revenue report

        Get the revenue report of the given organization, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param data: Get Revenue Report Params (required)
        :type data: GetRevenueReportParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_revenue_report_serialize(
            org_id=org_id,
            data=data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RevenueReport",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_revenue_report_serialize(
        self,
        org_id,
        data,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_id is not None:
            _path_params['orgId'] = org_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if data is not None:
            _body_params = data


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/org/{orgId}/revenueReport',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_daily_revenue_records(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[Optional[StrictStr], Field(description="Cloud Partner")] = None,
        product_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given product ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RevenueRecord]:
        """list daily revenue records

        list daily revenue records for the given organization, partner, entitlement, or buyer, within the given date range.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner
        :type partner: str
        :param product_id: Filter daily revenue records by the given product ID
        :type product_id: str
        :param buyer_id: Filter daily revenue records by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter daily revenue records by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_daily_revenue_records_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RevenueRecord]",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_daily_revenue_records_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[Optional[StrictStr], Field(description="Cloud Partner")] = None,
        product_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given product ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RevenueRecord]]:
        """list daily revenue records

        list daily revenue records for the given organization, partner, entitlement, or buyer, within the given date range.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner
        :type partner: str
        :param product_id: Filter daily revenue records by the given product ID
        :type product_id: str
        :param buyer_id: Filter daily revenue records by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter daily revenue records by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_daily_revenue_records_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RevenueRecord]",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_daily_revenue_records_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[Optional[StrictStr], Field(description="Cloud Partner")] = None,
        product_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given product ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter daily revenue records by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """list daily revenue records

        list daily revenue records for the given organization, partner, entitlement, or buyer, within the given date range.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner
        :type partner: str
        :param product_id: Filter daily revenue records by the given product ID
        :type product_id: str
        :param buyer_id: Filter daily revenue records by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter daily revenue records by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_daily_revenue_records_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RevenueRecord]",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_daily_revenue_records_serialize(
        self,
        org_id,
        partner,
        product_id,
        buyer_id,
        entitlement_id,
        start_date,
        end_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_id is not None:
            _path_params['orgId'] = org_id
        # process the query parameters
        if partner is not None:
            
            _query_params.append(('partner', partner))
            
        if product_id is not None:
            
            _query_params.append(('productId', product_id))
            
        if buyer_id is not None:
            
            _query_params.append(('buyerId', buyer_id))
            
        if entitlement_id is not None:
            
            _query_params.append(('entitlementId', entitlement_id))
            
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/org/{orgId}/dailyRevenueRecord',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_revenue_record_details(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Cloud Partner")],
        product_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given product ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListRevenueRecordDetailsResponse:
        """list revenue record details

        list the raw revenue record details for the given organization, partner, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner (required)
        :type partner: str
        :param product_id: Filter revenue record details by the given product ID
        :type product_id: str
        :param buyer_id: Filter revenue record details by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter revenue record details by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_revenue_record_details_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRevenueRecordDetailsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_revenue_record_details_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Cloud Partner")],
        product_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given product ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListRevenueRecordDetailsResponse]:
        """list revenue record details

        list the raw revenue record details for the given organization, partner, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner (required)
        :type partner: str
        :param product_id: Filter revenue record details by the given product ID
        :type product_id: str
        :param buyer_id: Filter revenue record details by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter revenue record details by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_revenue_record_details_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRevenueRecordDetailsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_revenue_record_details_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Cloud Partner")],
        product_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given product ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter revenue record details by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """list revenue record details

        list the raw revenue record details for the given organization, partner, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner (required)
        :type partner: str
        :param product_id: Filter revenue record details by the given product ID
        :type product_id: str
        :param buyer_id: Filter revenue record details by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter revenue record details by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_revenue_record_details_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRevenueRecordDetailsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_revenue_record_details_serialize(
        self,
        org_id,
        partner,
        product_id,
        buyer_id,
        entitlement_id,
        start_date,
        end_date,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_id is not None:
            _path_params['orgId'] = org_id
        if partner is not None:
            _path_params['partner'] = partner
        # process the query parameters
        if product_id is not None:
            
            _query_params.append(('productId', product_id))
            
        if buyer_id is not None:
            
            _query_params.append(('buyerId', buyer_id))
            
        if entitlement_id is not None:
            
            _query_params.append(('entitlementId', entitlement_id))
            
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/org/{orgId}/partner/{partner}/revenueRecordDetail',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_revenue_records(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Cloud Partner")],
        product_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given product ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given entitlement ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given buyer ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListRevenueRecordsResponse:
        """list revenue records

        list the revenue records for the given organization, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner (required)
        :type partner: str
        :param product_id: Filter revenue records by the given product ID
        :type product_id: str
        :param entitlement_id: Filter revenue records by the given entitlement ID
        :type entitlement_id: str
        :param buyer_id: Filter revenue records by the given buyer ID
        :type buyer_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_revenue_records_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            entitlement_id=entitlement_id,
            buyer_id=buyer_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRevenueRecordsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_revenue_records_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Cloud Partner")],
        product_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given product ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given entitlement ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given buyer ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListRevenueRecordsResponse]:
        """list revenue records

        list the revenue records for the given organization, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner (required)
        :type partner: str
        :param product_id: Filter revenue records by the given product ID
        :type product_id: str
        :param entitlement_id: Filter revenue records by the given entitlement ID
        :type entitlement_id: str
        :param buyer_id: Filter revenue records by the given buyer ID
        :type buyer_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_revenue_records_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            entitlement_id=entitlement_id,
            buyer_id=buyer_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRevenueRecordsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_revenue_records_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Cloud Partner")],
        product_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given product ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given entitlement ID")] = None,
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter revenue records by the given buyer ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """list revenue records

        list the revenue records for the given organization, product, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Cloud Partner (required)
        :type partner: str
        :param product_id: Filter revenue records by the given product ID
        :type product_id: str
        :param entitlement_id: Filter revenue records by the given entitlement ID
        :type entitlement_id: str
        :param buyer_id: Filter revenue records by the given buyer ID
        :type buyer_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_revenue_records_serialize(
            org_id=org_id,
            partner=partner,
            product_id=product_id,
            entitlement_id=entitlement_id,
            buyer_id=buyer_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRevenueRecordsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_revenue_records_serialize(
        self,
        org_id,
        partner,
        product_id,
        entitlement_id,
        buyer_id,
        start_date,
        end_date,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_id is not None:
            _path_params['orgId'] = org_id
        if partner is not None:
            _path_params['partner'] = partner
        # process the query parameters
        if product_id is not None:
            
            _query_params.append(('productId', product_id))
            
        if entitlement_id is not None:
            
            _query_params.append(('entitlementId', entitlement_id))
            
        if buyer_id is not None:
            
            _query_params.append(('buyerId', buyer_id))
            
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/org/{orgId}/partner/{partner}/revenueRecord',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_usage_metering_daily_records(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Filter by the Cloud Partner")],
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter usage metering daily records by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter usage metering daily records by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListUsageMeteringDailyRecordsResponse:
        """list usage metering daily records

        list the daily records of the usage metering from the cloud marketplace for the given organization, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Filter by the Cloud Partner (required)
        :type partner: str
        :param buyer_id: Filter usage metering daily records by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter usage metering daily records by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_usage_metering_daily_records_serialize(
            org_id=org_id,
            partner=partner,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListUsageMeteringDailyRecordsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_usage_metering_daily_records_with_http_info(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Filter by the Cloud Partner")],
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter usage metering daily records by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter usage metering daily records by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListUsageMeteringDailyRecordsResponse]:
        """list usage metering daily records

        list the daily records of the usage metering from the cloud marketplace for the given organization, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Filter by the Cloud Partner (required)
        :type partner: str
        :param buyer_id: Filter usage metering daily records by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter usage metering daily records by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_usage_metering_daily_records_serialize(
            org_id=org_id,
            partner=partner,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListUsageMeteringDailyRecordsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_usage_metering_daily_records_without_preload_content(
        self,
        org_id: Annotated[StrictStr, Field(description="Organization ID")],
        partner: Annotated[StrictStr, Field(description="Filter by the Cloud Partner")],
        buyer_id: Annotated[Optional[StrictStr], Field(description="Filter usage metering daily records by the given buyer ID")] = None,
        entitlement_id: Annotated[Optional[StrictStr], Field(description="Filter usage metering daily records by the given entitlement ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="end date (UTC) in YYYY-MM-DD format, default is today")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="List pagination size, default 1000, max value is 1000")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="List pagination offset, default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """list usage metering daily records

        list the daily records of the usage metering from the cloud marketplace for the given organization, entitlement, or buyer.

        :param org_id: Organization ID (required)
        :type org_id: str
        :param partner: Filter by the Cloud Partner (required)
        :type partner: str
        :param buyer_id: Filter usage metering daily records by the given buyer ID
        :type buyer_id: str
        :param entitlement_id: Filter usage metering daily records by the given entitlement ID
        :type entitlement_id: str
        :param start_date: start date (UTC) in YYYY-MM-DD format, default is 30 days before the endDate
        :type start_date: str
        :param end_date: end date (UTC) in YYYY-MM-DD format, default is today
        :type end_date: str
        :param limit: List pagination size, default 1000, max value is 1000
        :type limit: int
        :param offset: List pagination offset, default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_usage_metering_daily_records_serialize(
            org_id=org_id,
            partner=partner,
            buyer_id=buyer_id,
            entitlement_id=entitlement_id,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListUsageMeteringDailyRecordsResponse",
            '400': "str",
            '500': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_usage_metering_daily_records_serialize(
        self,
        org_id,
        partner,
        buyer_id,
        entitlement_id,
        start_date,
        end_date,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_id is not None:
            _path_params['orgId'] = org_id
        if partner is not None:
            _path_params['partner'] = partner
        # process the query parameters
        if buyer_id is not None:
            
            _query_params.append(('buyerId', buyer_id))
            
        if entitlement_id is not None:
            
            _query_params.append(('entitlementId', entitlement_id))
            
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/org/{orgId}/partner/{partner}/usageMeteringDailyRecord',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


