# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.billable_metric_aggregation_type import BillableMetricAggregationType
from suger_sdk_python.models.billable_metric_info import BillableMetricInfo
from suger_sdk_python.models.unique_count_aggregation_result import UniqueCountAggregationResult
from typing import Optional, Set
from typing_extensions import Self

class AggregatedMeteringUsageRecord(BaseModel):
    """
    AggregatedMeteringUsageRecord
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount calculated by billable dimension's price model, this is only used for report billable usage records to marketplace.")
    billable_metric_aggregation_type: Optional[BillableMetricAggregationType] = Field(default=None, alias="billableMetricAggregationType")
    billable_metric_info: Optional[BillableMetricInfo] = Field(default=None, alias="billableMetricInfo")
    group_bys_expression: Optional[StrictStr] = Field(default=None, description="GroupBysExpression is the string expression of array of group bys.", alias="groupBysExpression")
    key: Optional[StrictStr] = Field(default=None, description="Key is the unique identifier of a billable metric.")
    name: Optional[StrictStr] = Field(default=None, description="Name is the name of a billable metric. Optional, it is only for display purpose.")
    quantity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value is the value of a billable metric.")
    unique_count_aggregation_result: Optional[UniqueCountAggregationResult] = Field(default=None, description="Unique count metric aggregate result.", alias="uniqueCountAggregationResult")
    __properties: ClassVar[List[str]] = ["amount", "billableMetricAggregationType", "billableMetricInfo", "groupBysExpression", "key", "name", "quantity", "uniqueCountAggregationResult"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AggregatedMeteringUsageRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of billable_metric_info
        if self.billable_metric_info:
            _dict['billableMetricInfo'] = self.billable_metric_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unique_count_aggregation_result
        if self.unique_count_aggregation_result:
            _dict['uniqueCountAggregationResult'] = self.unique_count_aggregation_result.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AggregatedMeteringUsageRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "billableMetricAggregationType": obj.get("billableMetricAggregationType"),
            "billableMetricInfo": BillableMetricInfo.from_dict(obj["billableMetricInfo"]) if obj.get("billableMetricInfo") is not None else None,
            "groupBysExpression": obj.get("groupBysExpression"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "quantity": obj.get("quantity"),
            "uniqueCountAggregationResult": UniqueCountAggregationResult.from_dict(obj["uniqueCountAggregationResult"]) if obj.get("uniqueCountAggregationResult") is not None else None
        })
        return _obj


