# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_marketplace_agreement_status import AwsMarketplaceAgreementStatus
from typing import Optional, Set
from typing_extensions import Self

class AwsMarketplaceAgreementV2(BaseModel):
    """
    AwsMarketplaceAgreementV2
    """ # noqa: E501
    acceptance_time: Optional[datetime] = Field(default=None, alias="acceptanceTime")
    agreement_id: Optional[StrictStr] = Field(default=None, description="AWS Marketplace Agreement Id", alias="agreementId")
    agreement_type: Optional[StrictStr] = Field(default=None, alias="agreementType")
    buyer_account_id: Optional[StrictStr] = Field(default=None, description="The AWS Account Id of the buyer in AWS Marketplace", alias="buyerAccountId")
    end_time: Optional[datetime] = Field(default=None, alias="endTime")
    offer_id: Optional[StrictStr] = Field(default=None, description="AWS Marketplace Offer Id", alias="offerId")
    product_id: Optional[StrictStr] = Field(default=None, description="AWS Marketplace Product Id", alias="productId")
    product_type: Optional[StrictStr] = Field(default=None, alias="productType")
    seller_account_id: Optional[StrictStr] = Field(default=None, description="The AWS Account Id of the seller in AWS Marketplace", alias="sellerAccountId")
    start_time: Optional[datetime] = Field(default=None, alias="startTime")
    status: Optional[AwsMarketplaceAgreementStatus] = None
    __properties: ClassVar[List[str]] = ["acceptanceTime", "agreementId", "agreementType", "buyerAccountId", "endTime", "offerId", "productId", "productType", "sellerAccountId", "startTime", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsMarketplaceAgreementV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsMarketplaceAgreementV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptanceTime": obj.get("acceptanceTime"),
            "agreementId": obj.get("agreementId"),
            "agreementType": obj.get("agreementType"),
            "buyerAccountId": obj.get("buyerAccountId"),
            "endTime": obj.get("endTime"),
            "offerId": obj.get("offerId"),
            "productId": obj.get("productId"),
            "productType": obj.get("productType"),
            "sellerAccountId": obj.get("sellerAccountId"),
            "startTime": obj.get("startTime"),
            "status": obj.get("status")
        })
        return _obj


