# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_marketplace_catalog_pricing_term_rate_card_constraints import AwsMarketplaceCatalogPricingTermRateCardConstraints
from suger_sdk_python.models.aws_marketplace_catalog_pricing_term_rate_card_item import AwsMarketplaceCatalogPricingTermRateCardItem
from suger_sdk_python.models.aws_marketplace_catalog_pricing_term_rate_card_selector import AwsMarketplaceCatalogPricingTermRateCardSelector
from typing import Optional, Set
from typing_extensions import Self

class AwsMarketplaceCatalogPricingTermRateCard(BaseModel):
    """
    AwsMarketplaceCatalogPricingTermRateCard
    """ # noqa: E501
    constraints: Optional[AwsMarketplaceCatalogPricingTermRateCardConstraints] = Field(default=None, description="Defines constraints on how the term can be configured by acceptors. Applicable only to ConfigurableUpfrontPricingTerm.", alias="Constraints")
    rate_card: Optional[List[AwsMarketplaceCatalogPricingTermRateCardItem]] = Field(default=None, alias="RateCard")
    selector: Optional[AwsMarketplaceCatalogPricingTermRateCardSelector] = Field(default=None, description="Selector is used to differentiate between the mutually exclusive rate cards in the same pricing term, to be selected by the buyer. Applicable only to ConfigurableUpfrontPricingTerm.", alias="Selector")
    __properties: ClassVar[List[str]] = ["Constraints", "RateCard", "Selector"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCatalogPricingTermRateCard from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of constraints
        if self.constraints:
            _dict['Constraints'] = self.constraints.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rate_card (list)
        _items = []
        if self.rate_card:
            for _item_rate_card in self.rate_card:
                if _item_rate_card:
                    _items.append(_item_rate_card.to_dict())
            _dict['RateCard'] = _items
        # override the default output from pydantic by calling `to_dict()` of selector
        if self.selector:
            _dict['Selector'] = self.selector.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCatalogPricingTermRateCard from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Constraints": AwsMarketplaceCatalogPricingTermRateCardConstraints.from_dict(obj["Constraints"]) if obj.get("Constraints") is not None else None,
            "RateCard": [AwsMarketplaceCatalogPricingTermRateCardItem.from_dict(_item) for _item in obj["RateCard"]] if obj.get("RateCard") is not None else None,
            "Selector": AwsMarketplaceCatalogPricingTermRateCardSelector.from_dict(obj["Selector"]) if obj.get("Selector") is not None else None
        })
        return _obj


