# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_marketplace_cppo_discount_type import AwsMarketplaceCppoDiscountType
from suger_sdk_python.models.aws_marketplace_cppo_duration_type import AwsMarketplaceCppoDurationType
from suger_sdk_python.models.aws_marketplace_cppo_opportunity_offer_details import AwsMarketplaceCppoOpportunityOfferDetails
from suger_sdk_python.models.aws_marketplace_cppo_opportunity_rule import AwsMarketplaceCppoOpportunityRule
from suger_sdk_python.models.aws_marketplace_cppo_opportunity_term import AwsMarketplaceCppoOpportunityTerm
from suger_sdk_python.models.aws_marketplace_pre_existing_agreement import AwsMarketplacePreExistingAgreement
from suger_sdk_python.models.aws_product_dimension import AwsProductDimension
from typing import Optional, Set
from typing_extensions import Self

class AwsMarketplaceCppoOpportunity(BaseModel):
    """
    AwsMarketplaceCppoOpportunity
    """ # noqa: E501
    created_date: Optional[StrictStr] = Field(default=None, alias="CreatedDate")
    description: Optional[StrictStr] = Field(default=None, alias="Description")
    dimensions: Optional[List[AwsProductDimension]] = Field(default=None, alias="Dimensions")
    manufacturer_account_id: Optional[StrictStr] = Field(default=None, alias="ManufacturerAccountId")
    manufacturer_legal_name: Optional[StrictStr] = Field(default=None, alias="ManufacturerLegalName")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    offer_details: Optional[AwsMarketplaceCppoOpportunityOfferDetails] = Field(default=None, alias="OfferDetails")
    pre_existing_buyer_agreement: Optional[AwsMarketplacePreExistingAgreement] = Field(default=None, alias="PreExistingBuyerAgreement")
    product_id: Optional[StrictStr] = Field(default=None, alias="ProductId")
    product_name: Optional[StrictStr] = Field(default=None, alias="ProductName")
    rules: Optional[List[AwsMarketplaceCppoOpportunityRule]] = Field(default=None, alias="Rules")
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    terms: Optional[List[AwsMarketplaceCppoOpportunityTerm]] = Field(default=None, alias="Terms")
    discount_type: Optional[AwsMarketplaceCppoDiscountType] = Field(default=None, description="The following fields are not from aws catalog API, only used for cppo_out offer create. They shouldn't be read in other places because they will absent when fetch opportunity from aws catalog API.", alias="discountType")
    opportunity_duration_type: Optional[AwsMarketplaceCppoDurationType] = Field(default=None, alias="opportunityDurationType")
    opportunity_id: Optional[StrictStr] = Field(default=None, alias="opportunityId")
    partner_id: Optional[StrictStr] = Field(default=None, alias="partnerId")
    __properties: ClassVar[List[str]] = ["CreatedDate", "Description", "Dimensions", "ManufacturerAccountId", "ManufacturerLegalName", "Name", "OfferDetails", "PreExistingBuyerAgreement", "ProductId", "ProductName", "Rules", "Status", "Terms", "discountType", "opportunityDurationType", "opportunityId", "partnerId"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Active', 'Restricted', 'Complete']):
            raise ValueError("must be one of enum values ('Active', 'Restricted', 'Complete')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCppoOpportunity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dimensions (list)
        _items = []
        if self.dimensions:
            for _item_dimensions in self.dimensions:
                if _item_dimensions:
                    _items.append(_item_dimensions.to_dict())
            _dict['Dimensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of offer_details
        if self.offer_details:
            _dict['OfferDetails'] = self.offer_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pre_existing_buyer_agreement
        if self.pre_existing_buyer_agreement:
            _dict['PreExistingBuyerAgreement'] = self.pre_existing_buyer_agreement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item_rules in self.rules:
                if _item_rules:
                    _items.append(_item_rules.to_dict())
            _dict['Rules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in terms (list)
        _items = []
        if self.terms:
            for _item_terms in self.terms:
                if _item_terms:
                    _items.append(_item_terms.to_dict())
            _dict['Terms'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCppoOpportunity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CreatedDate": obj.get("CreatedDate"),
            "Description": obj.get("Description"),
            "Dimensions": [AwsProductDimension.from_dict(_item) for _item in obj["Dimensions"]] if obj.get("Dimensions") is not None else None,
            "ManufacturerAccountId": obj.get("ManufacturerAccountId"),
            "ManufacturerLegalName": obj.get("ManufacturerLegalName"),
            "Name": obj.get("Name"),
            "OfferDetails": AwsMarketplaceCppoOpportunityOfferDetails.from_dict(obj["OfferDetails"]) if obj.get("OfferDetails") is not None else None,
            "PreExistingBuyerAgreement": AwsMarketplacePreExistingAgreement.from_dict(obj["PreExistingBuyerAgreement"]) if obj.get("PreExistingBuyerAgreement") is not None else None,
            "ProductId": obj.get("ProductId"),
            "ProductName": obj.get("ProductName"),
            "Rules": [AwsMarketplaceCppoOpportunityRule.from_dict(_item) for _item in obj["Rules"]] if obj.get("Rules") is not None else None,
            "Status": obj.get("Status"),
            "Terms": [AwsMarketplaceCppoOpportunityTerm.from_dict(_item) for _item in obj["Terms"]] if obj.get("Terms") is not None else None,
            "discountType": obj.get("discountType"),
            "opportunityDurationType": obj.get("opportunityDurationType"),
            "opportunityId": obj.get("opportunityId"),
            "partnerId": obj.get("partnerId")
        })
        return _obj


