# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_marketplace_buyer_account import AwsMarketplaceBuyerAccount
from typing import Optional, Set
from typing_extensions import Self

class AwsMarketplaceCppoOpportunityPositiveTargeting(BaseModel):
    """
    AwsMarketplaceCppoOpportunityPositiveTargeting
    """ # noqa: E501
    buyer_accounts: Optional[List[AwsMarketplaceBuyerAccount]] = Field(default=None, description="List of AWS account IDs that are allowed to subscribe to the offer.", alias="BuyerAccounts")
    country_codes: Optional[List[StrictStr]] = Field(default=None, description="List as option for allowing targeting based on country. If the intention isn’t to target the offer to a country, this field should be omitted. If it’s present, the list must contain at least one country code. Each element in this list should be a valid 2-letter country code, using this format: ISO 3166-1 alpha-2.", alias="CountryCodes")
    __properties: ClassVar[List[str]] = ["BuyerAccounts", "CountryCodes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCppoOpportunityPositiveTargeting from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in buyer_accounts (list)
        _items = []
        if self.buyer_accounts:
            for _item_buyer_accounts in self.buyer_accounts:
                if _item_buyer_accounts:
                    _items.append(_item_buyer_accounts.to_dict())
            _dict['BuyerAccounts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCppoOpportunityPositiveTargeting from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "BuyerAccounts": [AwsMarketplaceBuyerAccount.from_dict(_item) for _item in obj["BuyerAccounts"]] if obj.get("BuyerAccounts") is not None else None,
            "CountryCodes": obj.get("CountryCodes")
        })
        return _obj


