# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_marketplace_cppo_opportunity_negative_targeting import AwsMarketplaceCppoOpportunityNegativeTargeting
from suger_sdk_python.models.aws_marketplace_cppo_opportunity_positive_targeting import AwsMarketplaceCppoOpportunityPositiveTargeting
from suger_sdk_python.models.aws_marketplace_cppo_opportunity_rule_type import AwsMarketplaceCppoOpportunityRuleType
from typing import Optional, Set
from typing_extensions import Self

class AwsMarketplaceCppoOpportunityRule(BaseModel):
    """
    AwsMarketplaceCppoOpportunityRule
    """ # noqa: E501
    availability_end_date: Optional[StrictStr] = Field(default=None, alias="AvailabilityEndDate")
    id: Optional[StrictStr] = Field(default=None, description="Output only.", alias="Id")
    negative_targeting: Optional[AwsMarketplaceCppoOpportunityNegativeTargeting] = Field(default=None, description="Negative targeting defines the criteria which any customer's profile should fulfill to be restricted to access the offer.", alias="NegativeTargeting")
    offers_max_quantity: Optional[StrictInt] = Field(default=None, alias="OffersMaxQuantity")
    positive_targeting: Optional[AwsMarketplaceCppoOpportunityPositiveTargeting] = Field(default=None, description="Positive targeting defines the criteria which any buyer's profile should fulfill in order to be allowed to access the offer.", alias="PositiveTargeting")
    reseller_account_id: Optional[StrictStr] = Field(default=None, alias="ResellerAccountId")
    reseller_legal_name: Optional[StrictStr] = Field(default=None, alias="ResellerLegalName")
    type: Optional[AwsMarketplaceCppoOpportunityRuleType] = Field(default=None, alias="Type")
    usage: Optional[StrictStr] = Field(default=None, alias="Usage")
    __properties: ClassVar[List[str]] = ["AvailabilityEndDate", "Id", "NegativeTargeting", "OffersMaxQuantity", "PositiveTargeting", "ResellerAccountId", "ResellerLegalName", "Type", "Usage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCppoOpportunityRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of negative_targeting
        if self.negative_targeting:
            _dict['NegativeTargeting'] = self.negative_targeting.to_dict()
        # override the default output from pydantic by calling `to_dict()` of positive_targeting
        if self.positive_targeting:
            _dict['PositiveTargeting'] = self.positive_targeting.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsMarketplaceCppoOpportunityRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AvailabilityEndDate": obj.get("AvailabilityEndDate"),
            "Id": obj.get("Id"),
            "NegativeTargeting": AwsMarketplaceCppoOpportunityNegativeTargeting.from_dict(obj["NegativeTargeting"]) if obj.get("NegativeTargeting") is not None else None,
            "OffersMaxQuantity": obj.get("OffersMaxQuantity"),
            "PositiveTargeting": AwsMarketplaceCppoOpportunityPositiveTargeting.from_dict(obj["PositiveTargeting"]) if obj.get("PositiveTargeting") is not None else None,
            "ResellerAccountId": obj.get("ResellerAccountId"),
            "ResellerLegalName": obj.get("ResellerLegalName"),
            "Type": obj.get("Type"),
            "Usage": obj.get("Usage")
        })
        return _obj


