# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_marketplace_catalog_pricing_model import AwsMarketplaceCatalogPricingModel
from suger_sdk_python.models.aws_renewal_offer_type import AwsRenewalOfferType
from typing import Optional, Set
from typing_extensions import Self

class AwsMarketplacePreExistingAgreement(BaseModel):
    """
    AwsMarketplacePreExistingAgreement
    """ # noqa: E501
    acquisition_channel: Optional[AwsRenewalOfferType] = Field(default=None, description="Indicates if the existing agreement was signed outside AWS Marketplace or within AWS Marketplace. one of values [\"External\", \"AwsMarketplace\"]", alias="AcquisitionChannel")
    pricing_model: Optional[AwsMarketplaceCatalogPricingModel] = Field(default=None, description="Indicates which pricing model the existing agreement uses.", alias="PricingModel")
    __properties: ClassVar[List[str]] = ["AcquisitionChannel", "PricingModel"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsMarketplacePreExistingAgreement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsMarketplacePreExistingAgreement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AcquisitionChannel": obj.get("AcquisitionChannel"),
            "PricingModel": obj.get("PricingModel")
        })
        return _obj


